/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.common.collect.Lists;
import cubex2.cs4.api.ContentHelper;
import cubex2.cs4.api.InitPhase;
import cubex2.cs4.api.RecipeInput;
import cubex2.cs4.api.WrappedItemStack;
import cubex2.cs4.data.SimpleContent;
import cubex2.cs4.plugins.jei.JEICompatRegistry;
import cubex2.cs4.plugins.vanilla.DamageableShapelessOreRecipe;
import cubex2.cs4.plugins.vanilla.crafting.CraftingManagerCS4;
import cubex2.cs4.util.ItemHelper;
import cubex2.cs4.util.ReflectionHelper;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

class ShapelessRecipe
extends SimpleContent {
    List<RecipeInput> items = Lists.newArrayList();
    WrappedItemStack result;
    boolean remove = false;
    ResourceLocation recipeList = new ResourceLocation("minecraft", "vanilla");
    int[] damage = new int[0];

    ShapelessRecipe() {
    }

    @Override
    protected void doInit(InitPhase phase, ContentHelper helper) {
        if (this.remove) {
            if (!this.recipeList.toString().equals("minecraft:vanilla")) {
                this.removeRecipe(CraftingManagerCS4.getRecipes(this.recipeList));
            }
        } else {
            this.addRecipe();
        }
    }

    @Override
    protected boolean isReady() {
        if (this.result != null && !this.result.isItemLoaded()) {
            return false;
        }
        return this.items.stream().allMatch(input -> input.isOreClass() || input.isItemStack() && input.getStack().isItemLoaded());
    }

    boolean removeRecipe(Collection<IRecipe> from) {
        if (this.items.size() == 0) {
            return this.removeWithResult(from);
        }
        if (this.result == null) {
            return this.removeWithInput(from);
        }
        return this.removeWithBoth(from);
    }

    private boolean removeWithResult(Collection<IRecipe> from) {
        return from.removeIf(this::matchesOutput);
    }

    private boolean removeWithInput(Collection<IRecipe> from) {
        List recipes = from.stream().filter(this::matchesInput).collect(Collectors.toList());
        return from.removeAll(recipes);
    }

    private boolean removeWithBoth(Collection<IRecipe> from) {
        List recipes = from.stream().filter(this::matchesOutput).filter(this::matchesInput).collect(Collectors.toList());
        return from.removeAll(recipes);
    }

    private boolean matchesOutput(IRecipe recipe) {
        return OreDictionary.itemMatches((ItemStack)recipe.func_77571_b(), (ItemStack)this.result.getItemStack(), (boolean)false);
    }

    private boolean matchesInput(IRecipe recipe) {
        if (recipe instanceof ShapelessRecipes) {
            return this.matchesInput((ShapelessRecipes)recipe);
        }
        if (recipe instanceof ShapelessOreRecipe) {
            return this.matchesInput((ShapelessOreRecipe)recipe);
        }
        return false;
    }

    private boolean matchesInput(ShapelessRecipes recipe) {
        if (this.isOreRecipe()) {
            return false;
        }
        if (recipe.field_77579_b.size() != this.getRecipeSize()) {
            return false;
        }
        Object[] input = this.getRecipeInput();
        for (int i = 0; i < recipe.field_77579_b.size(); ++i) {
            ItemStack source;
            Ingredient target = (Ingredient)recipe.field_77579_b.get(i);
            if (target.apply(source = (ItemStack)input[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isOreRecipe() {
        return this.items.stream().anyMatch(RecipeInput::isOreClass);
    }

    private int getRecipeSize() {
        return this.items.size();
    }

    private boolean matchesInput(ShapelessOreRecipe recipe) {
        if (recipe.func_192400_c().size() != this.getRecipeSize()) {
            return false;
        }
        Object[] input = this.getRecipeInput();
        for (int i = 0; i < recipe.func_192400_c().size(); ++i) {
            Object source;
            Ingredient target = (Ingredient)recipe.func_192400_c().get(i);
            if (ItemHelper.isSameRecipeInput(target, source = input[i])) continue;
            return false;
        }
        return true;
    }

    void addRecipe() {
        if (this.damage.length == 0) {
            this.damage = new int[this.items.size()];
        }
        Class<DamageableShapelessOreRecipe> recipeClass = JEICompatRegistry.getShapelessCraftingRecipeClass(this.recipeList);
        Constructor<DamageableShapelessOreRecipe> constructor = ReflectionHelper.getConstructor(recipeClass, ResourceLocation.class, int[].class, ItemStack.class, Object[].class);
        DamageableShapelessOreRecipe recipe = ReflectionHelper.newInstance(constructor, null, this.damage, this.result.getItemStack(), this.getInputForRecipe());
        if (recipe != null) {
            CraftingManagerCS4.addRecipe(this.recipeList, (IRecipe)recipe);
        }
    }

    Object[] getInputForRecipe() {
        return this.items.stream().map(input -> input.isOreClass() ? input.getOreClass().getOreName() : input.getStack().getItemStack()).toArray();
    }

    Object[] getRecipeInput() {
        return this.items.stream().map(input -> input.isOreClass() ? OreDictionary.getOres((String)input.getOreClass().getOreName()) : input.getStack().getItemStack()).toArray();
    }
}

