/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.gctweaks.base;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.romvoid95.gctweaks.GalacticTweaks;
import net.romvoid95.gctweaks.base.InternalFeature;

public abstract class InternalModule {
    private List<InternalFeature> internals = new ArrayList<InternalFeature>();

    public abstract void addInternalFeature();

    public InternalModule() {
        this.addInternalFeature();
    }

    public void preInit() {
        this.internals.stream().filter(InternalFeature::usesEvents).forEach(arg_0 -> ((EventBus)MinecraftForge.EVENT_BUS).register(arg_0));
        this.internals.forEach(InternalFeature::preInit);
    }

    public void init() {
        this.internals.forEach(InternalFeature::init);
    }

    public void postInit() {
        this.internals.forEach(InternalFeature::postInit);
    }

    public void proxyPreInit() {
        this.internals.stream().filter(InternalFeature::sidedProxy).forEach(arg_0 -> ((EventBus)MinecraftForge.EVENT_BUS).register(arg_0));
        this.internals.forEach(InternalFeature::proxyPreInit);
    }

    public void proxyInit() {
        this.internals.forEach(InternalFeature::proxyInit);
    }

    public void proxyPostInit() {
        this.internals.forEach(InternalFeature::proxyPostInit);
    }

    public void serverStartingEvent(FMLServerStartingEvent event) {
        this.internals.forEach(internal -> internal.ServerStartingEvent(event));
    }

    protected void registerInternalFeature(InternalFeature feature) {
        this.internals.add(feature);
    }

    public void registerPacket() {
        this.internals.forEach(feature -> feature.registerPacket(GalacticTweaks.network));
    }
}

