/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.gctweaks.gc.features;

import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.romvoid95.gctweaks.base.Feature;

public class SpawnDimension
extends Feature {
    private static boolean enableSpawnDimension;
    private static boolean firstJoinOnly;
    private static boolean everyDeath;
    private static boolean useCoord;
    private static int spawnDimId;
    private static String spawnPos;

    @Override
    public String category() {
        return "dimensionSpawn";
    }

    @Override
    public String comment() {
        return "Set a certain Planet or Moon as a Spawn Point\n\nYou should have SPAWN-ITEMS Configured and set prior to enabling this setting\nAt the moment any moon or planet set to spawn in uses that bodies teleport system (spawns in the lander)";
    }

    @Override
    public void syncConfig(String category) {
        enableSpawnDimension = this.set(category, "enableFeature", false);
        useCoord = this.set(category, "useCoord", "If \"true\" custom spawn will use the coordinates set in \"spawnCoords\" below\n [default: false]", false);
        firstJoinOnly = this.set(category, "firstJoinOnly", "If \"true\" players are only sent to the spawn dimension on their first time joining.\nIf \"false\" players are sent every join\n [default: false]", true);
        everyDeath = this.set(category, "everyRespawn", "If \"true\" players are sent to the spawn dimensionevery death respawn.\n [default: false]", false);
        spawnDimId = this.set(category, "dimensionId", "Set the Dimension ID of the planet/moon you want players join on\nsee file under `config\\GalacticTweaks\\ValidDimensions.txt` for valid dimension ID's\n", 0);
        spawnPos = this.set(category, "spawnCoords", "Set the spawn position for players to spawn at", "128,64,128");
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (enableSpawnDimension) {
            this.handleLoggingEvent(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (enableSpawnDimension) {
            this.handleRespawnEvent(event);
        }
    }

    private void handleLoggingEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayer) {
            EntityPlayer player = event.player;
            if (firstJoinOnly) {
                NBTTagCompound entityData = player.getEntityData();
                NBTTagCompound persistedData = entityData.func_74775_l("PlayerPersisted");
                entityData.func_74782_a("PlayerPersisted", (NBTBase)persistedData);
                String key = "gctweaks:FirstSpawn";
                if (!persistedData.func_74767_n("gctweaks:FirstSpawn")) {
                    this.teleport((EntityPlayerMP)player, spawnDimId);
                    persistedData.func_74757_a("gctweaks:FirstSpawn", true);
                }
            } else if (!firstJoinOnly) {
                this.teleport((EntityPlayerMP)player, spawnDimId);
            }
        }
    }

    private void handleRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        if (everyDeath && event.player instanceof EntityPlayer) {
            EntityPlayer player = event.player;
            this.teleport((EntityPlayerMP)player, spawnDimId);
        }
    }

    private void teleport(EntityPlayerMP player, int dimId) {
        BlockPos pos;
        MinecraftServer mcServer = player.func_184102_h();
        WorldServer world = mcServer.func_71218_a(dimId);
        String[] spawnString = spawnPos.split(",");
        if (useCoord) {
            pos = new BlockPos(Integer.valueOf(spawnString[0]).intValue(), Integer.valueOf(spawnString[1]).intValue(), Integer.valueOf(spawnString[2]).intValue());
        } else {
            int y = world.func_175726_f(world.func_175694_M()).func_177433_f(world.func_175694_M());
            pos = new BlockPos(world.func_175694_M().func_177958_n(), y, world.func_175694_M().func_177952_p());
        }
        WorldUtil.teleportEntitySimple((World)world, (int)dimId, (EntityPlayerMP)player, (Vector3)new Vector3(pos));
    }
}

