/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.gctweaks.internal.config;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.romvoid95.gctweaks.GalacticTweaks;

public class ConfigCore {
    static Configuration config;
    public static boolean enableCheckVersion;
    public static boolean enableDebugOutput;
    private static Map<String, List<String>> propOrder;
    private static String currentCat;

    public ConfigCore(File file) {
        config = new Configuration(file, "1.0");
        ConfigCore.syncConfig(true);
    }

    public static void syncConfig(boolean load) {
        try {
            propOrder.clear();
            if (!ConfigCore.config.isChild && load) {
                config.load();
            }
            config.addCustomCategoryComment("Core Mod Settings", "Core Mod Settings");
            config.setCategoryLanguageKey("Core Mod Settings", "galactictweaks.configgui.category.core");
            config.setCategoryRequiresMcRestart("Core Mod Settings", true);
            Property prop = ConfigCore.getConfig("Core Mod Settings", "enableCheckVersion", true);
            prop.setComment("Enable/Disable Check Version");
            prop.setLanguageKey("galactictweaks.configgui.enableCheckVersion");
            enableCheckVersion = prop.getBoolean(true);
            ConfigCore.finishProp(prop);
            prop = ConfigCore.getConfig("Core Mod Settings", "enableDebugOutput", false);
            prop.setComment("Enable/Disable Debug Information in Logs");
            prop.setLanguageKey("galactictweaks.configgui.enableDebugOutput");
            enableDebugOutput = prop.getBoolean(false);
            ConfigCore.finishProp(prop);
            if (config.hasChanged()) {
                config.save();
            }
        }
        catch (Exception e) {
            GalacticTweaks.logger.warn("GalacticTweaks Core Config had an issue loading the config file!");
        }
    }

    public static void cleanConfig(Configuration config, Map<String, List<String>> propOrder) {
        LinkedList<String> categoriesToRemove = new LinkedList<String>();
        for (String catName : config.getCategoryNames()) {
            List<String> newProps = propOrder.get(catName);
            if (newProps == null) {
                categoriesToRemove.add(catName);
                continue;
            }
            ConfigCategory cat = config.getCategory(catName);
            LinkedList<String> toRemove = new LinkedList<String>();
            for (String oldprop : cat.keySet()) {
                if (newProps.contains(oldprop)) continue;
                toRemove.add(oldprop);
            }
            for (String removeMe : toRemove) {
                cat.remove((Object)removeMe);
            }
            config.setCategoryPropertyOrder(catName, propOrder.get(catName));
        }
        for (String catName : categoriesToRemove) {
            config.removeCategory(config.getCategory(catName));
        }
    }

    private static Property getConfig(String cat, String key, boolean defaultValue) {
        config.moveProperty("Core Mod Settings", key, cat);
        currentCat = cat;
        return config.get(cat, key, defaultValue);
    }

    private static void finishProp(Property prop) {
        if (propOrder.get(currentCat) == null) {
            propOrder.put(currentCat, new ArrayList());
        }
        propOrder.get(currentCat).add(prop.getName());
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        ConfigCategory configGeneral = config.getCategory("Core Mod Settings");
        configGeneral.setComment("Core Settings");
        list.add((IConfigElement)new ConfigElement(configGeneral));
        return list;
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals("gctweaks")) {
            config.save();
        }
    }

    static {
        propOrder = new TreeMap<String, List<String>>();
    }
}

