/*
 * Decompiled with CFR 0.152.
 */
package nc.gui.processor;

import java.io.IOException;
import nc.container.processor.ContainerSorptions;
import nc.gui.NCGui;
import nc.gui.element.GuiBlockRenderer;
import nc.gui.element.NCEnumButton;
import nc.network.PacketHandler;
import nc.network.gui.ResetTankSorptionsPacket;
import nc.network.gui.ToggleTankOutputSettingPacket;
import nc.network.gui.ToggleTankSorptionPacket;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.TankSorption;
import nc.util.BlockHelper;
import nc.util.Lang;
import nc.util.NCUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class GuiFluidSorptions
extends NCGui {
    protected final NCGui parent;
    protected final ITileFluid tile;
    protected final EnumFacing[] dirs;
    protected final int slot;
    protected final TankSorption.Type sorptionType;
    protected static ResourceLocation gui_textures;
    protected int[] a;
    protected int[] b;

    public GuiFluidSorptions(NCGui parent, ITileFluid tile, int slot, TankSorption.Type sorptionType) {
        super(new ContainerSorptions(tile));
        this.parent = parent;
        this.tile = tile;
        EnumFacing facing = tile.getFacingHorizontal();
        this.dirs = new EnumFacing[]{BlockHelper.bottom(facing), BlockHelper.top(facing), BlockHelper.left(facing), BlockHelper.right(facing), BlockHelper.front(facing), BlockHelper.back(facing)};
        this.slot = slot;
        this.sorptionType = sorptionType;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.isEscapeKeyDown(keyCode)) {
            FMLCommonHandler.instance().showGuiScreen((Object)this.parent);
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    @Override
    public void renderTooltips(int mouseX, int mouseY) {
        this.drawTooltip(Lang.localise("gui.container.bottom_config") + " " + this.tile.getTankSorption(this.dirs[0], this.slot).getTextColor() + Lang.localise("gui.container." + this.tile.getTankSorption(this.dirs[0], this.slot).func_176610_l() + "_config"), mouseX, mouseY, this.a[0], this.b[0], 18, 18);
        this.drawTooltip(Lang.localise("gui.container.top_config") + " " + this.tile.getTankSorption(this.dirs[1], this.slot).getTextColor() + Lang.localise("gui.container." + this.tile.getTankSorption(this.dirs[1], this.slot).func_176610_l() + "_config"), mouseX, mouseY, this.a[1], this.b[1], 18, 18);
        this.drawTooltip(Lang.localise("gui.container.left_config") + " " + this.tile.getTankSorption(this.dirs[2], this.slot).getTextColor() + Lang.localise("gui.container." + this.tile.getTankSorption(this.dirs[2], this.slot).func_176610_l() + "_config"), mouseX, mouseY, this.a[2], this.b[2], 18, 18);
        this.drawTooltip(Lang.localise("gui.container.right_config") + " " + this.tile.getTankSorption(this.dirs[3], this.slot).getTextColor() + Lang.localise("gui.container." + this.tile.getTankSorption(this.dirs[3], this.slot).func_176610_l() + "_config"), mouseX, mouseY, this.a[3], this.b[3], 18, 18);
        this.drawTooltip(Lang.localise("gui.container.front_config") + " " + this.tile.getTankSorption(this.dirs[4], this.slot).getTextColor() + Lang.localise("gui.container." + this.tile.getTankSorption(this.dirs[4], this.slot).func_176610_l() + "_config"), mouseX, mouseY, this.a[4], this.b[4], 18, 18);
        this.drawTooltip(Lang.localise("gui.container.back_config") + " " + this.tile.getTankSorption(this.dirs[5], this.slot).getTextColor() + Lang.localise("gui.container." + this.tile.getTankSorption(this.dirs[5], this.slot).func_176610_l() + "_config"), mouseX, mouseY, this.a[5], this.b[5], 18, 18);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        IBlockState state = this.tile.getBlockState(this.tile.getTilePos());
        for (int i = 0; i < 6; ++i) {
            GuiBlockRenderer.renderGuiBlock(state, this.dirs[i], this.a[i] + 1, this.b[i] + 1, this.field_73735_i, 16, 16);
        }
        GlStateManager.func_179121_F();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(gui_textures);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        for (int i = 0; i < 6; ++i) {
            this.field_146292_n.add(new NCEnumButton.TankSorption(i, this.field_147003_i + this.a[i], this.field_147009_r + this.b[i], this.tile.getTankSorption(this.dirs[i], this.slot), this.sorptionType));
        }
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (this.tile.getTileWorld().field_72995_K) {
            for (int i = 0; i < 6; ++i) {
                if (guiButton.field_146127_k != i) continue;
                if (i == 4 && NCUtil.isModifierKeyDown()) {
                    for (int j = 0; j < 6; ++j) {
                        this.tile.setTankSorption(this.dirs[j], this.slot, TankSorption.NON);
                        ((NCEnumButton.TankSorption)((Object)this.field_146292_n.get(j))).set(TankSorption.NON);
                    }
                    PacketHandler.instance.sendToServer((IMessage)new ResetTankSorptionsPacket(this.tile, this.slot, false));
                    return;
                }
                this.tile.toggleTankSorption(this.dirs[i], this.slot, this.sorptionType, false);
                PacketHandler.instance.sendToServer((IMessage)new ToggleTankSorptionPacket(this.tile, this.dirs[i], this.slot, this.tile.getTankSorption(this.dirs[i], this.slot)));
                return;
            }
        }
    }

    @Override
    protected void actionPerformedRight(GuiButton guiButton) {
        if (this.tile.getTileWorld().field_72995_K) {
            for (int i = 0; i < 6; ++i) {
                if (guiButton.field_146127_k != i) continue;
                if (i == 4 && NCUtil.isModifierKeyDown()) {
                    for (int j = 0; j < 6; ++j) {
                        TankSorption sorption = this.tile.getFluidConnection(this.dirs[j]).getDefaultTankSorption(this.slot);
                        this.tile.setTankSorption(this.dirs[j], this.slot, sorption);
                        ((NCEnumButton.TankSorption)((Object)this.field_146292_n.get(j))).set(sorption);
                    }
                    PacketHandler.instance.sendToServer((IMessage)new ResetTankSorptionsPacket(this.tile, this.slot, true));
                    return;
                }
                this.tile.toggleTankSorption(this.dirs[i], this.slot, this.sorptionType, true);
                PacketHandler.instance.sendToServer((IMessage)new ToggleTankSorptionPacket(this.tile, this.dirs[i], this.slot, this.tile.getTankSorption(this.dirs[i], this.slot)));
            }
        }
    }

    public static class Output
    extends GuiFluidSorptions {
        public Output(NCGui parent, ITileFluid tile, int slot) {
            super(parent, tile, slot, TankSorption.Type.OUTPUT);
            gui_textures = new ResourceLocation("nuclearcraft:textures/gui/container/output_fluid_config.png");
            this.a = new int[]{47, 47, 29, 65, 47, 65};
            this.b = new int[]{43, 7, 25, 25, 25, 43};
            this.field_146999_f = 90;
            this.field_147000_g = 68;
        }

        @Override
        public void renderTooltips(int mouseX, int mouseY) {
            super.renderTooltips(mouseX, mouseY);
            this.drawTooltip(Lang.localise("gui.container.tank_setting_config") + " " + this.tile.getTankOutputSetting(this.slot).getTextColor() + Lang.localise("gui.container." + this.tile.getTankOutputSetting(this.slot).func_176610_l() + "_setting_config"), mouseX, mouseY, 7, 25, 18, 18);
        }

        @Override
        public void func_73866_w_() {
            super.func_73866_w_();
            this.field_146292_n.add(new NCEnumButton.TankOutputSetting(6, this.field_147003_i + 7, this.field_147009_r + 25, this.tile.getTankOutputSetting(this.slot)));
        }

        @Override
        protected void func_146284_a(GuiButton guiButton) {
            super.func_146284_a(guiButton);
            if (this.tile.getTileWorld().field_72995_K && guiButton.field_146127_k == 6) {
                this.tile.setTankOutputSetting(this.slot, this.tile.getTankOutputSetting(this.slot).next(false));
                PacketHandler.instance.sendToServer((IMessage)new ToggleTankOutputSettingPacket(this.tile, this.slot, this.tile.getTankOutputSetting(this.slot)));
            }
        }

        @Override
        protected void actionPerformedRight(GuiButton guiButton) {
            super.actionPerformedRight(guiButton);
            if (this.tile.getTileWorld().field_72995_K && guiButton.field_146127_k == 6) {
                this.tile.setTankOutputSetting(this.slot, this.tile.getTankOutputSetting(this.slot).next(true));
                PacketHandler.instance.sendToServer((IMessage)new ToggleTankOutputSettingPacket(this.tile, this.slot, this.tile.getTankOutputSetting(this.slot)));
            }
        }
    }

    public static class Input
    extends GuiFluidSorptions {
        public Input(NCGui parent, ITileFluid tile, int slot) {
            super(parent, tile, slot, TankSorption.Type.INPUT);
            gui_textures = new ResourceLocation("nuclearcraft:textures/gui/container/input_fluid_config.png");
            this.a = new int[]{25, 25, 7, 43, 25, 43};
            this.b = new int[]{43, 7, 25, 25, 25, 43};
            this.field_146999_f = 68;
            this.field_147000_g = 68;
        }
    }
}

