/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.data;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import io.github.phantamanta44.libnine.util.ImpossibilityRealizedException;
import io.github.phantamanta44.libnine.util.math.Vec2i;
import io.github.phantamanta44.libnine.util.world.WorldBlockPos;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.UUID;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ByteUtils {
    public static Writer writer() {
        return new Writer();
    }

    public static Reader reader(byte[] data) {
        return new Reader(data);
    }

    public static class Reader {
        private final byte[] data;
        private int pointer;

        Reader(byte[] data) {
            this.data = data;
            this.pointer = 0;
        }

        public Reader backUp(int bytes) {
            this.pointer = Math.max(this.pointer - bytes, 0);
            return this;
        }

        public Reader advance(int bytes) {
            this.pointer += bytes;
            return this;
        }

        public byte[] readBytes(int length) {
            this.pointer += length;
            return Arrays.copyOfRange(this.data, this.pointer - length, this.pointer);
        }

        public byte readByte() {
            return this.data[this.pointer++];
        }

        public int readInt() {
            int value = 0;
            for (int i = 0; i < 4; ++i) {
                value |= Byte.toUnsignedInt(this.data[this.pointer + i]) << i * 8;
            }
            this.pointer += 4;
            return value;
        }

        public float readFloat() {
            return Float.intBitsToFloat(this.readInt());
        }

        public double readDouble() {
            return Double.longBitsToDouble(this.readLong());
        }

        public short readShort() {
            short value = 0;
            for (int i = 0; i < 2; ++i) {
                value = (short)(value | Byte.toUnsignedInt(this.data[this.pointer + i]) << i * 8);
            }
            this.pointer += 2;
            return value;
        }

        public long readLong() {
            long value = 0L;
            for (int i = 0; i < 8; ++i) {
                value |= Byte.toUnsignedLong(this.data[this.pointer + i]) << i * 8;
            }
            this.pointer += 8;
            return value;
        }

        public boolean readBool() {
            return this.readByte() != 0;
        }

        public int readVarPrecision() {
            byte chunk;
            int value = 0;
            int i = 0;
            do {
                chunk = this.readByte();
                value |= (chunk & 0x7F) << 7 * i++;
            } while ((chunk & 0x80) == 0);
            return value;
        }

        public String readString() {
            int length = this.readVarPrecision();
            this.pointer += length;
            return new String(this.data, this.pointer - length, length, StandardCharsets.UTF_8);
        }

        public NBTTagCompound readTagCompound() {
            try {
                int length = this.readVarPrecision();
                return CompressedStreamTools.func_152456_a((DataInput)ByteStreams.newDataInput((byte[])this.readBytes(length)), (NBTSizeTracker)NBTSizeTracker.field_152451_a);
            }
            catch (Exception e) {
                throw new ImpossibilityRealizedException(e);
            }
        }

        public ItemStack readItemStack() {
            short id = this.readShort();
            if (id == -1) {
                return ItemStack.field_190927_a;
            }
            Item item = Item.func_150899_d((int)id);
            byte amount = this.readByte();
            short meta = this.readShort();
            ItemStack stack = new ItemStack(item, (int)amount, (int)meta);
            if (this.readBool()) {
                stack.func_77982_d(this.readTagCompound());
            }
            return stack;
        }

        public Fluid readFluid() {
            return FluidRegistry.getFluid((String)this.readString());
        }

        public FluidStack readFluidStack() {
            Fluid fluid = this.readFluid();
            int amount = this.readInt();
            FluidStack stack = new FluidStack(fluid, amount);
            if (this.readBool()) {
                stack.tag = this.readTagCompound();
            }
            return stack;
        }

        public BlockPos readBlockPos() {
            return new BlockPos(this.readInt(), this.readInt(), this.readInt());
        }

        public WorldBlockPos readWorldBlockPos() {
            return new WorldBlockPos(this.readInt(), this.readBlockPos());
        }

        public Vec3d readVec3d() {
            return new Vec3d(this.readDouble(), this.readDouble(), this.readDouble());
        }

        public Vec2i readVec2i() {
            return new Vec2i(this.readInt(), this.readInt());
        }

        public UUID readUuid() {
            return UUID.fromString(this.readString());
        }
    }

    public static class Writer {
        private final LinkedList<byte[]> data = new LinkedList();
        private int length = 0;

        Writer() {
        }

        public Writer writeBytes(byte[] b) {
            this.data.add(b);
            this.length += b.length;
            return this;
        }

        public Writer writeByte(byte i) {
            this.data.add(new byte[]{i});
            ++this.length;
            return this;
        }

        public Writer writeInt(int i) {
            byte[] bytes = new byte[4];
            for (int k = 0; k < bytes.length; ++k) {
                bytes[k] = (byte)((i & 255 << k * 8) >> k * 8);
            }
            return this.writeBytes(bytes);
        }

        public Writer writeFloat(float f) {
            return this.writeInt(Float.floatToRawIntBits(f));
        }

        public Writer writeDouble(double f) {
            return this.writeLong(Double.doubleToRawLongBits(f));
        }

        public Writer writeShort(short i) {
            byte[] bytes = new byte[2];
            for (int k = 0; k < bytes.length; ++k) {
                bytes[k] = (byte)((i & 255 << k * 8) >> k * 8);
            }
            return this.writeBytes(bytes);
        }

        public Writer writeLong(long i) {
            byte[] bytes = new byte[8];
            for (int k = 0; k < bytes.length; ++k) {
                bytes[k] = (byte)((i & 255L << k * 8) >> k * 8);
            }
            return this.writeBytes(bytes);
        }

        public Writer writeBool(boolean b) {
            return this.writeByte(b ? (byte)1 : 0);
        }

        public Writer writeVarPrecision(int i) {
            while (true) {
                int afterShift;
                if ((afterShift = i >>> 7) == 0) break;
                this.writeByte((byte)(i & 0x7F));
                i = afterShift;
            }
            this.writeByte((byte)(i & 0x7F | 0x80));
            return this;
        }

        public Writer writeString(String s) {
            byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
            return this.writeVarPrecision(bytes.length).writeBytes(bytes);
        }

        public Writer writeTagCompound(NBTTagCompound tag) {
            try {
                ByteArrayDataOutput buf = ByteStreams.newDataOutput();
                CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)buf);
                byte[] bytes = buf.toByteArray();
                return this.writeVarPrecision(bytes.length).writeBytes(bytes);
            }
            catch (IOException e) {
                throw new ImpossibilityRealizedException(e);
            }
        }

        public Writer writeItemStack(ItemStack stack) {
            NBTTagCompound tag;
            if (stack.func_190926_b()) {
                return this.writeShort((short)-1);
            }
            this.writeShort((short)Item.func_150891_b((Item)stack.func_77973_b())).writeByte((byte)stack.func_190916_E()).writeShort((short)stack.func_77960_j());
            if ((stack.func_77973_b().func_77645_m() || stack.func_77973_b().func_77651_p()) && (tag = stack.func_77973_b().getNBTShareTag(stack)) != null) {
                return this.writeBool(true).writeTagCompound(tag);
            }
            return this.writeBool(false);
        }

        public Writer writeFluid(Fluid fluid) {
            return this.writeString(fluid.getName());
        }

        public Writer writeFluidStack(FluidStack stack) {
            this.writeFluid(stack.getFluid()).writeInt(stack.amount);
            return stack.tag != null ? this.writeBool(true).writeTagCompound(stack.tag) : this.writeBool(false);
        }

        public Writer writeBlockPos(BlockPos pos) {
            return this.writeInt(pos.func_177958_n()).writeInt(pos.func_177956_o()).writeInt(pos.func_177952_p());
        }

        public Writer writeWorldBlockPos(WorldBlockPos pos) {
            return this.writeInt(pos.getDimId()).writeBlockPos(pos.getPos());
        }

        public Writer writeVec3d(Vec3d vec) {
            return this.writeDouble(vec.field_72450_a).writeDouble(vec.field_72448_b).writeDouble(vec.field_72449_c);
        }

        public Writer writeVec2i(Vec2i vec) {
            return this.writeInt(vec.getX()).writeInt(vec.getY());
        }

        public Writer writeUuid(UUID id) {
            return this.writeString(id.toString());
        }

        public byte[] toArray() {
            byte[] buf = new byte[this.length];
            int pointer = 0;
            for (byte[] chunk : this.data) {
                System.arraycopy(chunk, 0, buf, pointer, chunk.length);
                pointer += chunk.length;
            }
            return buf;
        }
    }
}

