/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.tuple;

import io.github.phantamanta44.libnine.util.tuple.ITriple;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public interface IPair<A, B> {
    public A getA();

    public B getB();

    default public <T> ITriple<T, A, B> promoteA(T value) {
        return ITriple.of(value, this.getA(), this.getB());
    }

    default public <T> ITriple<A, T, B> promoteB(T value) {
        return ITriple.of(this.getA(), value, this.getB());
    }

    default public <T> ITriple<A, B, T> promoteC(T value) {
        return ITriple.of(this.getA(), this.getB(), value);
    }

    default public void sprexec(BiConsumer<A, B> executor) {
        executor.accept(this.getA(), this.getB());
    }

    default public <T> T sprcall(BiFunction<A, B, T> executor) {
        return executor.apply(this.getA(), this.getB());
    }

    public static <A, B> IPair<A, B> of(A a, B b) {
        return new Impl(a, b);
    }

    public static class Impl<A, B>
    implements IPair<A, B> {
        private final A a;
        private final B b;

        private Impl(A a, B b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public A getA() {
            return this.a;
        }

        @Override
        public B getB() {
            return this.b;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IPair)) {
                return false;
            }
            IPair pair = (IPair)o;
            return pair.getA().equals(this.a) && pair.getB().equals(this.b);
        }

        public int hashCode() {
            return this.a.hashCode() ^ this.b.hashCode();
        }
    }
}

