/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.entity.EntityFlameRing;
import vazkii.botania.common.item.ItemMod;

public class ItemFireRod
extends ItemMod
implements IManaUsingItem,
IAvatarWieldable {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatar_fire.png");
    private static final int COST = 900;
    private static final int COOLDOWN = 1200;

    public ItemFireRod() {
        super("fireRod");
        this.func_77625_d(1);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float par8, float par9, float par10) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && ManaItemHandler.requestManaExactForTool(stack, player, 900, false)) {
            EntityFlameRing entity = new EntityFlameRing(player.field_70170_p);
            entity.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
            player.field_70170_p.func_72838_d((Entity)entity);
            player.func_184811_cZ().func_185145_a((Item)this, IManaProficiencyArmor.Helper.hasProficiency(player, stack) ? 600 : 1200);
            ManaItemHandler.requestManaExactForTool(stack, player, 900, true);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187594_A, SoundCategory.PLAYERS, 1.0f, 1.0f);
            if (stack.func_77952_i() > 0) {
                stack.func_77964_b(0);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public void onAvatarUpdate(IAvatarTile tile, ItemStack stack) {
        TileEntity te = (TileEntity)tile;
        World world = te.func_145831_w();
        if (!world.field_72995_K && tile.getCurrentMana() >= 900 && tile.getElapsedFunctionalTicks() % 300 == 0 && tile.isEnabled()) {
            EntityFlameRing entity = new EntityFlameRing(world);
            entity.func_70107_b((double)te.func_174877_v().func_177958_n() + 0.5, te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p() + 0.5);
            world.func_72838_d((Entity)entity);
            tile.recieveMana(-900);
        }
    }

    @Override
    public ResourceLocation getOverlayResource(IAvatarTile tile, ItemStack stack) {
        return avatarOverlay;
    }
}

