/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.tileentity.turrets;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import omtteam.omlib.api.render.ColorOM;
import omtteam.omlib.network.OMLibNetworkingHandler;
import omtteam.omlib.network.messages.render.MessageRenderRay;
import omtteam.omlib.util.EntityUtil;
import omtteam.openmodularturrets.blocks.turretheads.BlockAbstractTurretHead;
import omtteam.openmodularturrets.handler.config.OMTConfig;
import omtteam.openmodularturrets.init.ModItems;
import omtteam.openmodularturrets.init.ModSounds;
import omtteam.openmodularturrets.tileentity.turrets.RayTracingTurret;

public class RailGunTurretTileEntity
extends RayTracingTurret {
    private ColorOM color = new ColorOM(1.0f, 0.5f, 0.0f, 0.2f);

    public RailGunTurretTileEntity() {
        super(5);
    }

    @Override
    public boolean requiresAmmo() {
        return true;
    }

    @Override
    public boolean requiresSpecificAmmo() {
        return true;
    }

    @Override
    public ItemStack getAmmo() {
        return new ItemStack(ModItems.ammoMetaItem, 1, 2);
    }

    @Override
    public SoundEvent getLaunchSoundEffect() {
        return ModSounds.railgunLaunchSound;
    }

    @Override
    protected SoundEvent getHitSound() {
        return ModSounds.railGunHitSound;
    }

    @Override
    protected void renderRay(Vec3d start, Vec3d end) {
        OMLibNetworkingHandler.INSTANCE.sendToAllAround((IMessage)new MessageRenderRay(start, end, this.color, 3, true), new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.getDimension(), start.field_72450_a, start.field_72448_b, start.field_72449_c, 120.0));
    }

    @Override
    protected float getDamageModifier(Entity entity) {
        return (float)EntityUtil.getEntityArmor((Entity)entity) / 20.0f + 0.6f;
    }

    @Override
    protected float getNormalDamageFactor() {
        return 0.0f;
    }

    @Override
    protected float getBypassDamageFactor() {
        return 1.0f;
    }

    @Override
    protected void applyHitEffects(Entity entity) {
    }

    @Override
    protected void applyLaunchEffects() {
    }

    @Override
    protected void handleBlockHit(IBlockState hitBlock, BlockPos pos) {
        if (hitBlock.func_177230_c() instanceof BlockAbstractTurretHead) {
            return;
        }
        if (!hitBlock.func_185904_a().func_76220_a()) {
            return;
        }
        if (OMTConfig.TURRETS.canRailgunDestroyBlocks && hitBlock.func_185887_b(this.field_145850_b, pos) < 200.0f) {
            this.func_145831_w().func_175655_b(pos, false);
        }
    }
}

