/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.utils.worldengine;

import asmodeuscore.core.utils.Utils;
import asmodeuscore.core.utils.worldengine.WE_Biome;
import asmodeuscore.core.utils.worldengine.WE_WorldProvider;
import asmodeuscore.core.utils.worldengine.additions.WE_CreateChunkGen;
import asmodeuscore.core.utils.worldengine.additions.WE_CreateChunkGen_InXYZ;
import asmodeuscore.core.utils.worldengine.additions.WE_CreateChunkGen_InXZ;
import asmodeuscore.core.utils.worldengine.additions.WE_GeneratorData;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_CaveGen;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_LakeGen;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_OreGen;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_RavineGen;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_TerrainGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.Event;

public class WE_ChunkProvider
implements IChunkGenerator {
    public World worldObj;
    public Random rand;
    public List<WE_CreateChunkGen> createChunkGen_List = new ArrayList<WE_CreateChunkGen>();
    public List<WE_CreateChunkGen_InXZ> createChunkGen_InXZ_List = new ArrayList<WE_CreateChunkGen_InXZ>();
    public List<WE_CreateChunkGen_InXYZ> createChunkGen_InXYZ_List = new ArrayList<WE_CreateChunkGen_InXYZ>();
    public List<IWorldGenerator> decorateChunkGen_List = new ArrayList<IWorldGenerator>();
    public List<WE_Biome> biomesList = new ArrayList<WE_Biome>();
    protected WE_Biome standardBiomeOnMap;
    public double biomemapPersistence = 1.0;
    public double biomemapScaleX = 1.0;
    public double biomemapScaleY = 1.0;
    public int biomemapNumberOfOctaves = 1;
    protected WE_WorldProvider wp;

    public WE_ChunkProvider() {
    }

    public WE_ChunkProvider(WE_WorldProvider wp) {
        this.rand = new Random(wp.getSeed());
        this.worldObj = wp.field_76579_a;
        this.wp = wp;
        this.createChunkGen_List.add(new WE_TerrainGenerator());
        this.createChunkGen_List.add(new WE_CaveGen());
        this.createChunkGen_List.add(new WE_RavineGen());
        WE_OreGen standardOres = new WE_OreGen();
        standardOres.add(Blocks.field_150352_o.func_176223_P(), Blocks.field_150348_b.func_176223_P(), 4, 0, 32, 16);
        standardOres.add(Blocks.field_150366_p.func_176223_P(), Blocks.field_150348_b.func_176223_P(), 6, 0, 64, 72);
        standardOres.add(Blocks.field_150365_q.func_176223_P(), Blocks.field_150348_b.func_176223_P(), 6, 32, 128, 56);
        standardOres.add(Blocks.field_150369_x.func_176223_P(), Blocks.field_150348_b.func_176223_P(), 4, 0, 16, 16);
        standardOres.add(Blocks.field_150482_ag.func_176223_P(), Blocks.field_150348_b.func_176223_P(), 3, 0, 16, 16);
        standardOres.add(Blocks.field_150412_bA.func_176223_P(), Blocks.field_150348_b.func_176223_P(), 2, 0, 16, 24);
        this.decorateChunkGen_List.add(standardOres);
        WE_LakeGen lavaLakes = new WE_LakeGen();
        lavaLakes.lakeBlock = Blocks.field_150353_l.func_176223_P();
        lavaLakes.fGen = false;
        lavaLakes.maxY = 32;
        this.decorateChunkGen_List.add(lavaLakes);
        wp.genSettings(this);
        WE_Biome.setChunkProvider(this);
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        ChunkPrimer primer = new ChunkPrimer();
        this.rand.setSeed((long)chunkX * 6824L * this.rand.nextLong() + (long)chunkZ * 146346L * this.rand.nextLong() + 315723968L);
        try {
            int z;
            int x;
            long chunk_X = (long)chunkX * 16L;
            long chunk_Z = (long)chunkZ * 16L;
            WE_Biome.setChunkProvider(this);
            WE_Biome[][] chunkBiomes = new WE_Biome[16][16];
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    chunkBiomes[x][z] = WE_Biome.getBiomeAt(this, chunk_X + (long)x, chunk_Z + (long)z);
                }
            }
            for (int i = 0; i < this.createChunkGen_List.size(); ++i) {
                this.createChunkGen_List.get(i).gen(new WE_GeneratorData(this, primer, chunk_X, chunk_Z, chunkBiomes, 0, 0, 0));
            }
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    int i;
                    for (i = 0; i < this.createChunkGen_InXZ_List.size(); ++i) {
                        this.createChunkGen_InXZ_List.get(i).gen(new WE_GeneratorData(this, primer, chunk_X, chunk_Z, chunkBiomes, x, 0, z));
                    }
                    for (i = 0; i < chunkBiomes[x][z].createChunkGen_InXZ_List.size(); ++i) {
                        chunkBiomes[x][z].createChunkGen_InXZ_List.get(i).gen(new WE_GeneratorData(this, primer, chunk_X, chunk_Z, chunkBiomes, x, 0, z));
                    }
                    for (int y = 255; y >= 0; --y) {
                        int i2;
                        for (i2 = 0; i2 < this.createChunkGen_InXYZ_List.size(); ++i2) {
                            this.createChunkGen_InXYZ_List.get(i2).gen(new WE_GeneratorData(this, primer, chunk_X, chunk_Z, chunkBiomes, x, y, z));
                        }
                        for (i2 = 0; i2 < chunkBiomes[x][z].createChunkGen_InXYZ_List.size(); ++i2) {
                            chunkBiomes[x][z].createChunkGen_InXYZ_List.get(i2).gen(new WE_GeneratorData(this, primer, chunk_X, chunk_Z, chunkBiomes, x, y, z));
                        }
                    }
                }
            }
            this.wp.onChunkProvider(chunkX, chunkZ, primer);
        }
        catch (Exception e) {
            FMLLog.warning((String)("Error caught in planetary worldgen at coords " + chunkX + "," + chunkZ + "."), (Object[])new Object[0]);
            e.printStackTrace();
        }
        Chunk chunk = new Chunk(this.worldObj, primer, chunkX, chunkZ);
        byte[] arraybiome = new byte[256];
        Arrays.fill(arraybiome, (byte)Biome.func_185362_a((Biome)Utils.WE_Biome));
        chunk.func_76616_a(arraybiome);
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        BlockFalling.field_149832_M = true;
        int x = chunkX << 4;
        int z = chunkZ << 4;
        boolean flag = false;
        this.rand.setSeed((long)chunkX * 434673L * this.rand.nextLong() + (long)chunkZ * 585694L * this.rand.nextLong() + 745849494845L);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre((IChunkGenerator)this, this.worldObj, this.rand, chunkX, chunkZ, flag));
        for (int i = 0; i < this.decorateChunkGen_List.size(); ++i) {
            this.decorateChunkGen_List.get(i).generate(this.rand, x, z, this.worldObj, (IChunkGenerator)this, this.worldObj.func_72863_F());
        }
        WE_Biome b = WE_Biome.getBiomeAt(this, x, z);
        for (int i = 0; i < b.decorateChunkGen_List.size(); ++i) {
            b.decorateChunkGen_List.get(i).generate(this.rand, x, z, this.worldObj, (IChunkGenerator)this, this.worldObj.func_72863_F());
        }
        b.decorateBiome(this.worldObj, this.rand, x, z);
        this.wp.onPopulate(chunkX, chunkZ);
        WorldEntitySpawner.func_77191_a((World)this.worldObj, (Biome)b, (int)(x + 8), (int)(z + 8), (int)16, (int)16, (Random)this.rand);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post((IChunkGenerator)this, this.worldObj, this.rand, chunkX, chunkZ, flag));
        BlockFalling.field_149832_M = false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        WE_Biome biome = WE_Biome.getBiomeAt(this, pos.func_177958_n(), pos.func_177952_p());
        if (biome != null) {
            return biome.func_76747_a(creatureType);
        }
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
        this.wp.recreateStructures(chunkIn, x, z);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

