/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import openblocks.common.BeepGenerator;
import openblocks.common.IVarioController;

public class Vario {
    private static final int WATCHDOG_PERIOD = 50;
    private static final int WATCHDOG_TIMEOUT_TICKS = 10;
    private static final int VOL_MIN = 2;
    private static final int VOL_MAX = 20;
    public static final Vario instance = new Vario();
    private int varioVolume = 8;
    private boolean isEnabled;
    private IVarioController activeController = IVarioController.NULL;
    private WatchdogThread watchdogThread;
    private final BeepGenerator beeper = new BeepGenerator();

    public Vario() {
        this.setVolume(this.varioVolume);
    }

    public void incVolume() {
        this.varioVolume = Math.min(this.varioVolume + 2, 20);
        this.setVolume(this.varioVolume);
    }

    public void decVolume() {
        this.varioVolume = Math.max(this.varioVolume - 2, 2);
        this.setVolume(this.varioVolume);
    }

    private void setVolume(int volume) {
        this.beeper.setVolume((short)(this.varioVolume << 8));
    }

    public void enable() {
        this.isEnabled = true;
    }

    public void disable() {
        this.isEnabled = false;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void toggle() {
        this.isEnabled = !this.isEnabled;
    }

    public IVarioController acquire() {
        if (this.activeController.isValid()) {
            this.activeController.release();
        }
        this.activeController = new Controller();
        return this.activeController;
    }

    private void resetWatchdog() {
        if (this.isEnabled) {
            if (this.watchdogThread == null || !this.watchdogThread.isAlive() || this.watchdogThread.isShuttingDown()) {
                this.watchdogThread = new WatchdogThread();
                this.watchdogThread.start();
            } else if (this.watchdogThread != null) {
                this.watchdogThread.ping();
            }
        }
    }

    private class WatchdogThread
    extends Thread {
        private boolean isAlive = true;
        private int watchdogMissedTicks;

        public WatchdogThread() {
            this.setName("Vario watchdog");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (this.isAlive && Vario.this.isEnabled) {
                    if (this.watchdogMissedTicks++ > 10) {
                        this.isAlive = false;
                        break;
                    }
                    if (!Vario.this.beeper.isRunning()) {
                        Vario.this.beeper.start();
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        this.isAlive = false;
                        break;
                    }
                }
            }
            finally {
                Vario.this.beeper.stop();
                this.isAlive = false;
            }
        }

        public boolean isShuttingDown() {
            return !this.isAlive || !Vario.this.isEnabled;
        }

        public void shutdown() {
            this.isAlive = false;
        }

        public void ping() {
            this.watchdogMissedTicks = 0;
        }
    }

    private class Controller
    implements IVarioController {
        private boolean isValid = true;

        private Controller() {
        }

        @Override
        public void setFrequencies(double toneFrequency, double beepFrequency) {
            if (this.isValid) {
                Vario.this.beeper.setTargetToneFrequency(toneFrequency);
                Vario.this.beeper.setBeepFrequency(beepFrequency);
            }
        }

        @Override
        public synchronized void keepAlive() {
            if (this.isValid) {
                Vario.this.resetWatchdog();
            }
        }

        @Override
        public synchronized void kill() {
            if (this.isValid && Vario.this.watchdogThread != null) {
                Vario.this.watchdogThread.shutdown();
            }
        }

        @Override
        public boolean isValid() {
            return this.isValid;
        }

        @Override
        public void release() {
            this.isValid = false;
        }
    }
}

