/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.util.guicomponent;

import ic2.api.reactor.IReactor;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.util.math.Box2D;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasLang;

public class GuiComponentNuclearReactorHeat
extends GuiComponent {
    IReactor reactor;

    public GuiComponentNuclearReactorHeat(IReactor tile, Box2D box) {
        super(box);
        this.reactor = tile;
    }

    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.BackgroundDraw, GuiComponent.ActionRequest.ToolTip);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiIC2 gui, int mouseX, int mouseY, float particalTicks) {
        float heat = this.reactor.getHeat();
        if (heat > 0.0f) {
            Box2D box;
            int maxX;
            int lvl;
            int x = gui.getXOffset();
            int y = gui.getYOffset();
            float per = heat / (float)this.reactor.getMaxHeat();
            if (per > 1.0f) {
                per = 1.0f;
            }
            if ((lvl = (int)(per * (float)(maxX = (box = this.getPosition()).getLenght()))) <= 0) {
                return;
            }
            gui.func_73729_b(x + box.getX(), y + box.getY(), 0, 243, lvl, box.getHeight());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onToolTipCollecting(GuiIC2 gui, int mouseX, int mouseY, List<String> tooltips) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (PlayerHandler.getClientPlayerHandler().hasThermometer()) {
                float percent = (float)this.reactor.getHeat() / (float)this.reactor.getMaxHeat() * 100.0f;
                float heat = (float)Math.round(percent * 100.0f) / 100.0f;
                tooltips.add(Ic2cExtrasLang.REACTOR_HEAT.getLocalizedFormatted(new Object[]{heat + " %"}));
            } else {
                tooltips.add(Ic2cExtrasLang.REACTOR_THERMOMETER.getLocalized());
            }
        }
    }
}

