/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.tile;

import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import io.github.phantamanta44.libnine.capability.impl.L9AspectInventory;
import io.github.phantamanta44.libnine.component.multiblock.MultiBlockCore;
import io.github.phantamanta44.libnine.tile.RegisterTile;
import io.github.phantamanta44.libnine.util.collection.Accrue;
import io.github.phantamanta44.libnine.util.data.serialization.AutoSerialize;
import io.github.phantamanta44.libnine.util.helper.InventoryUtils;
import io.github.phantamanta44.threng.tile.TileBigAssemblerCore;
import io.github.phantamanta44.threng.tile.TileBigAssemblerPart;
import io.github.phantamanta44.threng.tile.base.IDroppableInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

@RegisterTile(value="threng")
public class TileBigAssemblerPatternStore
extends TileBigAssemblerPart
implements IDroppableInventory {
    @AutoSerialize(sync=false)
    private final L9AspectInventory patternInv = new L9AspectInventory.Observable(36, (i, o, n) -> {
        if (this.field_145850_b != null) {
            MultiBlockCore core;
            this.patternCache = null;
            if (!this.field_145850_b.field_72995_K && (core = this.multiBlock.getCore()) != null) {
                ((TileBigAssemblerCore)core.getUnit()).notifyPatternUpdate();
            }
        }
        this.setDirty();
    });
    @Nullable
    private List<ICraftingPatternDetails> patternCache = null;

    public TileBigAssemblerPatternStore() {
        Predicate<ItemStack> patternPred = stack -> stack.func_77973_b() instanceof ICraftingPatternItem;
        for (int i2 = 0; i2 < this.patternInv.getSlots(); ++i2) {
            this.patternInv.withPredicate(i2, patternPred);
        }
    }

    public IItemHandlerModifiable getPatternInventory() {
        return this.patternInv;
    }

    private List<ICraftingPatternDetails> getPatterns() {
        if (this.patternCache == null) {
            this.patternCache = new ArrayList<ICraftingPatternDetails>();
            for (int i = 0; i < this.patternInv.getSlots(); ++i) {
                ICraftingPatternDetails pattern;
                ItemStack stack = this.patternInv.getStackInSlot(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ICraftingPatternItem) || (pattern = ((ICraftingPatternItem)stack.func_77973_b()).getPatternForItem(stack, this.field_145850_b)) == null || !pattern.isCraftable()) continue;
                this.patternCache.add(pattern);
            }
        }
        return this.patternCache;
    }

    public void providePatterns(ICraftingMedium core, ICraftingProviderHelper helper) {
        for (ICraftingPatternDetails pattern : this.getPatterns()) {
            helper.addCraftingOption(core, pattern);
        }
    }

    @Override
    public void collectDrops(Accrue<ItemStack> drops) {
        InventoryUtils.accrue(drops, (IItemHandler[])new IItemHandler[]{this.patternInv});
    }
}

