/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.misc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ic2.api.classic.crops.ClassicCrops;
import ic2.api.crops.CropCard;
import ic2.api.crops.CropProperties;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import ic2.core.IC2;
import ic2.core.block.crop.crops.CropDynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropLoader {
    public static void load(JsonObject obj) {
        JsonObject subObj;
        boolean reload = false;
        if (obj.has("crops")) {
            for (JsonElement subElement : obj.getAsJsonArray("crops")) {
                try {
                    ItemStack stack;
                    CropStage stage3;
                    CropStage stage2;
                    subObj = subElement.getAsJsonObject();
                    CropDynamic.CropInfo info = new CropDynamic.CropInfo();
                    info.name = subObj.get("name").getAsString();
                    info.owner = subObj.get("owner").getAsString();
                    info.id = subObj.get("id").getAsString();
                    info.discoverer = subObj.get("discovered").getAsString();
                    info.harvestChanceMod = subObj.get("dropchance").getAsDouble();
                    info.optimalHarvestStage = Math.max(2, subObj.get("optimalstage").getAsInt());
                    info.attributes = CropLoader.parseString(subObj.getAsJsonArray("attributes"));
                    JsonObject props = subObj.getAsJsonObject("props");
                    int stageCount = subObj.get("totalstages").getAsInt();
                    info.props = new CropProperties(props.get("tier").getAsInt(), props.get("chemistry").getAsInt(), props.get("consumable").getAsInt(), props.get("defensive").getAsInt(), props.get("colorful").getAsInt(), props.get("weed").getAsInt());
                    Int2ObjectOpenHashMap stageMap = new Int2ObjectOpenHashMap();
                    if (subObj.has("defaultStage")) {
                        stageMap.put(-1, (Object)new CropStage(subObj.getAsJsonObject("defaultStage"), true));
                    }
                    for (JsonElement el : subObj.getAsJsonArray("stages")) {
                        stage2 = new CropStage(el.getAsJsonObject(), false);
                        stageMap.put(stage2.myIndex, (Object)stage2);
                    }
                    for (CropStage stage3 : stageMap.values()) {
                        stage3.evaluateParents((Int2ObjectMap<CropStage>)stageMap);
                    }
                    for (int i = 0; i < stageCount; ++i) {
                        stage3 = (CropStage)stageMap.get(i + 1);
                        if (stage3 == null) {
                            throw new RuntimeException("CropStage: " + (i + 1) + " is not found!");
                        }
                        info.stages.add(stage3);
                    }
                    if (IC2.platform.isRendering()) {
                        ObjectLinkedOpenHashSet textures = new ObjectLinkedOpenHashSet();
                        stage3 = stageMap.values().iterator();
                        while (stage3.hasNext()) {
                            stage2 = (CropStage)stage3.next();
                            textures.addAll(stage2.getCropTextures());
                        }
                        CropLoader.registerTextures((Set<ResourceLocation>)textures);
                    }
                    CropDynamic card = new CropDynamic(info);
                    ClassicCrops crop = ClassicCrops.instance;
                    crop.registerCrop(card);
                    reload = true;
                    if (!subObj.has("display") || (stack = CropLoader.createStack(subObj.getAsJsonObject("display"))).func_190926_b()) continue;
                    crop.registerCropDisplayItem(card, stack);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (obj.has("seeds")) {
            for (JsonElement element : obj.getAsJsonArray("seeds")) {
                try {
                    subObj = element.getAsJsonObject();
                    CropCard card = ClassicCrops.instance.getCropCard(subObj.get("owner").getAsString(), subObj.get("id").getAsString());
                    if (card == null) {
                        FMLLog.log.info("Crop Owner & ID not found: [owner=" + subObj.get("owner").getAsString() + ", ID=" + subObj.get("id").getAsString() + "]");
                        continue;
                    }
                    ItemStack stack = CropLoader.createStack(subObj.getAsJsonObject("seed"));
                    if (stack.func_190926_b()) {
                        FMLLog.log.info("Stack Not found: " + subObj.getAsJsonObject("seed"));
                        continue;
                    }
                    ClassicCrops.instance.registerBaseSeed(stack, card, subObj.get("growthStep").getAsInt(), subObj.get("statGrowth").getAsInt(), subObj.get("statGain").getAsInt(), subObj.get("statResistance").getAsInt());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (reload) {
            IC2.platform.reloadLang();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerTextures(Set<ResourceLocation> locations) {
        Object2ObjectLinkedOpenHashMap sprites = new Object2ObjectLinkedOpenHashMap();
        for (ResourceLocation location : locations) {
            sprites.put(location, Minecraft.func_71410_x().func_147117_R().func_174942_a(location));
        }
        Crops.instance.registerCropTextures((Map<ResourceLocation, TextureAtlasSprite>)sprites);
    }

    public static List<CropDynamic.ICropRequirement> parseRequirements(JsonObject obj) {
        ArrayList<CropDynamic.ICropRequirement> requirements = new ArrayList<CropDynamic.ICropRequirement>();
        if (obj.has("light")) {
            requirements.add(new SimpleStatRequirement(0, CropLoader.parseInt(obj.getAsJsonArray("light"))));
        }
        if (obj.has("nutrient")) {
            requirements.add(new SimpleStatRequirement(1, CropLoader.parseInt(obj.getAsJsonArray("light"))));
        }
        if (obj.has("humidity")) {
            requirements.add(new SimpleStatRequirement(2, CropLoader.parseInt(obj.getAsJsonArray("humidity"))));
        }
        if (obj.has("air")) {
            requirements.add(new SimpleStatRequirement(3, CropLoader.parseInt(obj.getAsJsonArray("air"))));
        }
        if (obj.has("block")) {
            JsonArray array = obj.getAsJsonArray("block");
            for (int i = 0; i < array.size(); ++i) {
                JsonObject subObj = array.get(i).getAsJsonObject();
                if (subObj.get("ore").getAsBoolean()) {
                    requirements.add(new OreRequirement(subObj.get("name").getAsString()));
                    continue;
                }
                Block block = Block.func_149684_b((String)subObj.get("name").getAsString());
                if (block == null || block == Blocks.field_150350_a) {
                    FMLLog.log.info("Skipping: " + subObj.get("name").getAsString() + " because it does not exist");
                    continue;
                }
                requirements.add(new BlockRequirement(block));
            }
        }
        return requirements;
    }

    private static int[] parseInt(JsonArray array) {
        int[] result = new int[array.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array.get(i).getAsInt();
        }
        return result;
    }

    private static float[] parseFloat(JsonArray array) {
        float[] result = new float[array.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array.get(i).getAsFloat();
        }
        return result;
    }

    private static String[] parseString(JsonArray array) {
        String[] result = new String[array.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array.get(i).getAsString();
        }
        return result;
    }

    public static ItemStack createStack(JsonObject obj) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(obj.get("name").getAsString()));
        if (item == Items.field_190931_a) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack(item, obj.has("count") ? obj.get("count").getAsInt() : 1, obj.has("meta") ? obj.get("meta").getAsInt() : 0);
        if (obj.has("nbt")) {
            try {
                stack.func_77982_d(JsonToNBT.func_180713_a((String)obj.get("nbt").getAsString()));
            }
            catch (NBTException e) {
                e.printStackTrace();
            }
        }
        return stack;
    }

    public static class BlockRequirement
    implements CropDynamic.ICropRequirement {
        Block block;

        public BlockRequirement(Block block) {
            this.block = block;
        }

        @Override
        public boolean isRequirementMet(ICropTile tile) {
            return tile.isBlockBelow(this.block);
        }
    }

    public static class OreRequirement
    implements CropDynamic.ICropRequirement {
        String ore;

        public OreRequirement(String ore) {
            this.ore = ore;
        }

        @Override
        public boolean isRequirementMet(ICropTile tile) {
            return tile.isBlockBelow(this.ore);
        }
    }

    public static class SimpleStatRequirement
    implements CropDynamic.ICropRequirement {
        int index;
        int[] statInfo;

        public SimpleStatRequirement(int index, int[] statInfo) {
            this.index = index;
            this.statInfo = statInfo;
        }

        @Override
        public boolean isRequirementMet(ICropTile tile) {
            switch (this.index) {
                case 0: {
                    return this.matches(tile.getLightLevel());
                }
                case 1: {
                    return this.matches(tile.getTerrainNutrients());
                }
                case 2: {
                    return this.matches(tile.getTerrainHumidity());
                }
                case 3: {
                    return this.matches(tile.getTerrainAirQuality());
                }
            }
            return false;
        }

        public boolean matches(int stat) {
            switch (this.statInfo.length) {
                case 1: {
                    return this.statInfo[0] == stat;
                }
                case 2: {
                    return this.statInfo[0] <= stat && this.statInfo[1] >= stat;
                }
            }
            for (int subStat : this.statInfo) {
                if (stat != subStat) continue;
                return true;
            }
            return false;
        }
    }

    public static class CropStage
    implements CropDynamic.ICropStage {
        int myIndex;
        int parentIndex;
        boolean hasDrop = false;
        ItemStack drop = ItemStack.field_190927_a;
        boolean hasSeed = false;
        ItemStack seed = ItemStack.field_190927_a;
        boolean isHarvestStage = false;
        int resetStage = 1;
        int points = 0;
        int redstoneStrength = 0;
        int lightLevel = 0;
        float[] mods = new float[0];
        List<CropDynamic.ICropRequirement> requirements = new ArrayList<CropDynamic.ICropRequirement>();
        List<ResourceLocation> locations = new ArrayList<ResourceLocation>();
        JsonObject owner;

        public CropStage(JsonObject obj, boolean defaultStage) {
            this.owner = obj;
            this.myIndex = defaultStage ? -1 : MathHelper.func_76125_a((int)obj.get("index").getAsInt(), (int)0, (int)Integer.MAX_VALUE);
            this.parentIndex = obj.has("parent") ? obj.get("parent").getAsInt() : -1;
            this.points = obj.has("points") ? obj.get("points").getAsInt() : 0;
            this.resetStage = obj.has("resetStage") ? Math.max(1, obj.get("resetStage").getAsInt()) : 1;
            this.redstoneStrength = MathHelper.func_76125_a((int)(obj.has("redstoneStrength") ? obj.get("redstoneStrength").getAsInt() : 0), (int)0, (int)15);
            this.lightLevel = MathHelper.func_76125_a((int)(obj.has("lightLevel") ? obj.get("lightLevel").getAsInt() : 0), (int)0, (int)15);
            if (obj.has("growthMods")) {
                this.mods = CropLoader.parseFloat(obj.getAsJsonArray("growthMods"));
            }
            if (!defaultStage) {
                for (JsonElement element : obj.getAsJsonArray("textures")) {
                    this.locations.add(new ResourceLocation(element.getAsString()));
                }
            }
            if (obj.has("requirements")) {
                this.requirements.addAll(CropLoader.parseRequirements(obj.getAsJsonObject("requirements")));
            }
            if (obj.has("drop") || obj.has("seedDrop")) {
                if (obj.has("drop")) {
                    this.drop = CropLoader.createStack(obj.getAsJsonObject("drop"));
                    boolean bl = this.hasDrop = !this.drop.func_190926_b();
                }
                if (obj.has("seedDrop")) {
                    this.seed = CropLoader.createStack(obj.getAsJsonObject("seedDrop"));
                    this.hasSeed = !this.seed.func_190926_b();
                }
                this.isHarvestStage = this.hasDrop || this.hasSeed;
            } else {
                this.isHarvestStage = false;
            }
        }

        public void evaluateParents(Int2ObjectMap<CropStage> stages) {
            CropStage stage = (CropStage)stages.get(this.parentIndex);
            if (stage == null) {
                return;
            }
            if (!this.owner.has("points") && stage.owner.has("points")) {
                this.points = stage.points;
            }
            if (!this.owner.has("resetStage") && stage.owner.has("resetStage")) {
                this.resetStage = stage.resetStage;
            }
            if (!this.owner.has("redstoneStrength") && stage.owner.has("redstoneStrength")) {
                this.redstoneStrength = stage.redstoneStrength;
            }
            if (!this.owner.has("lightLevel") && stage.owner.has("lightLevel")) {
                this.lightLevel = stage.lightLevel;
            }
            if (!this.owner.has("growthMods") && stage.owner.has("growthMods")) {
                this.mods = stage.mods;
            }
            if (!this.owner.has("requirements") && stage.owner.has("requirements")) {
                this.requirements = stage.requirements;
            }
            if (!this.owner.has("drop") && stage.owner.has("drop")) {
                this.drop = stage.drop;
                this.hasDrop = stage.hasDrop;
            }
            if (!this.owner.has("seedDrop") && stage.owner.has("seedDrop")) {
                this.drop = stage.drop;
                this.hasDrop = stage.hasDrop;
            }
            this.isHarvestStage = this.hasDrop || this.hasSeed;
        }

        @Override
        public int getPoints() {
            return this.points;
        }

        @Override
        public List<CropDynamic.ICropRequirement> getRequirements() {
            return this.requirements;
        }

        @Override
        public List<ResourceLocation> getCropTextures() {
            return this.locations;
        }

        @Override
        public boolean isHarvestStage(boolean seed) {
            if (!this.isHarvestStage) {
                return false;
            }
            return seed ? this.hasSeed : this.hasDrop;
        }

        @Override
        public int getAfterHarvestStage() {
            return this.resetStage;
        }

        @Override
        public boolean hasDrop() {
            return this.hasDrop;
        }

        @Override
        public ItemStack getDrop() {
            return this.drop.func_77946_l();
        }

        @Override
        public boolean isSeedable() {
            return this.hasSeed;
        }

        @Override
        public ItemStack getSeed() {
            return this.seed.func_77946_l();
        }

        @Override
        public int modify(int humidity, int nutrients, int air) {
            if (this.mods.length != 3) {
                return humidity + nutrients + air;
            }
            return (int)((float)humidity * this.mods[0] + (float)nutrients * this.mods[1] + (float)air * this.mods[2]);
        }

        @Override
        public int getLightStrenght() {
            return this.lightLevel;
        }

        @Override
        public int getRedstoneStrenght() {
            return this.redstoneStrength;
        }
    }
}

