/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.machines.battery;

import icbm.classic.content.machines.battery.ContainerBattery;
import icbm.classic.content.machines.battery.GuiBattery;
import icbm.classic.content.machines.battery.InventoryEnergyStorage;
import icbm.classic.lib.IGuiTile;
import icbm.classic.lib.network.IPacketIDReceiver;
import icbm.classic.prefab.gui.IPlayerUsing;
import icbm.classic.prefab.inventory.ExternalInventory;
import icbm.classic.prefab.inventory.IInventoryProvider;
import icbm.classic.prefab.tile.TileMachine;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityBattery
extends TileMachine
implements IInventoryProvider,
IGuiTile,
IPacketIDReceiver,
IPlayerUsing {
    public static final int SLOTS = 5;
    private ExternalInventory _inventory;
    private IEnergyStorage _batteryWrapper;
    public int _localEnergy = 0;
    public int _localEnergyMax = 0;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
    }

    public ExternalInventory getInventory() {
        if (this._inventory == null) {
            this._inventory = new ExternalInventory(this, 5);
        }
        return this._inventory;
    }

    public IEnergyStorage getEnergyStorage() {
        if (this._batteryWrapper == null) {
            this._batteryWrapper = new InventoryEnergyStorage((IItemHandler)this.getInventory().itemHandlerWrapper);
        }
        return this._batteryWrapper;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.getInventory().itemHandlerWrapper;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.getEnergyStorage();
        }
        return this.getCapability(capability, facing);
    }

    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerBattery(player, this);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiBattery(player, this);
    }

    @Override
    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
        buf.writeInt(this.getEnergyStorage().getEnergyStored());
        buf.writeInt(this.getEnergyStorage().getMaxEnergyStored());
    }

    @Override
    public void readDescPacket(ByteBuf buf) {
        super.readDescPacket(buf);
        this._localEnergy = buf.readInt();
        this._localEnergyMax = buf.readInt();
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.getInventory().load(compound.func_74775_l("inventory"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("tier", this._tier.ordinal());
        compound.func_74782_a("inventory", (NBTBase)this.getInventory().save(new NBTTagCompound()));
        return super.func_189515_b(compound);
    }
}

