/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.custom.IClassicScrapBoxManager;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.recipe.machine.MachineOutput;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import wanion.unidict.integration.AbstractIntegrationThread;

final class IC2CIntegration
extends AbstractIntegrationThread {
    IC2CIntegration() {
        super("Industrial Craft 2 Classic");
    }

    public String call() {
        try {
            this.fixMachineOutput(ClassicRecipes.macerator);
            this.fixMachineOutput(ClassicRecipes.compressor);
            this.fixMachineOutput(ClassicRecipes.extractor);
            this.fixMachineOutput(ClassicRecipes.sawMill);
            this.fixMachineOutput((IMachineRecipeList)ClassicRecipes.recycler);
            this.fixScrapBoxDrops();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.threadName + "Expect the world to be nuked by the Industrial Revolution.";
    }

    private void fixMachineOutput(@Nonnull IMachineRecipeList iMachineRecipeList) {
        List recipeEntryList = iMachineRecipeList.getRecipeMap();
        if (recipeEntryList == null || recipeEntryList.isEmpty()) {
            return;
        }
        HashMap<IMachineRecipeList.RecipeEntry, List> recipeEntryListMap = new HashMap<IMachineRecipeList.RecipeEntry, List>();
        for (IMachineRecipeList.RecipeEntry recipeEntry2 : recipeEntryList) {
            List<ItemStack> newOutputList;
            List outputList;
            MachineOutput machineOutput = recipeEntry2.getOutput();
            if (!recipeEntry2.getOutput().canOverride() || (outputList = machineOutput.getAllOutputs()) == (newOutputList = this.resourceHandler.getMainItemStacksChecked(outputList))) continue;
            recipeEntryListMap.put(recipeEntry2, newOutputList);
        }
        recipeEntryListMap.forEach((recipeEntry, newOutputsList) -> {
            iMachineRecipeList.removeRecipe(recipeEntry);
            iMachineRecipeList.addRecipe(recipeEntry.getInput(), recipeEntry.getOutput().overrideOutput(newOutputsList), recipeEntry.getRecipeID());
        });
    }

    private void fixScrapBoxDrops() {
        IClassicScrapBoxManager classicScrapBoxManager = ClassicRecipes.scrapboxDrops;
        List dropList = classicScrapBoxManager.getEntries();
        HashMap<IClassicScrapBoxManager.IDrop, ItemStack> newDrops = new HashMap<IClassicScrapBoxManager.IDrop, ItemStack>();
        for (IClassicScrapBoxManager.IDrop drop2 : dropList) {
            ItemStack newItemStackDrop2 = this.resourceHandler.getMainItemStack(drop2.getDrop());
            if (newItemStackDrop2 == drop2.getDrop()) continue;
            newDrops.put(drop2, newItemStackDrop2);
        }
        newDrops.forEach((drop, newItemStackDrop) -> {
            classicScrapBoxManager.removeDrop(drop);
            classicScrapBoxManager.addDrop(newItemStackDrop, drop.getRawChance());
        });
    }
}

