/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import cofh.core.inventory.ComparableItemStack;
import cofh.thermalexpansion.util.managers.machine.CompactorManager;
import cofh.thermalexpansion.util.managers.machine.FurnaceManager;
import cofh.thermalexpansion.util.managers.machine.PulverizerManager;
import cofh.thermalexpansion.util.managers.machine.RefineryManager;
import cofh.thermalexpansion.util.managers.machine.SmelterManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import wanion.lib.common.Util;
import wanion.unidict.integration.AbstractIntegrationThread;

final class TEIntegration
extends AbstractIntegrationThread {
    TEIntegration() {
        super("Thermal Expansion");
    }

    public String call() {
        try {
            this.fixCompactorRecipes();
            this.fixRefineryRecipes();
            this.fixInductionSmelterRecipes();
            this.fixRedstoneFurnaceRecipes();
            this.fixPulverizerRecipes();
        }
        catch (Exception e) {
            this.logger.error(this.threadName + e);
        }
        return this.threadName + "The world seems to be more thermally involved.";
    }

    private void fixCompactorRecipes() {
        ArrayList<Object> compactorRecipeMapList = new ArrayList<Object>();
        compactorRecipeMapList.add(Util.getField(CompactorManager.class, (String)"recipeMapAll", null, Map.class));
        compactorRecipeMapList.add(Util.getField(CompactorManager.class, (String)"recipeMapPlate", null, Map.class));
        compactorRecipeMapList.add(Util.getField(CompactorManager.class, (String)"recipeMapCoin", null, Map.class));
        compactorRecipeMapList.add(Util.getField(CompactorManager.class, (String)"recipeMapGear", null, Map.class));
        compactorRecipeMapList.forEach(this::fixCompactorRecipe);
    }

    private void fixCompactorRecipe(Map<ComparableItemStack, CompactorManager.CompactorRecipe> compactorRecipeMap) {
        if (compactorRecipeMap == null) {
            return;
        }
        Constructor recipeCompactorConstructor = null;
        try {
            recipeCompactorConstructor = CompactorManager.CompactorRecipe.class.getDeclaredConstructor(ItemStack.class, ItemStack.class, Integer.TYPE);
            recipeCompactorConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (recipeCompactorConstructor == null) {
            return;
        }
        for (ComparableItemStack recipeMapKey : compactorRecipeMap.keySet()) {
            CompactorManager.CompactorRecipe recipeCompactor = compactorRecipeMap.get(recipeMapKey);
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(recipeCompactor.getOutput());
            ItemStack correctInput = this.resourceHandler.getMainItemStack(recipeCompactor.getInput());
            if (correctOutput == recipeCompactor.getOutput() && correctInput == recipeCompactor.getInput()) continue;
            try {
                compactorRecipeMap.put(recipeMapKey, (CompactorManager.CompactorRecipe)recipeCompactorConstructor.newInstance(correctInput, correctOutput, recipeCompactor.getEnergy()));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void fixInductionSmelterRecipes() {
        Map recipeMap = (Map)Util.getField(SmelterManager.class, (String)"recipeMap", null, Map.class);
        if (recipeMap == null) {
            return;
        }
        Constructor smelterRecipeConstructor = null;
        try {
            smelterRecipeConstructor = SmelterManager.SmelterRecipe.class.getDeclaredConstructor(ItemStack.class, ItemStack.class, ItemStack.class, ItemStack.class, Integer.TYPE, Integer.TYPE);
            smelterRecipeConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (smelterRecipeConstructor == null) {
            return;
        }
        for (List recipeMapKey : recipeMap.keySet()) {
            SmelterManager.SmelterRecipe smelterRecipe = (SmelterManager.SmelterRecipe)recipeMap.get(recipeMapKey);
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(smelterRecipe.getPrimaryOutput());
            ItemStack correctSecondaryOutput = this.resourceHandler.getMainItemStack(smelterRecipe.getSecondaryOutput());
            ItemStack correctInput = this.resourceHandler.getMainItemStack(smelterRecipe.getPrimaryInput());
            ItemStack correctSecondaryInput = this.resourceHandler.getMainItemStack(smelterRecipe.getSecondaryInput());
            if (correctOutput == smelterRecipe.getPrimaryOutput() && correctSecondaryOutput == smelterRecipe.getSecondaryOutput() && correctInput == smelterRecipe.getPrimaryInput() && correctSecondaryInput == smelterRecipe.getSecondaryInput()) continue;
            try {
                recipeMap.put(recipeMapKey, smelterRecipeConstructor.newInstance(correctInput, correctSecondaryInput, correctOutput, correctSecondaryOutput, smelterRecipe.getSecondaryOutputChance(), smelterRecipe.getEnergy()));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void fixRefineryRecipes() {
        Int2ObjectOpenHashMap recipeMap = (Int2ObjectOpenHashMap)Util.getField(RefineryManager.class, (String)"recipeMap", null, Int2ObjectOpenHashMap.class);
        if (recipeMap == null) {
            return;
        }
        Constructor refineryRecipeConstructor = null;
        try {
            refineryRecipeConstructor = RefineryManager.RefineryRecipe.class.getDeclaredConstructor(FluidStack.class, FluidStack.class, ItemStack.class, Integer.TYPE, Integer.TYPE);
            refineryRecipeConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (refineryRecipeConstructor == null) {
            return;
        }
        IntIterator intIterator = recipeMap.keySet().iterator();
        while (intIterator.hasNext()) {
            int recipeMapKey = (Integer)intIterator.next();
            RefineryManager.RefineryRecipe refineryRecipe = (RefineryManager.RefineryRecipe)recipeMap.get(recipeMapKey);
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(refineryRecipe.getOutputItem());
            if (correctOutput == refineryRecipe.getOutputItem()) continue;
            try {
                recipeMap.put(recipeMapKey, refineryRecipeConstructor.newInstance(refineryRecipe.getInput(), refineryRecipe.getOutputFluid(), correctOutput, refineryRecipe.getEnergy(), refineryRecipe.getChance()));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void fixRedstoneFurnaceRecipes() {
        Map recipeMap = (Map)Util.getField(FurnaceManager.class, (String)"recipeMap", null, Map.class);
        if (recipeMap == null) {
            return;
        }
        Constructor redstoneFurnaceRecipeConstructor = null;
        try {
            redstoneFurnaceRecipeConstructor = FurnaceManager.FurnaceRecipe.class.getDeclaredConstructor(ItemStack.class, ItemStack.class, Integer.TYPE);
            redstoneFurnaceRecipeConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (redstoneFurnaceRecipeConstructor == null) {
            return;
        }
        for (ComparableItemStack recipeMapKey : recipeMap.keySet()) {
            FurnaceManager.FurnaceRecipe redstoneFurnaceRecipe = (FurnaceManager.FurnaceRecipe)recipeMap.get(recipeMapKey);
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(redstoneFurnaceRecipe.getOutput());
            ItemStack correctInput = this.resourceHandler.getMainItemStack(redstoneFurnaceRecipe.getInput());
            if (correctOutput == redstoneFurnaceRecipe.getOutput() && correctInput == redstoneFurnaceRecipe.getInput()) continue;
            try {
                recipeMap.put(recipeMapKey, redstoneFurnaceRecipeConstructor.newInstance(correctInput, correctOutput, redstoneFurnaceRecipe.getEnergy()));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void fixPulverizerRecipes() {
        Map recipeMap = (Map)Util.getField(PulverizerManager.class, (String)"recipeMap", null, Map.class);
        if (recipeMap == null) {
            return;
        }
        Constructor pulverizerRecipeConstructor = null;
        try {
            pulverizerRecipeConstructor = PulverizerManager.PulverizerRecipe.class.getDeclaredConstructor(ItemStack.class, ItemStack.class, ItemStack.class, Integer.TYPE, Integer.TYPE);
            pulverizerRecipeConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (pulverizerRecipeConstructor == null) {
            return;
        }
        for (ComparableItemStack recipeMapKey : recipeMap.keySet()) {
            PulverizerManager.PulverizerRecipe pulverizerRecipe = (PulverizerManager.PulverizerRecipe)recipeMap.get(recipeMapKey);
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(pulverizerRecipe.getPrimaryOutput());
            ItemStack correctSecondaryOutput = this.resourceHandler.getMainItemStack(pulverizerRecipe.getSecondaryOutput());
            ItemStack correctInput = this.resourceHandler.getMainItemStack(pulverizerRecipe.getInput());
            if (correctOutput == pulverizerRecipe.getPrimaryOutput() && correctSecondaryOutput == pulverizerRecipe.getSecondaryOutput() && correctInput == pulverizerRecipe.getInput()) continue;
            try {
                recipeMap.put(recipeMapKey, pulverizerRecipeConstructor.newInstance(correctInput, correctOutput, correctSecondaryOutput, pulverizerRecipe.getSecondaryOutputChance(), pulverizerRecipe.getEnergy()));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }
}

