/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import java.lang.reflect.Field;
import java.util.Collection;
import reborncore.api.praescriptum.recipes.Recipe;
import reborncore.api.recipe.RecipeHandler;
import techreborn.api.reactor.FusionReactorRecipe;
import techreborn.api.reactor.FusionReactorRecipeHelper;
import techreborn.api.recipe.Recipes;
import wanion.lib.common.Util;
import wanion.unidict.integration.AbstractIntegrationThread;

final class TechRebornIntegration
extends AbstractIntegrationThread {
    private Field recipeOutputs;

    TechRebornIntegration() {
        super("TechReborn");
        try {
            this.recipeOutputs = Recipe.class.getDeclaredField("itemOutputs");
            this.recipeOutputs.setAccessible(true);
        }
        catch (NoSuchFieldException | NullPointerException e) {
            e.printStackTrace();
        }
    }

    public String call() {
        try {
            this.fixFusionReactorRecipe();
            this.fixTechRebornRecipes();
        }
        catch (Exception e) {
            this.logger.error(this.threadName + e);
        }
        return this.threadName + "now Tech is truly Reborn.";
    }

    private void fixTechRebornRecipes() {
        RecipeHandler.recipeList.forEach(recipe -> {
            if (!recipe.useOreDic()) {
                this.resourceHandler.setMainObjects(recipe.getInputs());
            }
            this.resourceHandler.setMainItemStacks(recipe.getOutputs());
        });
        if (this.recipeOutputs == null) {
            return;
        }
        this.fixPraescriptumRecipes(Recipes.alloySmelter.getRecipes());
        this.fixPraescriptumRecipes(Recipes.assemblingMachine.getRecipes());
        this.fixPraescriptumRecipes(Recipes.centrifuge.getRecipes());
        this.fixPraescriptumRecipes(Recipes.chemicalReactor.getRecipes());
        this.fixPraescriptumRecipes(Recipes.compressor.getRecipes());
        this.fixPraescriptumRecipes(Recipes.extractor.getRecipes());
        this.fixPraescriptumRecipes(Recipes.grinder.getRecipes());
        this.fixPraescriptumRecipes(Recipes.plateBendingMachine.getRecipes());
        this.fixPraescriptumRecipes(Recipes.recycler.getRecipes());
        this.fixPraescriptumRecipes(Recipes.solidCanningMachine.getRecipes());
        this.fixPraescriptumRecipes(Recipes.wireMill.getRecipes());
    }

    private void fixPraescriptumRecipes(Collection<Recipe> recipes) {
        recipes.forEach(recipe -> {
            try {
                this.recipeOutputs.set(recipe, this.resourceHandler.getMainItemStacks(recipe.getItemOutputs()));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
    }

    private void fixFusionReactorRecipe() {
        FusionReactorRecipeHelper.reactorRecipes.forEach(fusionReactorRecipe -> Util.setField(FusionReactorRecipe.class, (String)"output", (Object)fusionReactorRecipe, (Object)this.resourceHandler.getMainItemStack(fusionReactorRecipe.getOutput())));
    }
}

