/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.ingredient;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import nc.recipe.IngredientMatchResult;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.IItemIngredient;
import net.minecraft.item.ItemStack;

public class ItemArrayIngredient
implements IItemIngredient {
    public List<IItemIngredient> ingredientList;
    public List<ItemStack> cachedStackList = new ArrayList<ItemStack>();

    public ItemArrayIngredient(IItemIngredient ... ingredients) {
        this(Lists.newArrayList((Object[])ingredients));
    }

    public ItemArrayIngredient(List<IItemIngredient> ingredientList) {
        this.ingredientList = ingredientList;
        ingredientList.forEach(input -> this.cachedStackList.add((ItemStack)input.getStack()));
    }

    @Override
    public ItemStack getStack() {
        if (this.cachedStackList == null || this.cachedStackList.isEmpty() || this.cachedStackList.get(0) == null) {
            return null;
        }
        return this.cachedStackList.get(0).func_77946_l();
    }

    @Override
    public String getIngredientName() {
        return this.getIngredientNamesConcat();
    }

    @Override
    public String getIngredientNamesConcat() {
        String names = "";
        for (IItemIngredient ingredient : this.ingredientList) {
            names = names + ", " + ingredient.getIngredientName();
        }
        return "{ " + names.substring(2) + " }";
    }

    public String getIngredientRecipeString() {
        String names = "";
        for (IItemIngredient ingredient : this.ingredientList) {
            names = names + ", " + ingredient.getMaxStackSize(0) + " x " + ingredient.getIngredientName();
        }
        return "{ " + names.substring(2) + " }";
    }

    @Override
    public int getMaxStackSize(int ingredientNumber) {
        return this.ingredientList.get(ingredientNumber).getMaxStackSize(0);
    }

    @Override
    public void setMaxStackSize(int stackSize) {
        for (IItemIngredient ingredient : this.ingredientList) {
            ingredient.setMaxStackSize(stackSize);
        }
        for (ItemStack stack : this.cachedStackList) {
            stack.func_190920_e(stackSize);
        }
    }

    @Override
    public List<ItemStack> getInputStackList() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        this.ingredientList.forEach(ingredient -> ingredient.getInputStackList().forEach(obj -> stacks.add((ItemStack)obj)));
        return stacks;
    }

    @Override
    public List<ItemStack> getOutputStackList() {
        if (this.cachedStackList == null || this.cachedStackList.isEmpty()) {
            return new ArrayList<ItemStack>();
        }
        return Lists.newArrayList((Object[])new ItemStack[]{this.getStack()});
    }

    @Override
    public IngredientMatchResult match(Object object, IngredientSorption sorption) {
        for (int i = 0; i < this.ingredientList.size(); ++i) {
            if (!this.ingredientList.get(i).match(object, sorption).matches()) continue;
            return new IngredientMatchResult(true, i);
        }
        return IngredientMatchResult.FAIL;
    }

    @Override
    public boolean isValid() {
        return this.cachedStackList != null && !this.cachedStackList.isEmpty() && this.cachedStackList.get(0) != null;
    }
}

