/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.resources;

import ic2.api.classic.audio.AudioPosition;
import ic2.core.IC2;
import ic2.core.platform.lang.ILocaleBlock;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.IBlockTextureModifier;
import ic2.core.platform.textures.obj.ITexturedBlock;
import ic2.core.util.obj.IBootable;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRubberSheet
extends Block
implements ITexturedBlock,
IBlockTextureModifier,
IBootable,
ILocaleBlock {
    public static PropertyBool supports = PropertyBool.func_177716_a((String)"supports");

    public BlockRubberSheet() {
        super(Material.field_151580_n);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149711_c(0.8f);
        this.func_149752_b(2.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)supports, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void onLoad() {
        Ic2Items.rubberSheet = new ItemStack((Block)this, 1, 0);
        Ic2States.rubberSheet = this.func_176223_P();
    }

    @Override
    public LocaleComp getName() {
        return Ic2BlockLang.rubberSheet;
    }

    public String func_149739_a() {
        return this.getName().getUnlocalized();
    }

    public String func_149732_F() {
        return this.getName().getLocalized();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{supports});
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)supports) != false ? 1 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)supports, (Comparable)Boolean.valueOf(meta == 1));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)supports, (Comparable)Boolean.valueOf(false));
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.field_70143_R = 0.0f;
        if (worldIn.func_175677_d(pos.func_177977_b(), false)) {
            return;
        }
        if (!this.canSupportWeight(worldIn, pos)) {
            worldIn.func_175698_g(pos);
            return;
        }
        entityIn.field_70143_R = 0.0f;
        if (entityIn.field_70181_x <= (double)-0.4f) {
            IC2.audioManager.playOnce(new AudioPosition(worldIn, pos), Ic2Sounds.trampoline);
            entityIn.field_70159_w *= (double)1.1f;
            entityIn.field_70181_x = entityIn instanceof EntityLivingBase ? (entityIn instanceof EntityPlayer && entityIn.func_70093_af() ? (entityIn.field_70181_x *= -0.1000000014901161) : (entityIn.field_70181_x *= (double)-0.8f)) : (entityIn.field_70181_x *= (double)-0.8f);
            entityIn.field_70179_y *= (double)1.1f;
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (worldIn.func_175677_d(pos.func_177977_b(), false)) {
            return;
        }
        if (!this.canSupportWeight(worldIn, pos)) {
            worldIn.func_175698_g(pos);
            return;
        }
        entityIn.field_70143_R = 0.0f;
        if (entityIn.field_70181_x <= (double)-0.4f) {
            IC2.audioManager.playOnce(new AudioPosition(worldIn, pos), Ic2Sounds.trampoline);
            entityIn.field_70159_w *= (double)1.1f;
            entityIn.field_70181_x = entityIn instanceof EntityLivingBase ? (entityIn instanceof EntityPlayer && entityIn.func_70093_af() ? (entityIn.field_70181_x *= -0.1000000014901161) : (entityIn.field_70181_x *= (double)-0.8f)) : (entityIn.field_70181_x *= (double)-0.8f);
            entityIn.field_70179_y *= (double)1.1f;
        }
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos origin) {
        if (((Boolean)state.func_177229_b((IProperty)supports)).booleanValue()) {
            worldIn.func_175656_a(pos, this.func_176223_P());
        }
        if (!this.func_176196_c(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.isBlockSupporter(worldIn, pos.func_177974_f()) || this.isBlockSupporter(worldIn, pos.func_177976_e()) || this.isBlockSupporter(worldIn, pos.func_177978_c()) || this.isBlockSupporter(worldIn, pos.func_177968_d());
    }

    public boolean isBlockSupporter(World world, BlockPos pos) {
        return world.func_175677_d(pos, false) || world.func_180495_p(pos).func_177230_c() == this;
    }

    public boolean canSupportWeight(World world, BlockPos pos) {
        if (((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)supports)).booleanValue()) {
            return true;
        }
        boolean xup = false;
        boolean xdown = false;
        boolean zup = false;
        boolean zdown = false;
        BlockPos west = pos;
        while (true) {
            if (world.func_175677_d(west, false)) {
                xdown = true;
                break;
            }
            if (world.func_180495_p(west).func_177230_c() != this) break;
            if (world.func_175677_d(west.func_177977_b(), false)) {
                xdown = true;
                break;
            }
            west = west.func_177976_e();
        }
        BlockPos east = pos;
        while (true) {
            if (world.func_175677_d(east, false)) {
                xup = true;
                break;
            }
            if (world.func_180495_p(east).func_177230_c() != this) break;
            if (world.func_175677_d(east.func_177977_b(), false)) {
                xup = true;
                break;
            }
            east = east.func_177974_f();
        }
        if (xup && xdown) {
            world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)supports, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        BlockPos north = pos;
        while (true) {
            if (world.func_175677_d(north, false)) {
                zdown = true;
                break;
            }
            if (world.func_180495_p(north).func_177230_c() != this) break;
            if (world.func_175677_d(north.func_177977_b(), false)) {
                zdown = true;
                break;
            }
            north = north.func_177978_c();
        }
        BlockPos south = pos;
        while (true) {
            if (world.func_175677_d(south, false)) {
                zup = true;
                break;
            }
            if (world.func_180495_p(south).func_177230_c() != this) break;
            if (world.func_175677_d(south.func_177977_b(), false)) {
                zup = true;
                break;
            }
            south = south.func_177968_d();
        }
        if (zup && zdown) {
            world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)supports, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        return false;
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox(IBlockState state) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureFromState(IBlockState state, EnumFacing par1) {
        return Ic2Icons.getTextures("b0")[40];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture(IBlockState state) {
        return Ic2Icons.getTextures("b0")[40];
    }

    @Override
    public List<IBlockState> getValidStates() {
        return this.func_176194_O().func_177619_a();
    }

    @Override
    public IBlockState getStateFromStack(ItemStack stack) {
        return this.func_176223_P();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean hasTextureRotation(IBlockState state, EnumFacing side) {
        return false;
    }

    @Override
    public int getTextureRotation(IBlockState state, EnumFacing side) {
        return 0;
    }

    @Override
    public boolean hasCustomTextureUV(IBlockState state, EnumFacing side) {
        return side.func_176740_k().func_176722_c();
    }

    @Override
    public float[] getCustomTextureUV(IBlockState state, EnumFacing side) {
        return new float[]{0.0f, 14.0f, 16.0f, 16.0f};
    }
}

