/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy.render;

import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TextureRotator {
    RotationEntry[][] array = new RotationEntry[6][6];
    TextureAtlasSprite sprite;
    EnumFacing rotation;
    EnumFacing side;

    public void setTexture(TextureAtlasSprite texture) {
        this.sprite = texture;
    }

    public void setRotation(EnumFacing facing) {
        this.rotation = facing;
    }

    public void setSide(EnumFacing facing) {
        this.side = facing;
        if (this.rotation == null || this.sprite == null || this.side == null) {
            throw new RuntimeException("Should be always Set!");
        }
        this.get(this.side, this.rotation).applyTexture(this.sprite);
    }

    public double getUV(int slot, boolean u) {
        if (this.rotation == null || this.sprite == null || this.side == null) {
            throw new RuntimeException("Should be always Set!");
        }
        return this.get(this.side, this.rotation).getUV(slot, u);
    }

    public void init() {
        RotationEntry entry = new RotationEntry();
        RotationEntry invert = new RotationEntry();
        entry.addEnty(0, false, true);
        entry.addEnty(1, true, true);
        entry.addEnty(2, true, false);
        entry.addEnty(3, false, false);
        invert = entry.invert();
        this.register(EnumFacing.DOWN, EnumFacing.NORTH, invert);
        this.register(EnumFacing.DOWN, EnumFacing.SOUTH, entry);
        this.register(EnumFacing.UP, EnumFacing.NORTH, entry);
        this.register(EnumFacing.UP, EnumFacing.SOUTH, invert);
        entry = new RotationEntry();
        entry.addEnty(0, true, true);
        entry.addEnty(1, true, false);
        entry.addEnty(2, false, false);
        entry.addEnty(3, false, true);
        invert = entry.invert();
        this.register(EnumFacing.DOWN, EnumFacing.WEST, invert);
        this.register(EnumFacing.DOWN, EnumFacing.EAST, entry);
        this.register(EnumFacing.UP, EnumFacing.WEST, invert);
        this.register(EnumFacing.UP, EnumFacing.EAST, entry);
        entry = new RotationEntry();
        entry.addEnty(0, true, true);
        entry.addEnty(1, true, false);
        entry.addEnty(2, false, false);
        entry.addEnty(3, false, true);
        invert = entry.invert();
        this.register(EnumFacing.SOUTH, EnumFacing.DOWN, invert);
        this.register(EnumFacing.SOUTH, EnumFacing.UP, entry);
        this.register(EnumFacing.NORTH, EnumFacing.DOWN, invert);
        this.register(EnumFacing.NORTH, EnumFacing.UP, entry);
        entry = new RotationEntry();
        entry.addEnty(0, false, true);
        entry.addEnty(1, true, true);
        entry.addEnty(2, true, false);
        entry.addEnty(3, false, false);
        invert = entry.invert();
        this.register(EnumFacing.SOUTH, EnumFacing.EAST, invert);
        this.register(EnumFacing.SOUTH, EnumFacing.WEST, entry);
        this.register(EnumFacing.NORTH, EnumFacing.EAST, entry);
        this.register(EnumFacing.NORTH, EnumFacing.WEST, invert);
        entry = new RotationEntry();
        entry.addEnty(0, true, true);
        entry.addEnty(1, true, false);
        entry.addEnty(2, false, false);
        entry.addEnty(3, false, true);
        invert = entry.invert();
        this.register(EnumFacing.EAST, EnumFacing.DOWN, invert);
        this.register(EnumFacing.EAST, EnumFacing.UP, entry);
        this.register(EnumFacing.WEST, EnumFacing.DOWN, invert);
        this.register(EnumFacing.WEST, EnumFacing.UP, entry);
        entry = new RotationEntry();
        entry.addEnty(0, false, true);
        entry.addEnty(1, true, true);
        entry.addEnty(2, true, false);
        entry.addEnty(3, false, false);
        invert = entry.invert();
        this.register(EnumFacing.EAST, EnumFacing.NORTH, invert);
        this.register(EnumFacing.EAST, EnumFacing.SOUTH, entry);
        this.register(EnumFacing.WEST, EnumFacing.NORTH, entry);
        this.register(EnumFacing.WEST, EnumFacing.SOUTH, invert);
    }

    private void register(EnumFacing side, EnumFacing rotation, RotationEntry entry) {
        this.array[side.func_176745_a()][rotation.func_176745_a()] = entry;
    }

    private RotationEntry get(EnumFacing rotation, EnumFacing side) {
        RotationEntry entry = this.array[rotation.func_176745_a()][side.func_176745_a()];
        if (entry == null) {
            this.array[rotation.func_176745_a()][side.func_176745_a()] = entry = new RotationEntry();
        }
        return entry;
    }

    public static class RotationEntry {
        boolean[][] pickInfo = new boolean[4][2];
        double[][] texInfo = new double[4][2];

        public void addEnty(int slot, boolean first, boolean second) {
            this.pickInfo[slot][0] = first;
            this.pickInfo[slot][1] = second;
        }

        public RotationEntry invert() {
            RotationEntry inverted = new RotationEntry();
            for (int i = 0; i < 4; ++i) {
                inverted.addEnty(i, !this.pickInfo[i][0], !this.pickInfo[i][1]);
            }
            return inverted;
        }

        public void applyTexture(TextureAtlasSprite sprite) {
            for (int i = 0; i < 4; ++i) {
                this.texInfo[i][0] = this.pickInfo[i][0] ? (double)sprite.func_94209_e() : (double)sprite.func_94212_f();
                this.texInfo[i][1] = this.pickInfo[i][1] ? (double)sprite.func_94206_g() : (double)sprite.func_94210_h();
            }
        }

        public double getUV(int slot, boolean u) {
            return this.texInfo[slot][u ? 0 : 1];
        }
    }
}

