/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketBase;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.gui.client.device.GuiXpCollector;
import cofh.thermalexpansion.gui.container.device.ContainerXpCollector;
import cofh.thermalexpansion.util.managers.device.XpCollectorManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileXpCollector
extends TileDeviceBase
implements ITickable {
    private static final int TYPE = BlockDevice.Type.XP_COLLECTOR.getMetadata();
    private static int radius = 5;
    private static final int TIME_CONSTANT = 16;
    private int inputTracker;
    private int outputTracker;
    private int xpBuffer;
    private int maxBoostXp;
    private int boostXp;
    private int boostFactor;
    private FluidTankCore tank = new FluidTankCore(8000);
    private int offset;
    private boolean forcedCycle;

    public static void initialize() {
        TileXpCollector.SIDE_CONFIGS[TileXpCollector.TYPE] = new SideConfig();
        TileXpCollector.SIDE_CONFIGS[TileXpCollector.TYPE].numConfig = 5;
        TileXpCollector.SIDE_CONFIGS[TileXpCollector.TYPE].slotGroups = new int[][]{new int[0], {0}, new int[0], {0}, {0}};
        TileXpCollector.SIDE_CONFIGS[TileXpCollector.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TileXpCollector.SIDE_CONFIGS[TileXpCollector.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TileXpCollector.SLOT_CONFIGS[TileXpCollector.TYPE] = new SlotConfig();
        TileXpCollector.SLOT_CONFIGS[TileXpCollector.TYPE].allowInsertionSlot = new boolean[]{true};
        TileXpCollector.SLOT_CONFIGS[TileXpCollector.TYPE].allowExtractionSlot = new boolean[]{false};
        TileXpCollector.LIGHT_VALUES[TileXpCollector.TYPE] = 2;
        GameRegistry.registerTileEntity(TileXpCollector.class, (String)"thermalexpansion:device_xp_collector");
        TileXpCollector.config();
    }

    public static void config() {
        String category = "Device.XpCollector";
        BlockDevice.enable[TileXpCollector.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the capture radius for the Insightful Condenser.";
        radius = ThermalExpansion.CONFIG.getConfiguration().getInt("Radius", category, radius, 2, 16, comment);
    }

    public TileXpCollector() {
        this.inventory = new ItemStack[1];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        this.offset = MathHelper.RANDOM.nextInt(16);
        this.tank.setLock(TFFluids.fluidExperience);
        this.hasAutoInput = true;
        this.hasAutoOutput = true;
        this.enableAutoInput = true;
        this.enableAutoOutput = true;
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void onRedstoneUpdate() {
        boolean curActive = this.isActive;
        this.isActive = this.redstoneControlOrDisable();
        if (this.isActive && !curActive && !this.forcedCycle) {
            this.collectXpOrbs();
            this.offset = (int)(16L - this.field_145850_b.func_82737_E() % 16L);
            this.forcedCycle = true;
        }
        this.updateIfChanged(curActive);
    }

    public void func_73660_a() {
        if (!this.timeCheckOffset()) {
            return;
        }
        this.forcedCycle = false;
        this.convertXp();
        this.transferOutputFluid();
        this.transferInput();
        boolean curActive = this.isActive;
        if (this.isActive) {
            if (this.xpBuffer <= 0) {
                this.collectXpOrbs();
            }
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
            }
        } else if (this.redstoneControlOrDisable()) {
            this.isActive = true;
        }
        this.updateIfChanged(curActive);
    }

    protected void transferInput() {
        if (!this.getTransferIn()) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!SideConfig.isPrimaryInput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    protected void transferOutputFluid() {
        if (!this.getTransferOut() || this.tank.getFluidAmount() <= 0) {
            return;
        }
        FluidStack output = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), this.tank.getCapacity()));
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int toDrain;
            int side = i % 6;
            if (!SideConfig.isPrimaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (FluidStack)output, (boolean)true)) <= 0) continue;
            this.tank.drain(toDrain, true);
            this.outputTracker = side;
            break;
        }
    }

    protected void collectXpOrbs() {
        AxisAlignedBB area = new AxisAlignedBB(this.field_174879_c.func_177982_a(-radius, -radius, -radius), this.field_174879_c.func_177982_a(1 + radius, 1 + radius, 1 + radius));
        List xpOrbs = this.field_145850_b.func_175647_a(EntityXPOrb.class, area, EntitySelectors.field_94557_a);
        for (EntityXPOrb orb : xpOrbs) {
            this.xpBuffer += orb.func_70526_d();
            orb.func_70106_y();
        }
    }

    protected void collectMachineXp() {
    }

    protected void convertXp() {
        int toConvert;
        int conversion;
        if (this.boostXp <= 0 && XpCollectorManager.getCatalystFactor(this.inventory[0]) > 0) {
            this.boostXp = XpCollectorManager.getCatalystXp(this.inventory[0]);
            this.boostFactor = XpCollectorManager.getCatalystFactor(this.inventory[0]);
            this.inventory[0].func_190918_g(1);
            if (this.inventory[0].func_190916_E() <= 0) {
                this.inventory[0] = ItemStack.field_190927_a;
            }
        }
        if (this.xpBuffer * (conversion = 20 * (100 + this.boostFactor) / 100) <= this.tank.getSpace()) {
            toConvert = this.xpBuffer;
            this.tank.modifyFluidStored(this.xpBuffer * conversion);
            this.xpBuffer = 0;
        } else {
            toConvert = this.tank.getSpace() / conversion;
            this.tank.modifyFluidStored(this.tank.getSpace());
            this.xpBuffer -= toConvert;
        }
        this.boostXp -= toConvert * this.boostFactor / 100;
        if (this.boostXp <= 0) {
            this.boostXp = 0;
            this.boostFactor = 0;
        }
    }

    protected boolean timeCheckOffset() {
        return (this.field_145850_b.func_82737_E() + (long)this.offset) % 16L == 0L;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiXpCollector(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerXpCollector(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public int getScaledSpeed(int scale) {
        if (this.maxBoostXp <= 0) {
            this.maxBoostXp = Math.max(this.boostXp, 100);
        }
        return this.boostXp * scale / this.maxBoostXp;
    }

    public int getBoostFactor() {
        return this.boostFactor;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.tank.readFromNBT(nbt);
        this.boostFactor = nbt.func_74762_e("BoostFactor");
        this.boostXp = nbt.func_74762_e("BoostXp");
        this.maxBoostXp = nbt.func_74762_e("BoostXpMax");
        if (this.maxBoostXp <= 0) {
            this.maxBoostXp = Math.max(this.boostXp, 100);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        this.tank.writeToNBT(nbt);
        nbt.func_74768_a("BoostFactor", this.boostFactor);
        nbt.func_74768_a("BoostXp", this.boostXp);
        nbt.func_74768_a("BoostXpMax", this.maxBoostXp);
        return nbt;
    }

    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addInt(this.boostXp);
        payload.addInt(this.boostFactor);
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.boostXp = payload.getInt();
        this.boostFactor = payload.getInt();
        this.tank.setFluid(payload.getFluidStack());
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return XpCollectorManager.getCatalystFactor(stack) > 0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileXpCollector.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, false, true)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from == null || SideConfig.allowExtraction((int)((TileXpCollector)TileXpCollector.this).sideConfig.sideTypes[TileXpCollector.this.sideCache[from.ordinal()]])) {
                        return TileXpCollector.this.tank.drain(resource, doDrain);
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from == null || SideConfig.allowExtraction((int)((TileXpCollector)TileXpCollector.this).sideConfig.sideTypes[TileXpCollector.this.sideCache[from.ordinal()]])) {
                        return TileXpCollector.this.tank.drain(maxDrain, doDrain);
                    }
                    return null;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

