/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.phosphor.mod;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class PhosphorConfig {
    private static final Gson gson = PhosphorConfig.createGson();
    private static PhosphorConfig INSTANCE;
    @SerializedName(value="enable_illegal_thread_access_warnings")
    public boolean enableIllegalThreadAccessWarnings = true;
    @SerializedName(value="enable_phosphor")
    public boolean enablePhosphor = true;
    @SerializedName(value="show_patreon_message")
    public boolean showPatreonMessage = true;

    public static PhosphorConfig instance() {
        return INSTANCE;
    }

    public static PhosphorConfig loadConfig() {
        PhosphorConfig config;
        if (INSTANCE != null) {
            return INSTANCE;
        }
        File file = PhosphorConfig.getConfigFile();
        if (!file.exists()) {
            config = new PhosphorConfig();
            config.saveConfig();
        } else {
            try (FileReader reader = new FileReader(file);){
                config = (PhosphorConfig)gson.fromJson((Reader)reader, PhosphorConfig.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to deserialize config from disk", e);
            }
        }
        INSTANCE = config;
        return config;
    }

    public void saveConfig() {
        File dir = PhosphorConfig.getConfigDirectory();
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new RuntimeException("Could not create configuration directory at '" + dir.getAbsolutePath() + "'");
            }
        } else if (!dir.isDirectory()) {
            throw new RuntimeException("Configuration directory at '" + dir.getAbsolutePath() + "' is not a directory");
        }
        try (FileWriter writer = new FileWriter(PhosphorConfig.getConfigFile());){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize config to disk", e);
        }
    }

    private static File getConfigDirectory() {
        return new File("config");
    }

    private static File getConfigFile() {
        return new File(PhosphorConfig.getConfigDirectory(), "phosphor.json");
    }

    private static Gson createGson() {
        return new GsonBuilder().setPrettyPrinting().create();
    }
}

