/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.awt.Point;
import java.util.List;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.inventory.ContainerVacuumPump;
import me.desht.pneumaticcraft.common.tileentity.TileEntityVacuumPump;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiVacuumPump
extends GuiPneumaticContainerBase<TileEntityVacuumPump> {
    public GuiVacuumPump(InventoryPlayer player, TileEntityVacuumPump te) {
        super(new ContainerVacuumPump(player, te), te, "pneumaticcraft:textures/gui/gui_vacuum_pump.png");
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.field_146289_q.func_78276_b("Upgr.", 76, 19, 0x404040);
        this.field_146289_q.func_78276_b("+", 32, 47, -16733696);
        this.field_146289_q.func_78276_b("-", 138, 47, -65536);
    }

    @Override
    protected void func_146976_a(float opacity, int x, int y) {
        super.func_146976_a(opacity, x, y);
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        GuiUtils.drawPressureGauge(this.field_146289_q, -1.0f, 7.0f, 5.0f, 2.0f, ((TileEntityVacuumPump)this.te).getAirHandler(((TileEntityVacuumPump)this.te).getInputSide()).getPressure(), xStart + this.field_146999_f / 5, yStart + this.field_147000_g / 5 + 4, this.field_73735_i);
        GuiUtils.drawPressureGauge(this.field_146289_q, -1.0f, 7.0f, 5.0f, -1.0f, ((TileEntityVacuumPump)this.te).getAirHandler(((TileEntityVacuumPump)this.te).getVacuumSide()).getPressure(), xStart + this.field_146999_f * 4 / 5, yStart + this.field_147000_g / 5 + 4, this.field_73735_i);
    }

    @Override
    protected Point getGaugeLocation() {
        return null;
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        IAirHandler inputHandler = ((TileEntityVacuumPump)this.te).getAirHandler(((TileEntityVacuumPump)this.te).getInputSide());
        IAirHandler vacuumHandler = ((TileEntityVacuumPump)this.te).getAirHandler(((TileEntityVacuumPump)this.te).getVacuumSide());
        pressureStatText.add("\u00a77Current Input Pressure:");
        pressureStatText.add("\u00a70" + PneumaticCraftUtils.roundNumberTo(inputHandler.getPressure(), 1) + " bar.");
        pressureStatText.add("\u00a77Current Input Air:");
        pressureStatText.add("\u00a70" + (inputHandler.getAir() + inputHandler.getVolume()) + " mL.");
        pressureStatText.add("\u00a77Current Vacuum Pressure:");
        pressureStatText.add("\u00a70" + PneumaticCraftUtils.roundNumberTo(vacuumHandler.getPressure(), 1) + " bar.");
        pressureStatText.add("\u00a77Current Vacuum Air:");
        pressureStatText.add("\u00a70" + (vacuumHandler.getAir() + vacuumHandler.getVolume()) + " mL.");
        pressureStatText.add("\u00a77Volume:");
        pressureStatText.add("\u00a70" + (double)Math.round(2000.0f) + " mL.");
        int volumeLeft = inputHandler.getVolume() - 2000;
        if (volumeLeft > 0) {
            pressureStatText.add("\u00a70" + volumeLeft + " mL. (Volume Upgrades)");
            pressureStatText.add("\u00a70--------+");
            pressureStatText.add("\u00a70" + inputHandler.getVolume() + " mL.");
        }
        if (((TileEntityVacuumPump)this.te).turning) {
            pressureStatText.add("\u00a77Currently sucking at:");
            pressureStatText.add("\u00a70" + (double)Math.round(2.0f * ((TileEntityVacuumPump)this.te).getSpeedMultiplierFromUpgrades()) + " mL/tick.");
        }
    }

    @Override
    protected void addProblems(List<String> textList) {
        super.addProblems(textList);
        if (((TileEntityVacuumPump)this.te).getAirHandler(((TileEntityVacuumPump)this.te).getInputSide()).getPressure() < 2.0f) {
            textList.add("gui.tab.problems.notEnoughPressure");
            textList.add(I18n.func_135052_a((String)"gui.tab.problems.applyPressure", (Object[])new Object[]{Float.valueOf(2.0f)}));
        }
    }
}

