/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.routing;

import WayofTime.bloodmagic.routing.IItemFilter;
import WayofTime.bloodmagic.util.Utils;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class DefaultItemFilter
implements IItemFilter {
    protected TileEntity accessedTile;
    protected IItemHandler itemHandler;

    @Override
    public void initializeFilter(List<ItemStack> filteredList, TileEntity tile, IItemHandler itemHandler, boolean isFilterOutput) {
        this.accessedTile = tile;
        this.itemHandler = itemHandler;
    }

    @Override
    public ItemStack transferStackThroughOutputFilter(ItemStack inputStack) {
        int allowedAmount = inputStack.func_190916_E();
        if (allowedAmount <= 0) {
            return inputStack;
        }
        ItemStack testStack = inputStack.func_77946_l();
        testStack.func_190920_e(allowedAmount);
        ItemStack remainderStack = Utils.insertStackIntoTile(testStack, this.itemHandler);
        int changeAmount = allowedAmount - (remainderStack.func_190926_b() ? 0 : remainderStack.func_190916_E());
        testStack = inputStack.func_77946_l();
        testStack.func_190918_g(changeAmount);
        World world = this.accessedTile.func_145831_w();
        BlockPos pos = this.accessedTile.func_174877_v();
        world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
        return testStack;
    }

    @Override
    public int transferThroughInputFilter(IItemFilter outputFilter, int maxTransfer) {
        for (int slot = 0; slot < this.itemHandler.getSlots(); ++slot) {
            ItemStack inputStack = this.itemHandler.getStackInSlot(slot);
            if (inputStack.func_190926_b() || this.itemHandler.extractItem(slot, inputStack.func_190916_E(), true).func_190926_b()) continue;
            int allowedAmount = Math.min(this.itemHandler.extractItem(slot, inputStack.func_190916_E(), true).func_190916_E(), maxTransfer);
            ItemStack testStack = inputStack.func_77946_l();
            testStack.func_190920_e(allowedAmount);
            ItemStack remainderStack = outputFilter.transferStackThroughOutputFilter(testStack);
            int changeAmount = allowedAmount - (remainderStack.func_190926_b() ? 0 : remainderStack.func_190916_E());
            if (!remainderStack.func_190926_b() && remainderStack.func_190916_E() == allowedAmount) continue;
            this.itemHandler.extractItem(slot, changeAmount, false);
            World world = this.accessedTile.func_145831_w();
            BlockPos pos = this.accessedTile.func_174877_v();
            world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
            return changeAmount;
        }
        return 0;
    }

    @Override
    public boolean doesStackMatchFilter(ItemStack testStack) {
        return true;
    }

    @Override
    public boolean doStacksMatch(ItemStack filterStack, ItemStack testStack) {
        return true;
    }
}

