/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.errors;

import com.google.common.collect.ImmutableSet;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorState;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.PacketBuffer;

public class ErrorLogic
implements IErrorLogic {
    private final Set<IErrorState> errorStates = new HashSet<IErrorState>();

    @Override
    public final boolean setCondition(boolean condition, IErrorState errorState) {
        if (errorState == null) {
            return false;
        }
        if (condition) {
            this.errorStates.add(errorState);
        } else {
            this.errorStates.remove(errorState);
        }
        return condition;
    }

    @Override
    public final boolean contains(IErrorState state) {
        return this.errorStates.contains(state);
    }

    @Override
    public final boolean hasErrors() {
        return !this.errorStates.isEmpty();
    }

    @Override
    public final ImmutableSet<IErrorState> getErrorStates() {
        return ImmutableSet.copyOf(this.errorStates);
    }

    @Override
    public void clearErrors() {
        this.errorStates.clear();
    }

    @Override
    public void writeData(PacketBuffer data) {
        data.writeShort(this.errorStates.size());
        for (IErrorState errorState : this.errorStates) {
            data.writeShort((int)errorState.getID());
        }
    }

    @Override
    public void readData(PacketBuffer data) {
        this.clearErrors();
        int errorStateCount = data.readShort();
        for (int i = 0; i < errorStateCount; ++i) {
            short errorStateId = data.readShort();
            IErrorState errorState = ForestryAPI.errorStateRegistry.getErrorState(errorStateId);
            if (errorState == null) continue;
            this.errorStates.add(errorState);
        }
    }
}

