/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils.datastructures;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;

public class RevolvingList<T> {
    private final Deque<T> list = new LinkedList<T>();

    public RevolvingList(Collection<? extends T> collection) {
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0);
        for (T object : collection) {
            Preconditions.checkNotNull(object);
            this.list.add(object);
        }
    }

    public void rotateLeft() {
        this.list.addFirst(this.list.removeLast());
    }

    public void rotateRight() {
        this.list.addLast(this.list.removeFirst());
    }

    public T getCurrent() {
        return this.list.getFirst();
    }

    public void setCurrent(T e) {
        if (!this.list.contains(e)) {
            return;
        }
        while (!this.getCurrent().equals(e)) {
            this.rotateRight();
        }
    }
}

