/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.handler;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import vazkii.patchouli.common.network.NetworkHandler;
import vazkii.patchouli.common.network.message.MessageSyncAdvancements;

public final class AdvancementSyncHandler {
    private static final Set<EntityPlayerMP> playersToUpdate = new HashSet<EntityPlayerMP>();

    @SubscribeEvent
    public static void onAdvancement(AdvancementEvent event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            playersToUpdate.add((EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !playersToUpdate.isEmpty()) {
            for (EntityPlayerMP player : playersToUpdate) {
                AdvancementSyncHandler.syncPlayer(player, true);
            }
            playersToUpdate.clear();
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            AdvancementSyncHandler.syncPlayer((EntityPlayerMP)event.player, false);
        }
    }

    public static void syncPlayer(EntityPlayerMP player, boolean showToast) {
        NetworkHandler.INSTANCE.sendTo((IMessage)new MessageSyncAdvancements(showToast), player);
    }
}

