/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.advert;

import io.netty.buffer.ByteBuf;
import net.malisis.advert.advert.ClientAdvert;
import net.malisis.core.renderer.icon.Icon;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AdvertSelection {
    public int id;
    public Icon icon;
    public float u = 0.0f;
    public float v = 0.0f;
    public float U = 1.0f;
    public float V = 1.0f;

    public AdvertSelection(int id, float u, float v, float U, float V) {
        this.id = id;
        this.setUVs(u, v, U, V);
    }

    public AdvertSelection(int id) {
        this(id, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public void setUVs(float u, float v, float U, float V) {
        this.u = Math.max(0.0f, u);
        this.v = Math.max(0.0f, v);
        this.U = Math.min(1.0f, U);
        this.V = Math.min(1.0f, V);
    }

    public ClientAdvert getAdvert() {
        return ClientAdvert.get(this.id);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = new Icon("AS." + this.id, this.u, this.v, this.U, this.V);
        }
        return this.icon;
    }

    public int height() {
        ClientAdvert ad = this.getAdvert();
        if (ad == null) {
            return 1;
        }
        return ad.getHeight();
    }

    public int width() {
        ClientAdvert ad = this.getAdvert();
        if (ad == null) {
            return 1;
        }
        return ad.getWidth();
    }

    public void setPixels(int x, int y, int X, int Y) {
        this.setUVs(this.getU(x), this.getV(y), this.getU(X), this.getV(Y));
    }

    public float getU(int x) {
        return (float)x / (float)this.width();
    }

    public float getV(int y) {
        return (float)y / (float)this.height();
    }

    public int getX(float u) {
        return Math.round((float)this.width() * u);
    }

    public int getY(float v) {
        return Math.round((float)this.height() * v);
    }

    public void toNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("advert", this.id);
        nbt.func_74776_a("u", this.u);
        nbt.func_74776_a("v", this.v);
        nbt.func_74776_a("U", this.U);
        nbt.func_74776_a("V", this.V);
    }

    public void toBytes(ByteBuf buf) {
        if (this.getAdvert() == null) {
            return;
        }
        buf.writeInt(this.id);
        buf.writeFloat(this.u);
        buf.writeFloat(this.v);
        buf.writeFloat(this.U);
        buf.writeFloat(this.V);
    }

    public static AdvertSelection fromNBT(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("advert")) {
            return null;
        }
        AdvertSelection as = new AdvertSelection(nbt.func_74762_e("advert"), nbt.func_74760_g("u"), nbt.func_74760_g("v"), nbt.func_74760_g("U"), nbt.func_74760_g("V"));
        return as;
    }

    public static AdvertSelection fromBytes(ByteBuf buf) {
        AdvertSelection as = new AdvertSelection(buf.readInt(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat());
        return as;
    }
}

