/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile;

import appeng.tile.AEBaseTile;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public abstract class AEBaseInvTile
extends AEBaseTile
implements IAEAppEngInventory {
    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        IItemHandler inv = this.getInternalInventory();
        if (inv != EmptyHandler.INSTANCE) {
            NBTTagCompound opt = data.func_74775_l("inv");
            for (int x = 0; x < inv.getSlots(); ++x) {
                NBTTagCompound item = opt.func_74775_l("item" + x);
                ItemHandlerUtil.setStackInSlot(inv, x, new ItemStack(item));
            }
        }
    }

    @Nonnull
    public abstract IItemHandler getInternalInventory();

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        IItemHandler inv = this.getInternalInventory();
        if (inv != EmptyHandler.INSTANCE) {
            NBTTagCompound opt = new NBTTagCompound();
            for (int x = 0; x < inv.getSlots(); ++x) {
                NBTTagCompound item = new NBTTagCompound();
                ItemStack is = inv.getStackInSlot(x);
                if (!is.func_190926_b()) {
                    is.func_77955_b(item);
                }
                opt.func_74782_a("item" + x, (NBTBase)item);
            }
            data.func_74782_a("inv", (NBTBase)opt);
        }
        return data;
    }

    @Override
    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        IItemHandler inv = this.getInternalInventory();
        for (int l = 0; l < inv.getSlots(); ++l) {
            ItemStack is = inv.getStackInSlot(l);
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
    }

    @Override
    public abstract void onChangeInventory(IItemHandler var1, int var2, InvOperation var3, ItemStack var4, ItemStack var5);

    public ITextComponent func_145748_c_() {
        if (this.hasCustomInventoryName()) {
            return new TextComponentString(this.getCustomInventoryName());
        }
        return new TextComponentTranslation(this.func_145838_q().func_149739_a(), new Object[0]);
    }

    @Nonnull
    protected IItemHandler getItemHandlerForSide(@Nonnull EnumFacing side) {
        return this.getInternalInventory();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return this.getInternalInventory() != EmptyHandler.INSTANCE;
            }
            return this.getItemHandlerForSide(facing) != EmptyHandler.INSTANCE;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)this.getInternalInventory();
            }
            return (T)this.getItemHandlerForSide(facing);
        }
        return (T)super.getCapability(capability, facing);
    }
}

