/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.entity;

import crafttweaker.api.block.IBlockDefinition;
import crafttweaker.api.block.IMaterial;
import crafttweaker.api.damage.IDamageSource;
import crafttweaker.api.data.IData;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.entity.IEntityItem;
import crafttweaker.api.game.ITeam;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.server.IServer;
import crafttweaker.api.util.Position3f;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IRayTraceResult;
import crafttweaker.api.world.IVector3d;
import crafttweaker.api.world.IWorld;
import crafttweaker.mc1120.command.MCCommandSender;
import crafttweaker.mc1120.data.NBTConverter;
import crafttweaker.mc1120.entity.MCEntityDefinition;
import crafttweaker.mc1120.server.MCServer;
import crafttweaker.mc1120.util.MCPosition3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class MCEntity
extends MCCommandSender
implements IEntity {
    private Entity entity;

    public MCEntity(Entity entity) {
        super((ICommandSender)entity);
        this.entity = entity;
    }

    @Override
    public int getDimension() {
        return this.entity.field_71093_bK;
    }

    @Override
    public void setDimension(int dimensionID) {
        this.entity = this.entity.func_184204_a(dimensionID);
    }

    @Override
    public double getX() {
        return this.entity.field_70165_t;
    }

    @Override
    public double getY() {
        return this.entity.field_70163_u;
    }

    @Override
    public double getZ() {
        return this.entity.field_70161_v;
    }

    @Override
    public Position3f getPosition3f() {
        return new MCPosition3f((float)this.entity.field_70165_t, (float)this.entity.field_70163_u, (float)this.entity.field_70161_v);
    }

    @Override
    public void setPosition3f(Position3f position3f) {
        this.entity.func_70107_b((double)position3f.getX(), (double)position3f.getY(), (double)position3f.getZ());
    }

    @Override
    public void setPosition(IBlockPos position) {
        this.entity.func_70107_b((double)position.getX(), (double)position.getY(), (double)position.getZ());
    }

    @Override
    public void setDead() {
        this.entity.func_70106_y();
    }

    @Override
    public void setFire(int seconds) {
        this.entity.func_70015_d(seconds);
    }

    @Override
    public void extinguish() {
        this.entity.func_70066_B();
    }

    @Override
    public boolean isWet() {
        return this.entity.func_70026_G();
    }

    @Override
    public List<IEntity> getPassengers() {
        return this.entity.func_184188_bt().stream().map(CraftTweakerMC::getIEntity).collect(Collectors.toList());
    }

    @Override
    public double getDistanceSqToEntity(IEntity otherEntity) {
        return this.entity.func_70032_d(CraftTweakerMC.getEntity(otherEntity));
    }

    @Override
    public boolean isAlive() {
        return this.entity.func_70089_S();
    }

    @Override
    public IEntity getRidingEntity() {
        return CraftTweakerMC.getIEntity(this.entity.func_184187_bx());
    }

    @Override
    public IItemStack getPickedResult() {
        return CraftTweakerMC.getIItemStack(this.entity.getPickedResult(new RayTraceResult(this.entity)));
    }

    @Override
    public String getCustomName() {
        return this.entity.func_95999_t();
    }

    @Override
    public void setCustomName(String name) {
        this.entity.func_96094_a(name);
    }

    @Override
    public boolean isImmuneToFire() {
        return this.entity.func_70045_F();
    }

    @Override
    public int getAir() {
        return this.entity.func_70086_ai();
    }

    @Override
    public void setAir(int amount) {
        this.entity.func_70050_g(amount);
    }

    public Entity getInternal() {
        return this.entity;
    }

    @Override
    public boolean canTrample(IWorld world, IBlockDefinition block, IBlockPos pos, float fall) {
        return this.entity.canTrample(CraftTweakerMC.getWorld(world), CraftTweakerMC.getBlock(block), CraftTweakerMC.getBlockPos(pos), fall);
    }

    public String toString() {
        return this.entity.toString();
    }

    @Override
    public boolean isInvulnerableTo(IDamageSource source) {
        return this.entity.func_180431_b(CraftTweakerMC.getDamageSource(source));
    }

    @Override
    public boolean isInvulnerable() {
        return this.entity.func_190530_aW();
    }

    @Override
    public void setInvulnerable(boolean invulnerable) {
        this.entity.func_184224_h(invulnerable);
    }

    @Override
    public void setToLocationFrom(IEntity other) {
        this.entity.func_82149_j(CraftTweakerMC.getEntity(other));
    }

    @Override
    public boolean isBoss() {
        return !this.entity.func_184222_aU();
    }

    @Override
    public int getMaxFallHeight() {
        return this.entity.func_82143_as();
    }

    @Override
    public boolean doesTriggerPressurePlate() {
        return !this.entity.func_145773_az();
    }

    @Override
    public boolean isPushedByWater() {
        return this.entity.func_96092_aw();
    }

    @Override
    public String getDisplayName() {
        return this.entity.func_145748_c_().func_150254_d();
    }

    @Override
    public boolean hasCustomName() {
        return this.entity.func_145818_k_();
    }

    @Override
    public boolean alwaysRenderNameTag() {
        return this.entity.func_174833_aM();
    }

    @Override
    public void setAlwaysRenderNameTag(boolean alwaysRenderNameTag) {
        this.entity.func_174805_g(alwaysRenderNameTag);
    }

    @Override
    public float getEyeHight() {
        return this.entity.func_70047_e();
    }

    @Override
    public boolean isOutsideBorder() {
        return this.entity.func_174832_aS();
    }

    @Override
    public void setOutsideBorder(boolean outsideBorder) {
        this.entity.func_174821_h(outsideBorder);
    }

    @Override
    public IServer getServer() {
        return new MCServer(this.entity.func_184102_h());
    }

    @Override
    public boolean isImmuneToExplosions() {
        return this.entity.func_180427_aV();
    }

    @Override
    public boolean shouldRiderSit() {
        return this.entity.shouldRiderSit();
    }

    @Override
    public boolean canRiderInteract() {
        return this.entity.canRiderInteract();
    }

    @Override
    public boolean shouldRiderDismountInWater(IEntity rider) {
        return this.entity.shouldDismountInWater(CraftTweakerMC.getEntity(rider));
    }

    @Override
    public IEntity getControllingPassenger() {
        return CraftTweakerMC.getIEntity(this.entity.func_184179_bs());
    }

    @Override
    public boolean isPassenger(IEntity passenger) {
        return this.entity.func_184196_w(CraftTweakerMC.getEntity(passenger));
    }

    @Override
    public List<IEntity> getPassengersRecursive() {
        return this.entity.func_184182_bu().stream().map(CraftTweakerMC::getIEntity).collect(Collectors.toList());
    }

    @Override
    public IEntity getLowestRidingEntity() {
        return CraftTweakerMC.getIEntity(this.entity.func_184208_bv());
    }

    @Override
    public boolean isRidingSameEntity(IEntity other) {
        return this.entity.func_184223_x(CraftTweakerMC.getEntity(other));
    }

    @Override
    public boolean canPassengerSteer() {
        return this.entity.func_184186_bw();
    }

    @Override
    public float getRotationYaw() {
        return this.entity.field_70177_z;
    }

    @Override
    public void setRotationYaw(float rotationYaw) {
        this.entity.field_70177_z = rotationYaw;
    }

    @Override
    public float getRotationPitch() {
        return this.entity.field_70125_A;
    }

    @Override
    public void setRotationPitch(float rotationPitch) {
        this.entity.field_70125_A = rotationPitch;
    }

    @Override
    public double getMotionX() {
        return this.entity.field_70159_w;
    }

    @Override
    public void setMotionX(double motionX) {
        this.entity.field_70159_w = motionX;
    }

    @Override
    public double getMotionY() {
        return this.entity.field_70181_x;
    }

    @Override
    public void setMotionY(double motionY) {
        this.entity.field_70181_x = motionY;
    }

    @Override
    public double getMotionZ() {
        return this.entity.field_70179_y;
    }

    @Override
    public void setMotionZ(double motionZ) {
        this.entity.field_70179_y = motionZ;
    }

    @Override
    public double getPosX() {
        return this.entity.field_70165_t;
    }

    @Override
    public void setPosX(double posX) {
        this.entity.func_70107_b(posX, this.entity.field_70163_u, this.entity.field_70161_v);
    }

    @Override
    public double getPosY() {
        return this.entity.field_70163_u;
    }

    @Override
    public void setPosY(double posY) {
        this.entity.func_70107_b(this.entity.field_70165_t, posY, this.entity.field_70161_v);
    }

    @Override
    public double getPosZ() {
        return this.entity.field_70161_v;
    }

    @Override
    public void setPosZ(double posZ) {
        this.entity.func_70107_b(this.entity.field_70165_t, this.entity.field_70163_u, posZ);
    }

    @Override
    public IVector3d getLookingDirection() {
        return CraftTweakerMC.getIVector3d(this.entity.func_70040_Z());
    }

    @Override
    public IRayTraceResult getRayTrace(double blockReachDistance, float partialTicks) {
        return CraftTweakerMC.getIRayTraceResult(this.entity.func_174822_a(blockReachDistance, partialTicks));
    }

    @Override
    public IRayTraceResult getRayTrace(double blockReachDistance, float partialTicks, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        Vec3d positionEyes = this.entity.func_174824_e(partialTicks);
        Vec3d lookingDirection = this.entity.func_70676_i(partialTicks);
        Vec3d lookingVector = positionEyes.func_72441_c(lookingDirection.field_72450_a * blockReachDistance, lookingDirection.field_72448_b * blockReachDistance, lookingDirection.field_72449_c * blockReachDistance);
        return CraftTweakerMC.getIRayTraceResult(this.entity.field_70170_p.func_147447_a(positionEyes, lookingVector, stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock));
    }

    @Override
    public IWorld getWorld() {
        return CraftTweakerMC.getIWorld(this.entity.func_130014_f_());
    }

    @Override
    public IEntityDefinition getDefinition() {
        for (Map.Entry entry : ForgeRegistries.ENTITIES.getEntries()) {
            if (((EntityEntry)entry.getValue()).getEntityClass() != this.entity.getClass()) continue;
            return new MCEntityDefinition((EntityEntry)entry.getValue());
        }
        return null;
    }

    @Override
    public void setWorld(IWorld world) {
        this.entity.func_70029_a(CraftTweakerMC.getWorld(world));
    }

    @Override
    public void onEntityUpdate() {
        this.entity.func_70030_z();
    }

    @Override
    public void onUpdate() {
        this.entity.func_70071_h_();
    }

    @Override
    public boolean isSprinting() {
        return this.entity.func_70051_ag();
    }

    @Override
    public void setSprinting(boolean sprinting) {
        this.entity.func_70031_b(sprinting);
    }

    @Override
    public boolean isGlowing() {
        return this.entity.func_184202_aL();
    }

    @Override
    public void setGlowing(boolean glowing) {
        this.entity.func_184195_f(glowing);
    }

    @Override
    public int getID() {
        return this.entity.func_145782_y();
    }

    @Override
    public void setID(int id) {
        this.entity.func_145769_d(id);
    }

    @Override
    public List<String> getTags() {
        return new ArrayList<String>(this.entity.func_184216_O());
    }

    @Override
    public void addTag(String tag) {
        this.entity.func_184211_a(tag);
    }

    @Override
    public void removeTag(String tag) {
        this.entity.func_184197_b(tag);
    }

    @Override
    public void onKillCommand() {
        this.entity.func_174812_G();
    }

    @Override
    public int getMaxInPortalTime() {
        return this.entity.func_82145_z();
    }

    @Override
    public int getPortalCooldown() {
        return this.entity.func_82147_ab();
    }

    @Override
    public boolean isSilent() {
        return this.entity.func_174814_R();
    }

    @Override
    public void setSilent(boolean silent) {
        this.entity.func_174810_b(silent);
    }

    @Override
    public boolean hasNoGravity() {
        return this.entity.func_189652_ae();
    }

    @Override
    public void setNoGravity(boolean noGravity) {
        this.entity.func_189654_d(noGravity);
    }

    @Override
    public boolean isInWater() {
        return this.entity.func_70090_H();
    }

    @Override
    public boolean isOverWater() {
        return this.entity.func_191953_am();
    }

    @Override
    public void spawnRunningParticles() {
        this.entity.func_174830_Y();
    }

    @Override
    public boolean isInsideOfMaterial(IMaterial material) {
        return this.entity.func_70055_a(CraftTweakerMC.getMaterial(material));
    }

    @Override
    public boolean isInLava() {
        return this.entity.func_180799_ab();
    }

    @Override
    public boolean attackEntityFrom(IDamageSource source, float amount) {
        return this.entity.func_70097_a(CraftTweakerMC.getDamageSource(source), amount);
    }

    @Override
    public boolean canBeCollidedWith() {
        return this.entity.func_70067_L();
    }

    @Override
    public boolean canBePushed() {
        return this.entity.func_70104_M();
    }

    @Override
    public IData getNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        this.entity.func_189511_e(tag);
        return NBTConverter.from((NBTBase)tag, true);
    }

    @Override
    public IEntityItem dropItem(IItemStack itemStack, float offset) {
        return CraftTweakerMC.getIEntityItem(this.entity.func_70099_a(CraftTweakerMC.getItemStack(itemStack), offset));
    }

    @Override
    public boolean isInsideOpaqueBlock() {
        return this.entity.func_70094_T();
    }

    @Override
    public void removePassengers() {
        this.entity.func_184226_ay();
    }

    @Override
    public void dismountRidingEntity() {
        this.entity.func_184210_p();
    }

    @Override
    public List<IItemStack> getHeldEquipment() {
        ArrayList<IItemStack> output = new ArrayList<IItemStack>();
        this.entity.func_184214_aD().forEach(item -> output.add(CraftTweakerMC.getIItemStack(item)));
        return output;
    }

    @Override
    public List<IItemStack> getArmorInventoryList() {
        ArrayList<IItemStack> output = new ArrayList<IItemStack>();
        this.entity.func_184193_aE().forEach(item -> output.add(CraftTweakerMC.getIItemStack(item)));
        return output;
    }

    @Override
    public List<IItemStack> getEquipmentAndArmor() {
        ArrayList<IItemStack> output = new ArrayList<IItemStack>();
        this.entity.func_184209_aF().forEach(item -> output.add(CraftTweakerMC.getIItemStack(item)));
        return output;
    }

    @Override
    public boolean isBurning() {
        return this.entity.func_70027_ad();
    }

    @Override
    public boolean isRiding() {
        return this.entity.func_184218_aH();
    }

    @Override
    public boolean isBeingRidden() {
        return this.entity.func_184207_aI();
    }

    @Override
    public boolean isSneaking() {
        return this.entity.func_70093_af();
    }

    @Override
    public void setSneaking(boolean sneaking) {
        this.entity.func_70095_a(sneaking);
    }

    @Override
    public boolean isInvisible() {
        return this.entity.func_82150_aj();
    }

    @Override
    public ITeam getTeam() {
        return CraftTweakerMC.getITeam(this.entity.func_96124_cp());
    }

    @Override
    public void setInvisible(boolean invisible) {
        this.entity.func_82142_c(invisible);
    }

    @Override
    public boolean isOnSameTeam(IEntity other) {
        return this.entity.func_184191_r(CraftTweakerMC.getEntity(other));
    }

    @Override
    public void setInWeb() {
        this.entity.func_70110_aj();
    }

    @Override
    public IEntity[] getParts() {
        Entity[] parts = this.entity.func_70021_al();
        if (parts == null) {
            return new IEntity[0];
        }
        IEntity[] output = new IEntity[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            output[i] = CraftTweakerMC.getIEntity(parts[i]);
        }
        return output;
    }

    @Override
    public boolean isEntityEqual(IEntity other) {
        return this.entity.func_70028_i(CraftTweakerMC.getEntity(other));
    }

    @Override
    public boolean canBeAttackedWithItem() {
        return this.entity.func_70075_an();
    }

    @Override
    public void update(IData data) {
        NBTConverter.updateMap(this.entity.getEntityData(), data);
    }

    public boolean equals(Object obj) {
        return obj instanceof MCEntity && this.entity.func_70028_i(((MCEntity)obj).entity) || super.equals(obj);
    }

    @Override
    public boolean onGround() {
        return this.entity.field_70122_E;
    }
}

