/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tickcentral.asm;

import com.github.terminatornl.tickcentral.TickCentral;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.asm.ASMTransformerWrapper;
import net.minecraftforge.fml.common.asm.transformers.ModAPITransformer;

public class Compatibility {
    private static boolean applied = false;

    public static void FixTransformerOrdering() {
        if (applied) {
            return;
        }
        applied = true;
        try {
            Field transformerField = LaunchClassLoader.class.getDeclaredField("transformers");
            transformerField.setAccessible(true);
            List transformers = (List)transformerField.get(Compatibility.class.getClassLoader());
            transformerField.set(Compatibility.class.getClassLoader(), new OrderedArrayList(transformers, TickCentral.INSTANCE.getPrioritizedASMTransformers()));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static class OrderedArrayList
    extends ArrayList<IClassTransformer> {
        private final Collection<Class<? extends IClassTransformer>> bias;
        private final Field transformerField;

        public OrderedArrayList(List<IClassTransformer> list, Collection<Class<? extends IClassTransformer>> bias) throws NoSuchFieldException {
            super(list);
            this.bias = bias;
            this.transformerField = ASMTransformerWrapper.TransformerWrapper.class.getDeclaredField("parent");
            this.transformerField.setAccessible(true);
            this.sortSelf();
        }

        @Override
        public final boolean add(IClassTransformer transformer) {
            boolean val = super.add(transformer);
            this.sortSelf();
            return val;
        }

        @Override
        public final void add(int index, IClassTransformer transformer) {
            super.add(index, transformer);
            this.sortSelf();
        }

        private void sortSelf() {
            this.sort((one, two) -> {
                if (one instanceof ASMTransformerWrapper.TransformerWrapper) {
                    try {
                        one = (IClassTransformer)this.transformerField.get(one);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (two instanceof ASMTransformerWrapper.TransformerWrapper) {
                    try {
                        two = (IClassTransformer)this.transformerField.get(two);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                int r = 0;
                if (one instanceof ModAPITransformer) {
                    r += 10;
                } else if (two instanceof ModAPITransformer) {
                    r += 10;
                }
                for (Class<? extends IClassTransformer> b : this.bias) {
                    if (b.isAssignableFrom(one.getClass())) {
                        ++r;
                    }
                    if (!b.isAssignableFrom(two.getClass())) continue;
                    --r;
                }
                return r;
            });
        }
    }
}

