/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore;

import asmodeuscore.api.IBodies;
import asmodeuscore.api.IBodiesHandler;
import asmodeuscore.core.astronomy.BodiesRegistry;
import asmodeuscore.core.astronomy.SpaceData;
import asmodeuscore.core.configs.AsmodeusConfig;
import asmodeuscore.core.event.AsmodeusEvent;
import asmodeuscore.core.handler.capabilities.ACCapabilityStatsHandler;
import asmodeuscore.core.network.packet.AsmodeusChannelHandler;
import asmodeuscore.core.proxy.CommonProxy;
import asmodeuscore.core.registers.potions.ACPotions;
import asmodeuscore.core.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="asmodeuscore", version="0.0.25", dependencies="required-after:forge@[14.23.1.2555,); after:planetprogression@[0.4.6,); after:galacticraftcore@[4.0.2.261,]; after:galacticraftplanets;", acceptedMinecraftVersions="[1.12.2]", name="AsmodeusCore")
public class AsmodeusCore {
    public static final int major_version = 0;
    public static final int minor_version = 0;
    public static final int build_version = 25;
    public static final String NAME = "AsmodeusCore";
    public static final String MODID = "asmodeuscore";
    public static final String VERSION = "0.0.25";
    public static final String ASSET_PREFIX = "asmodeuscore";
    public static final String TEXTURE_PREFIX = "asmodeuscore:";
    public static AsmodeusChannelHandler packetPipeline;
    public static List<IBodies> bodies;
    @Mod.Instance(value="asmodeuscore")
    public static AsmodeusCore INSTANCE;
    @SidedProxy(clientSide="asmodeuscore.core.proxy.ClientProxy", serverSide="asmodeuscore.core.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void construct(FMLConstructionEvent event) {
        for (ASMDataTable.ASMData data : event.getASMHarvestedData().getAll(IBodiesHandler.class.getName())) {
            try {
                IBodies body = (IBodies)Class.forName(data.getClassName()).newInstance();
                bodies.add(body);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(bodies, new Comparator<IBodies>(){

            @Override
            public int compare(IBodies lhs, IBodies rhs) {
                int y;
                int x = rhs.getPriority();
                return x < (y = lhs.getPriority()) ? -1 : (x == y ? 0 : 1);
            }
        });
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.initModInfo(event.getModMetadata());
        new AsmodeusConfig(new File(event.getModConfigurationDirectory(), "AsmodeusCore/core.conf"));
        ACCapabilityStatsHandler.register();
        ACPotions.initialize();
        packetPipeline = AsmodeusChannelHandler.init();
        proxy.preload();
        proxy.register_event(new AsmodeusEvent());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.load();
        BodiesRegistry.registerCelestialBody(SpaceData.getRegisteredCelestialBodies());
        SpaceData.refreshGalaxies();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postload();
    }

    private void initModInfo(ModMetadata info) {
        info.autogenerated = false;
        info.modId = "asmodeuscore";
        info.name = NAME;
        info.version = VERSION;
        info.description = "Technical lib for BlesseNtumble mods.";
        info.authorList = Arrays.asList("BlesseNtumble");
    }

    static {
        bodies = new ArrayList<IBodies>();
    }

    @Mod.EventBusSubscriber(modid="asmodeuscore")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerBiomes(RegistryEvent.Register<Biome> event) {
            event.getRegistry().register((IForgeRegistryEntry)Utils.WE_Biome);
            if (!ConfigManagerCore.disableBiomeTypeRegistrations) {
                BiomeDictionary.addTypes((Biome)Utils.WE_Biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.DEAD});
            }
        }
    }
}

