/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy.sky;

import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.api.dimension.IProviderFog;
import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_WorldProviderSpace;
import asmodeuscore.core.configs.AsmodeusConfig;
import asmodeuscore.core.utils.Utils;
import java.util.Calendar;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldProviderSurface;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class SkyProviderBase
extends IRenderHandler {
    private static final ResourceLocation sunTexture = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation pumpkinsunTexture = new ResourceLocation("asmodeuscore", "textures/environment/pumkinsun.png");
    private static final ResourceLocation lmcTexture = new ResourceLocation("asmodeuscore", "textures/environment/background/lmc.png");
    private static final ResourceLocation smcTexture = new ResourceLocation("asmodeuscore", "textures/environment/background/smc.png");
    private static final ResourceLocation andromedaTexture = new ResourceLocation("asmodeuscore", "textures/environment/background/andromeda.png");
    private static final ResourceLocation barnardaloopTexture = new ResourceLocation("asmodeuscore", "textures/environment/background/barnardaloop.png");
    private static final ResourceLocation[] milkywayTextures = new ResourceLocation[]{new ResourceLocation("asmodeuscore", "textures/environment/background/milky_way_1.png"), new ResourceLocation("asmodeuscore", "textures/environment/background/milky_way_2.png"), new ResourceLocation("asmodeuscore", "textures/environment/background/milky_way_3.png"), new ResourceLocation("asmodeuscore", "textures/environment/background/milky_way_4.png"), new ResourceLocation("asmodeuscore", "textures/environment/background/milky_way_5.png"), new ResourceLocation("asmodeuscore", "textures/environment/background/milky_way_6.png")};
    private final ResourceLocation planetToRender = new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/earth.png");
    private static boolean displayListIsGen;
    public static int starList;
    public static int glSkyList;
    public static int glSkyList2;
    private float sunSize;
    private float ticks;
    private float[] afloat = new float[4];
    protected Minecraft mc = Minecraft.func_71410_x();

    public SkyProviderBase() {
        if (!displayListIsGen) {
            this.initializeDisplayLists();
        }
    }

    private void initializeDisplayLists() {
        int l;
        int j;
        int displayLists = GLAllocation.func_74526_a((int)3);
        starList = displayLists;
        glSkyList = displayLists + 1;
        glSkyList2 = displayLists + 2;
        GL11.glPushMatrix();
        GL11.glNewList((int)starList, (int)4864);
        if (this.enableStar()) {
            this.renderStars();
        }
        GL11.glEndList();
        GL11.glPopMatrix();
        Tessellator tessellator = Tessellator.func_178181_a();
        GL11.glNewList((int)glSkyList, (int)4864);
        int byte2 = 64;
        int i = 256 / byte2 + 2;
        float f = 16.0f;
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        for (j = -byte2 * i; j <= byte2 * i; j += byte2) {
            for (l = -byte2 * i; l <= byte2 * i; l += byte2) {
                worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                worldRenderer.func_181662_b((double)(j + 0), (double)f, (double)(l + 0)).func_181675_d();
                worldRenderer.func_181662_b((double)(j + byte2), (double)f, (double)(l + 0)).func_181675_d();
                worldRenderer.func_181662_b((double)(j + byte2), (double)f, (double)(l + byte2)).func_181675_d();
                worldRenderer.func_181662_b((double)(j + 0), (double)f, (double)(l + byte2)).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        GL11.glEndList();
        GL11.glNewList((int)glSkyList2, (int)4864);
        f = -16.0f;
        worldRenderer = tessellator.func_178180_c();
        for (j = -byte2 * i; j <= byte2 * i; j += byte2) {
            for (l = -byte2 * i; l <= byte2 * i; l += byte2) {
                worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                worldRenderer.func_181662_b((double)(j + 0), (double)f, (double)(l + 0)).func_181675_d();
                worldRenderer.func_181662_b((double)(j + byte2), (double)f, (double)(l + 0)).func_181675_d();
                worldRenderer.func_181662_b((double)(j + byte2), (double)f, (double)(l + byte2)).func_181675_d();
                worldRenderer.func_181662_b((double)(j + 0), (double)f, (double)(l + byte2)).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        GL11.glEndList();
        displayListIsGen = true;
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        float sunBrightness;
        float f6;
        this.ticks = partialTicks;
        GL11.glDisable((int)3553);
        Vec3d vec3 = world.func_72833_a(mc.func_175606_aa(), partialTicks);
        float f1 = (float)vec3.field_72450_a;
        float f2 = (float)vec3.field_72448_b;
        float f3 = (float)vec3.field_72449_c;
        if (mc.field_71474_y.field_74337_g) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f6;
        }
        float temp = (float)(mc.field_71439_g.field_70163_u / 1000.0);
        GL11.glColor3f((float)(f1 - temp), (float)(f2 - temp), (float)(f3 - temp));
        Tessellator tessellator1 = Tessellator.func_178181_a();
        BufferBuilder worldRenderer1 = tessellator1.func_178180_c();
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2912);
        GL11.glCallList((int)glSkyList);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderHelper.func_74518_a();
        float f9 = 0.0f;
        float size = 0.0f;
        float rain = 1.0f - world.func_72867_j(partialTicks);
        if (rain < 0.3f) {
            rain = 0.3f;
        }
        float starBrightness = this.mc.field_71441_e.func_72896_J() ? this.mc.field_71441_e.func_72880_h(partialTicks) * rain : this.mc.field_71441_e.func_72880_h(partialTicks);
        float f = sunBrightness = this.mc.field_71441_e.func_72896_J() ? this.mc.field_71441_e.func_72971_b(partialTicks) * rain : this.mc.field_71441_e.func_72971_b(partialTicks);
        if (this.mc.field_71441_e.field_73011_w instanceof IProviderFog) {
            float fog = ((IProviderFog)this.mc.field_71441_e.field_73011_w).getFogDensity(0, 0, 0);
            starBrightness -= 1.0f - fog;
        }
        if (this.mc.field_71439_g.field_70163_u > 150.0 || starBrightness > 0.0f && !this.inWater((EntityPlayer)this.mc.field_71439_g)) {
            if (this.mc.field_71439_g.field_70163_u > 150.0) {
                starBrightness += (float)(this.mc.field_71439_g.field_70163_u / 1000.0);
            }
            GL11.glPushMatrix();
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(this.mc.field_71441_e.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            this.renderStarsOnSky(2, IAdvancedSpace.StarColor.ORANGE, starBrightness);
            this.renderStarsOnSky(8, IAdvancedSpace.StarColor.WHITE, starBrightness);
            this.renderStarsOnSky(1, IAdvancedSpace.StarColor.BLUE, starBrightness);
            this.renderStarsOnSky(1, IAdvancedSpace.StarColor.LIGHTBLUE, starBrightness);
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        this.afloat[0] = 1.0f;
        this.afloat[1] = 0.7607843f;
        this.afloat[2] = 0.7058824f;
        this.afloat[3] = 0.6f;
        if (this.colorSunAura() != null) {
            this.afloat[0] = this.colorSunAura().getColor().floatX() / 255.0f;
            this.afloat[1] = this.colorSunAura().getColor().floatY() / 255.0f;
            this.afloat[2] = this.colorSunAura().getColor().floatZ() / 255.0f;
        }
        f6 = this.afloat[0];
        float f7 = this.afloat[1];
        float f8 = this.afloat[2];
        if (mc.field_71474_y.field_74337_g) {
            f9 = (f6 * 30.0f + f7 * 59.0f + f8 * 11.0f) / 100.0f;
            size = (f6 * 30.0f + f7 * 70.0f) / 100.0f;
            float f11 = (f6 * 30.0f + f8 * 70.0f) / 100.0f;
            f6 = f9;
            f7 = size;
            f8 = f11;
        }
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(this.mc.field_71441_e.func_72826_c(this.ticks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        size = this.sunSize() + 5.5f;
        if (!this.inWater((EntityPlayer)this.mc.field_71439_g)) {
            this.renderSunAura(tessellator1, size + (float)this.expandSizeAura(), sunBrightness);
        }
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
        f7 = 0.0f;
        f8 = 0.0f;
        f9 = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - Minecraft.func_71410_x().field_71441_e.func_72867_j(partialTicks)));
        GL11.glTranslatef((float)f7, (float)f8, (float)f9);
        if (this.modeLight() != ModeLight.WITHOUT_SUN && !this.inWater((EntityPlayer)this.mc.field_71439_g)) {
            Calendar calendar = Calendar.getInstance();
            boolean flag = false;
            if (calendar.get(2) + 1 == 10 && calendar.get(5) >= 30 && calendar.get(5) <= 31 || calendar.get(2) + 1 == 11 && calendar.get(5) <= 1) {
                flag = true;
            }
            size = this.sunSize();
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(this.mc.field_71441_e.func_72826_c(this.ticks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(flag ? pumpkinsunTexture : (this.sunImage() != null ? this.sunImage() : sunTexture));
            if (this.enableSmoothRender()) {
                GL11.glDisable((int)3042);
            }
            worldRenderer1.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer1.func_181662_b((double)(-size), 99.9, (double)(-size)).func_187315_a(0.0, 0.0).func_181675_d();
            worldRenderer1.func_181662_b((double)size, 99.9, (double)(-size)).func_187315_a(1.0, 0.0).func_181675_d();
            worldRenderer1.func_181662_b((double)size, 99.9, (double)size).func_187315_a(1.0, 1.0).func_181675_d();
            worldRenderer1.func_181662_b((double)(-size), 99.9, (double)size).func_187315_a(0.0, 1.0).func_181675_d();
            tessellator1.func_78381_a();
            if (this.enableSmoothRender()) {
                GL11.glEnable((int)3042);
            }
        }
        if (this.enableBaseImages() && !this.inWater((EntityPlayer)this.mc.field_71439_g)) {
            float light = 0.0f;
            if (this.modeLight() == ModeLight.DEFAULT) {
                light = starBrightness;
            }
            if (this.modeLight() == ModeLight.ALWAYS_LIGHT) {
                light = 1.0f;
            }
            this.renderImage(lmcTexture, -150.0f, 20.0f, 0.0f, 15.0f, light);
            this.renderImage(smcTexture, 88.0f, -40.0f, 0.0f, 5.0f, light);
            this.renderImage(andromedaTexture, -30.0f, -100.0f, -0.0f, 4.0f, light);
            this.renderImage(barnardaloopTexture, 35.0f, -120.0f, 0.0f, 40.0f, light);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            float x = 190.0f;
            this.renderImage(milkywayTextures[0], (-4.0f + x) % 360.0f, -90.0f, 0.0f, 60.0f, light);
            this.renderImage(milkywayTextures[1], (58.0f + x) % 360.0f, -90.0f, 0.0f, 60.0f, light);
            this.renderImage(milkywayTextures[2], (120.0f + x) % 360.0f, -90.0f, 0.0f, 60.2f, light);
            this.renderImage(milkywayTextures[3], (182.0f + x) % 360.0f, -90.0f, 0.0f, 60.0f, light);
            this.renderImage(milkywayTextures[4], (244.0f + x) % 360.0f, -90.0f, 0.0f, 60.2f, light);
            this.renderImage(milkywayTextures[5], (306.0f + x) % 360.0f, -90.0f, 0.0f, 60.0f, light);
        }
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        this.rendererSky(tessellator1, worldRenderer1, size, partialTicks);
        GL11.glPushMatrix();
        if (mc.field_71439_g.field_70163_u > 190.0 && this.enableRenderPlanet()) {
            GL11.glEnable((int)3008);
            size = mc.field_71439_g.field_70163_u < 400.0 ? 800.0f - (float)mc.field_71439_g.field_70163_u : 300.0f;
            float color = mc.field_71441_e.func_72880_h(this.ticks);
            GL11.glColor4f((float)(1.0f - color), (float)(1.0f - color), (float)(1.0f - color), (float)1.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-360.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)(-((float)mc.field_71439_g.field_70163_u) / 4.0f), (float)0.0f);
            if (!(mc.field_71441_e.field_73011_w instanceof WorldProviderSurface)) {
                mc.field_71446_o.func_110577_a(((IGalacticraftWorldProvider)mc.field_71441_e.field_73011_w).getCelestialBody().getBodyIcon());
            } else {
                mc.field_71446_o.func_110577_a(this.planetToRender);
            }
            worldRenderer1.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer1.func_181662_b((double)(-size), -100.0, (double)size).func_187315_a(0.0, 1.0).func_181675_d();
            worldRenderer1.func_181662_b((double)size, -100.0, (double)size).func_187315_a(1.0, 1.0).func_181675_d();
            worldRenderer1.func_181662_b((double)size, -100.0, (double)(-size)).func_187315_a(1.0, 0.0).func_181675_d();
            worldRenderer1.func_181662_b((double)(-size), -100.0, (double)(-size)).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator1.func_78381_a();
            GL11.glDisable((int)3008);
        }
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        double var25 = (double)mc.field_71439_g.func_180425_c().func_177956_o() - world.func_72919_O();
        GlStateManager.func_179091_B();
        GL11.glEnable((int)2903);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDepthMask((boolean)true);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3042);
    }

    protected void renderImage(ResourceLocation image, float x, float y, float z, float size) {
        this.renderImage(image, x, y, z, size, FMLClientHandler.instance().getClient().field_71441_e.func_72880_h(1.0f));
    }

    protected void renderImage(ResourceLocation image, float x, float y, float z, float size, float alpha) {
        this.renderImage(image, x, y, z, size, alpha, 0.0f);
    }

    protected void renderImage(ResourceLocation image, float x, float y, float z, float size, float alpha, float shadow) {
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        GL11.glRotatef((float)x, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)y, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)z, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(image);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)(-size), -100.0, (double)size).func_187315_a(0.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)size, -100.0, (double)size).func_187315_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)size, -100.0, (double)(-size)).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)(-size), -100.0, (double)(-size)).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        if (shadow > 0.0f) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)shadow);
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            worldRenderer.func_181662_b((double)(-size), -100.0, (double)size).func_181675_d();
            worldRenderer.func_181662_b((double)size, -100.0, (double)size).func_181675_d();
            worldRenderer.func_181662_b((double)size, -100.0, (double)(-size)).func_181675_d();
            worldRenderer.func_181662_b((double)(-size), -100.0, (double)(-size)).func_181675_d();
            tessellator.func_78381_a();
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
    }

    private void renderStarsOnSky(int count, IAdvancedSpace.StarColor color, float starBrightness) {
        for (int i = 0; i < count; ++i) {
            float x = color.getColor().floatX() / 255.0f;
            float y = color.getColor().floatY() / 255.0f;
            float z = color.getColor().floatZ() / 255.0f;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)starBrightness);
            if (AsmodeusConfig.enableColorStars) {
                GL11.glColor4f((float)x, (float)y, (float)z, (float)starBrightness);
            }
            GL11.glRotatef((float)-37.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(-15.0f * (float)i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glCallList((int)starList);
        }
    }

    private void renderStars() {
        Random rand = new Random(10842L);
        Tessellator tesselator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tesselator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        int star_count = ConfigManagerCore.moreStars ? 1000 : 500;
        for (int starIndex = 0; starIndex < star_count; ++starIndex) {
            double var4 = rand.nextFloat() * 2.0f - 1.0f;
            double var6 = rand.nextFloat() * 2.0f - 1.0f;
            double var8 = rand.nextFloat() * 2.0f - 1.0f;
            double var10 = 0.15f + rand.nextFloat() * 0.1f;
            double var12 = var4 * var4 + var6 * var6 + var8 * var8;
            if (!(var12 < 1.0) || !(var12 > 0.01)) continue;
            var12 = 1.0 / Math.sqrt(var12);
            double var14 = (var4 *= var12) * (ConfigManagerCore.moreStars ? rand.nextDouble() * 150.0 + 130.0 : 100.0);
            double var16 = (var6 *= var12) * (ConfigManagerCore.moreStars ? rand.nextDouble() * 150.0 + 130.0 : 100.0);
            double var18 = (var8 *= var12) * (ConfigManagerCore.moreStars ? rand.nextDouble() * 150.0 + 130.0 : 100.0);
            double var20 = Math.atan2(var4, var8);
            double var22 = Math.sin(var20);
            double var24 = Math.cos(var20);
            double var26 = Math.atan2(Math.sqrt(var4 * var4 + var8 * var8), var6);
            double var28 = Math.sin(var26);
            double var30 = Math.cos(var26);
            double var32 = rand.nextDouble() * Math.PI * 2.0;
            double var34 = Math.sin(var32);
            double var36 = Math.cos(var32);
            for (int var38 = 0; var38 < 4; ++var38) {
                double var39 = 0.0;
                double var41 = (double)((var38 & 2) - 1) * var10;
                double var43 = (double)((var38 + 1 & 2) - 1) * var10;
                double var47 = var41 * var36 - var43 * var34;
                double var49 = var43 * var36 + var41 * var34;
                double var53 = var47 * var28 + 0.0 * var30;
                double var55 = 0.0 * var28 - var47 * var30;
                double var57 = var55 * var22 - var49 * var24;
                double var61 = var49 * var22 + var55 * var24;
                worldRenderer.func_181662_b(var14 + var57, var16 + var53, var18 + var61).func_181675_d();
            }
        }
        tesselator.func_78381_a();
    }

    protected void renderAtmo(Tessellator tessellator1, float x, float y, float f10, Vector3 vec) {
        if (vec != null && AsmodeusConfig.enableRenderAtmosphere) {
            float f15;
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3553);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glRotatef((float)y, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)x, (float)1.0f, (float)0.0f, (float)0.0f);
            double planetOrbitalDistance = 5.0;
            double dist = -64.0 - 4.0 * planetOrbitalDistance / 2.0 - (double)((float)this.mc.field_71439_g.field_70163_u / (float)this.mc.field_71439_g.field_70163_u);
            double scalingMult = 1.0 - 0.9 * planetOrbitalDistance;
            float Xoffset = (float)((double)System.currentTimeMillis() / 1000000.0 % 1.0);
            float f14 = 1.0f + Xoffset;
            float f16 = f15 = 0.0f + Xoffset;
            float f17 = f14;
            float[] color = new float[]{vec.floatX(), vec.floatY(), vec.floatZ(), 0.09f};
            BufferBuilder worldRenderer = tessellator1.func_178180_c();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            for (int i = 0; i < 5; ++i) {
                SkyProviderBase.renderTestWithUV(worldRenderer, color, dist + (double)i * scalingMult, -f10, -f10, 0.0, 0.0, f14, f15, f16, f17);
                SkyProviderBase.renderTestWithUV(worldRenderer, color, dist + (double)i * scalingMult, 0.0, 0.0, f10, f10, f14, f15, f16, f17);
                SkyProviderBase.renderTestWithUV(worldRenderer, color, dist + (double)i * scalingMult, -f10, 0.0, 0.0, f10, f14, f15, f16, f17);
                SkyProviderBase.renderTestWithUV(worldRenderer, color, dist + (double)i * scalingMult, 0.0, -f10, f10, 0.0, f14, f15, f16, f17);
            }
            tessellator1.func_78381_a();
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3553);
        }
    }

    private static void renderTestWithUV(BufferBuilder buff, float[] color, double yMax, double xMin, double zMin, double xMax, double zMax, double uMin, double uMax, double vMin, double vMax) {
        buff.func_181662_b(xMin, yMax, zMin).func_187315_a(uMin, vMin).func_181666_a(color[0], color[1], color[2], color[3]).func_181675_d();
        buff.func_181662_b(xMin, yMax, zMax).func_187315_a(uMin, vMax).func_181666_a(color[0], color[1], color[2], color[3]).func_181675_d();
        buff.func_181662_b(xMax, yMax, zMax).func_187315_a(uMax, vMax).func_181666_a(color[0], color[1], color[2], color[3]).func_181675_d();
        buff.func_181662_b(xMax, yMax, zMin).func_187315_a(uMax, vMin).func_181666_a(color[0], color[1], color[2], color[3]).func_181675_d();
    }

    protected void renderSunAura(Tessellator tessellator1, float f10, float f18) {
        float f6;
        BufferBuilder worldRenderer = tessellator1.func_178180_c();
        Vec3d vec3 = this.mc.field_71441_e.func_72833_a(this.mc.func_175606_aa(), this.ticks);
        float f1 = (float)vec3.field_72450_a;
        float f2 = (float)vec3.field_72448_b;
        float f3 = (float)vec3.field_72449_c;
        float f9 = 0.0f;
        if (this.mc.field_71474_y.field_74337_g) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f6;
        }
        this.afloat[0] = 1.0f;
        this.afloat[1] = 0.7607843f;
        this.afloat[2] = 0.7058824f;
        this.afloat[3] = 0.5f;
        if (this.colorSunAura() != null) {
            this.afloat[0] = this.colorSunAura().getColor().floatX() / 255.0f;
            this.afloat[1] = this.colorSunAura().getColor().floatY() / 255.0f;
            this.afloat[2] = this.colorSunAura().getColor().floatZ() / 255.0f;
        }
        f6 = this.afloat[0];
        float f7 = this.afloat[1];
        float f8 = this.afloat[2];
        if (this.mc.field_71474_y.field_74337_g) {
            f9 = (f6 * 30.0f + f7 * 59.0f + f8 * 11.0f) / 100.0f;
            f10 = (f6 * 30.0f + f7 * 70.0f) / 100.0f;
            float f11 = (f6 * 30.0f + f8 * 70.0f) / 100.0f;
            f6 = f9;
            f7 = f10;
            f8 = f11;
        }
        float r = f6 * f18;
        float g = f7 * f18;
        float b = f8 * f18;
        float a = this.afloat[3] * 2.0f / f18 - Minecraft.func_71410_x().field_71441_e.func_72867_j(this.ticks);
        if (this.modeLight() != ModeLight.WITHOUT_SUN) {
            worldRenderer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            worldRenderer.func_181662_b(0.0, 100.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            int b0 = 16;
            r = this.afloat[0] * f18;
            g = this.afloat[1] * f18;
            b = this.afloat[2] * f18;
            a = 0.0f;
            worldRenderer.func_181662_b((double)(-f10), 100.0, (double)(-f10)).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(0.0, 100.0, (double)(-f10) * 1.5).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)f10, 100.0, (double)(-f10)).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)f10 * 1.5, 100.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)f10, 100.0, (double)f10).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(0.0, 100.0, (double)f10 * 1.5).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)(-f10), 100.0, (double)f10).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)(-f10) * 1.5, 100.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)(-f10), 100.0, (double)(-f10)).func_181666_a(r, g, b, a).func_181675_d();
            tessellator1.func_78381_a();
        }
        if (this.enableSmoothRender()) {
            GL11.glLineWidth((float)2.0f);
            GL11.glPolygonMode((int)1032, (int)6913);
        }
        if (this.enableLargeSunAura()) {
            worldRenderer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            r = f6 * f18;
            g = f7 * f18;
            b = f8 * f18;
            a = this.enableSmoothRender() ? this.afloat[3] * 2.0f / f18 - Minecraft.func_71410_x().field_71441_e.func_72867_j(this.ticks) : this.afloat[3] * f18;
            worldRenderer.func_181662_b(0.0, 100.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            r = this.afloat[0] * f18;
            g = this.afloat[1] * f18;
            b = this.afloat[2] * f18;
            a = 0.0f;
            f10 += 10.0f;
            int i = this.enableSmoothRender() ? 8 : 0;
            worldRenderer.func_181662_b((double)(-(f10 += (float)i)), 100.0, (double)(-f10)).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(0.0, 100.0, (double)(-f10) * 1.5).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)(f10 -= (float)(i + i)), 100.0, (double)(-f10)).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)f10 * 1.5, 100.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)(f10 += (float)i), 100.0, (double)f10).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(0.0, 100.0, (double)f10 * 1.5).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)(-(f10 -= (float)i)), 100.0, (double)f10).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)(-f10) * 1.5, 100.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)(-f10), 100.0, (double)(-f10)).func_181666_a(r, g, b, a).func_181675_d();
            tessellator1.func_78381_a();
        }
        GL11.glPolygonMode((int)1032, (int)6914);
    }

    protected boolean inWater(EntityPlayer player) {
        BlockPos pos = player.func_180425_c();
        return this.mc.field_71441_e.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151586_h;
    }

    protected float getCelestialAngle(long daylength) {
        return Utils.calculateCelestialAngle(this.mc.field_71441_e.func_72820_D(), this.ticks, (int)daylength) * 360.0f;
    }

    @Deprecated
    protected long getDayLenght() {
        return this.getDayLength();
    }

    protected long getDayLength() {
        long daylength = 24000L;
        if (this.mc.field_71441_e.field_73011_w instanceof WorldProviderSpace) {
            daylength = ((WorldProviderSpace)this.mc.field_71441_e.field_73011_w).getDayLength();
        } else if (this.mc.field_71441_e.field_73011_w instanceof WE_WorldProviderSpace) {
            daylength = ((WE_WorldProviderSpace)this.mc.field_71441_e.field_73011_w).getDayLength();
        }
        return daylength;
    }

    protected abstract void rendererSky(Tessellator var1, BufferBuilder var2, float var3, float var4);

    protected abstract boolean enableBaseImages();

    protected abstract ModeLight modeLight();

    protected abstract float sunSize();

    protected abstract boolean enableStar();

    protected abstract ResourceLocation sunImage();

    protected abstract IAdvancedSpace.StarColor colorSunAura();

    protected abstract Vector3 getAtmosphereColor();

    public boolean enableLargeSunAura() {
        return true;
    }

    public boolean enableSmoothRender() {
        return false;
    }

    public boolean enableRenderPlanet() {
        return true;
    }

    public int expandSizeAura() {
        return 0;
    }

    public static enum ModeLight {
        DEFAULT,
        ALWAYS_LIGHT,
        WITHOUT_SUN;

    }
}

