/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.network.packet;

import asmodeuscore.api.network.IMessage;
import asmodeuscore.core.network.packet.ACPacketSimple;
import asmodeuscore.core.network.packet.AsmodeusPacketHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.EnumMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLIndexedMessageToMessageCodec;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class AsmodeusChannelHandler
extends FMLIndexedMessageToMessageCodec<IMessage> {
    private EnumMap<Side, FMLEmbeddedChannel> channels;

    private AsmodeusChannelHandler() {
        this.addDiscriminator(0, ACPacketSimple.class);
    }

    public static AsmodeusChannelHandler init() {
        AsmodeusChannelHandler channelHandler = new AsmodeusChannelHandler();
        channelHandler.channels = NetworkRegistry.INSTANCE.newChannel("asmodeuscore", new ChannelHandler[]{channelHandler, new AsmodeusPacketHandler()});
        return channelHandler;
    }

    public void encodeInto(ChannelHandlerContext ctx, IMessage msg, ByteBuf target) throws Exception {
        msg.encodeInto(target);
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, IMessage msg) {
        msg.decodeInto(source);
    }

    public void sendToAll(IMessage message) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        try {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
            this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
        }
        catch (Exception e) {
            System.out.println("Forge error when sending network packet to nearby players - this is not a Galacticraft bug, does another mod make fake players?");
            e.printStackTrace();
        }
    }

    public void sendToDimension(IMessage message, int dimensionId) {
        try {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
            this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
        }
        catch (Exception e) {
            System.out.println("Forge error when sending network packet to all players in dimension - this is not a Galacticraft bug, does another mod make fake players?");
            e.printStackTrace();
        }
    }

    public void sendToServer(IMessage message) {
        if (FMLCommonHandler.instance().getSide() != Side.CLIENT) {
            return;
        }
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeOutbound(new Object[]{message});
    }
}

