/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.inputs.DoubleMachineInput;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.BasicMachineRecipe;
import mekanism.common.recipe.machines.CombinerRecipe;
import mekanism.common.recipe.machines.InjectionRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import net.minecraft.item.ItemStack;
import wanion.lib.common.MetaItem;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.resource.UniResourceContainer;

final class MekanismIntegration
extends AbstractIntegrationThread {
    MekanismIntegration() {
        super("Mekanism");
    }

    public String call() {
        try {
            this.FixBasicRecipes(RecipeHandler.Recipe.CRUSHER.get());
            this.FixBasicRecipes(RecipeHandler.Recipe.ENRICHMENT_CHAMBER.get());
            this.FixBasicRecipes(RecipeHandler.Recipe.ENERGIZED_SMELTER.get());
            this.FixCombinerRecipes(RecipeHandler.Recipe.COMBINER.get());
            this.FixChemicalInjectionRecipes(RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.get());
            this.FixInfusionRecipes(RecipeHandler.Recipe.METALLURGIC_INFUSER.get());
        }
        catch (Exception e) {
            this.logger.error(this.threadName + e);
        }
        return this.threadName + "All the mekanisms were checked.";
    }

    private <T extends BasicMachineRecipe<T>> void FixBasicRecipes(@Nonnull Map<ItemStackInput, T> recipes) {
        HashMap<MachineInput, BasicMachineRecipe> correctRecipes = new HashMap<MachineInput, BasicMachineRecipe>(recipes.size(), 1.0f);
        if (!this.config.inputReplacementMekanism) {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerInputKeyMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Iterator<T> mekanismRecipeIterator = recipes.values().iterator();
            while (mekanismRecipeIterator.hasNext()) {
                TIntSet inputKeySet;
                BasicMachineRecipe mekanismRecipe = (BasicMachineRecipe)mekanismRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer(((ItemStackInput)mekanismRecipe.recipeInput).ingredient);
                UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)mekanismRecipe.recipeOutput).output);
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    ((ItemStackOutput)mekanismRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    continue;
                }
                BasicMachineRecipe correctRecipe = (BasicMachineRecipe)mekanismRecipe.copy();
                ItemStack inputStack = this.config.keepOneEntry ? (((ItemStackInput)correctRecipe.recipeInput).ingredient = inputContainer.getMainEntry(((ItemStackInput)correctRecipe.recipeInput).ingredient.func_190916_E())) : (((ItemStackInput)correctRecipe.recipeInput).ingredient = ((ItemStackInput)correctRecipe.recipeInput).ingredient.func_77946_l());
                int inputId = MetaItem.get((ItemStack)inputStack);
                if (!containerInputKeyMap.containsKey(outputContainer)) {
                    containerInputKeyMap.put(outputContainer, new TIntHashSet());
                }
                if (!(inputKeySet = (TIntSet)containerInputKeyMap.get(outputContainer)).contains(inputId)) {
                    inputKeySet.add(inputId);
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)correctRecipe.recipeOutput).output.func_190916_E());
                    correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
                }
                mekanismRecipeIterator.remove();
            }
        } else {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerKindMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Iterator<T> mekanismRecipeIterator = recipes.values().iterator();
            while (mekanismRecipeIterator.hasNext()) {
                TIntSet kindSet;
                BasicMachineRecipe mekanismRecipe = (BasicMachineRecipe)mekanismRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer(((ItemStackInput)mekanismRecipe.recipeInput).ingredient);
                UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)mekanismRecipe.recipeOutput).output);
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    ((ItemStackOutput)mekanismRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    continue;
                }
                int kind = inputContainer.kind;
                if (!containerKindMap.containsKey(outputContainer)) {
                    containerKindMap.put(outputContainer, new TIntHashSet());
                }
                if (!(kindSet = (TIntSet)containerKindMap.get(outputContainer)).contains(kind)) {
                    kindSet.add(kind);
                    BasicMachineRecipe correctRecipe = (BasicMachineRecipe)mekanismRecipe.copy();
                    ((ItemStackInput)correctRecipe.recipeInput).ingredient = inputContainer.getMainEntry(((ItemStackInput)correctRecipe.recipeInput).ingredient.func_190916_E());
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
                }
                mekanismRecipeIterator.remove();
            }
        }
        recipes.putAll(correctRecipes);
    }

    private void FixCombinerRecipes(@Nonnull Map<DoubleMachineInput, CombinerRecipe> recipes) {
        HashMap<MachineInput, CombinerRecipe> correctRecipes = new HashMap<MachineInput, CombinerRecipe>(recipes.size(), 1.0f);
        if (!this.config.inputReplacementMekanism) {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerInputKeyMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Iterator<CombinerRecipe> mekanismRecipeIterator = recipes.values().iterator();
            while (mekanismRecipeIterator.hasNext()) {
                TIntSet inputKeySet;
                CombinerRecipe mekanismRecipe = mekanismRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer(((DoubleMachineInput)mekanismRecipe.recipeInput).itemStack);
                UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)mekanismRecipe.recipeOutput).output);
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    ((ItemStackOutput)mekanismRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    continue;
                }
                CombinerRecipe correctRecipe = mekanismRecipe.copy();
                ItemStack inputStack = this.config.keepOneEntry ? (((DoubleMachineInput)correctRecipe.recipeInput).itemStack = inputContainer.getMainEntry(((DoubleMachineInput)correctRecipe.recipeInput).itemStack.func_190916_E())) : (((DoubleMachineInput)correctRecipe.recipeInput).itemStack = ((DoubleMachineInput)correctRecipe.recipeInput).itemStack.func_77946_l());
                int inputId = MetaItem.get((ItemStack)inputStack);
                if (!containerInputKeyMap.containsKey(outputContainer)) {
                    containerInputKeyMap.put(outputContainer, new TIntHashSet());
                }
                if (!(inputKeySet = (TIntSet)containerInputKeyMap.get(outputContainer)).contains(inputId)) {
                    inputKeySet.add(inputId);
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)correctRecipe.recipeOutput).output.func_190916_E());
                    correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
                }
                mekanismRecipeIterator.remove();
            }
        } else {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerKindMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Iterator<CombinerRecipe> mekanismRecipeIterator = recipes.values().iterator();
            while (mekanismRecipeIterator.hasNext()) {
                TIntSet kindSet;
                CombinerRecipe mekanismRecipe = mekanismRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer(((DoubleMachineInput)mekanismRecipe.recipeInput).itemStack);
                UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)mekanismRecipe.recipeOutput).output);
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    ((ItemStackOutput)mekanismRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    continue;
                }
                int kind = inputContainer.kind;
                if (!containerKindMap.containsKey(outputContainer)) {
                    containerKindMap.put(outputContainer, new TIntHashSet());
                }
                if (!(kindSet = (TIntSet)containerKindMap.get(outputContainer)).contains(kind)) {
                    kindSet.add(kind);
                    CombinerRecipe correctRecipe = mekanismRecipe.copy();
                    ((DoubleMachineInput)correctRecipe.recipeInput).itemStack = inputContainer.getMainEntry(((DoubleMachineInput)correctRecipe.recipeInput).itemStack.func_190916_E());
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
                }
                mekanismRecipeIterator.remove();
            }
        }
        recipes.putAll(correctRecipes);
    }

    private void FixChemicalInjectionRecipes(@Nonnull Map<AdvancedMachineInput, InjectionRecipe> recipes) {
        HashMap<MachineInput, InjectionRecipe> correctRecipes = new HashMap<MachineInput, InjectionRecipe>(recipes.size(), 1.0f);
        if (!this.config.inputReplacementMekanism) {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerInputKeyMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Iterator<InjectionRecipe> mekanismRecipeIterator = recipes.values().iterator();
            while (mekanismRecipeIterator.hasNext()) {
                TIntSet inputKeySet;
                InjectionRecipe mekanismRecipe = mekanismRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer(((AdvancedMachineInput)mekanismRecipe.recipeInput).itemStack);
                UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)mekanismRecipe.recipeOutput).output);
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    ((ItemStackOutput)mekanismRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    continue;
                }
                InjectionRecipe correctRecipe = mekanismRecipe.copy();
                ItemStack inputStack = this.config.keepOneEntry ? (((AdvancedMachineInput)correctRecipe.recipeInput).itemStack = inputContainer.getMainEntry(((AdvancedMachineInput)correctRecipe.recipeInput).itemStack.func_190916_E())) : (((AdvancedMachineInput)correctRecipe.recipeInput).itemStack = ((AdvancedMachineInput)correctRecipe.recipeInput).itemStack.func_77946_l());
                int inputId = MetaItem.get((ItemStack)inputStack);
                if (!containerInputKeyMap.containsKey(outputContainer)) {
                    containerInputKeyMap.put(outputContainer, new TIntHashSet());
                }
                if (!(inputKeySet = (TIntSet)containerInputKeyMap.get(outputContainer)).contains(inputId)) {
                    inputKeySet.add(inputId);
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)correctRecipe.recipeOutput).output.func_190916_E());
                    correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
                }
                mekanismRecipeIterator.remove();
            }
        } else {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerKindMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Iterator<InjectionRecipe> mekanismRecipeIterator = recipes.values().iterator();
            while (mekanismRecipeIterator.hasNext()) {
                TIntSet kindSet;
                InjectionRecipe mekanismRecipe = mekanismRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer(((AdvancedMachineInput)mekanismRecipe.recipeInput).itemStack);
                UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)mekanismRecipe.recipeOutput).output);
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    ((ItemStackOutput)mekanismRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    continue;
                }
                int kind = inputContainer.kind;
                if (!containerKindMap.containsKey(outputContainer)) {
                    containerKindMap.put(outputContainer, new TIntHashSet());
                }
                if (!(kindSet = (TIntSet)containerKindMap.get(outputContainer)).contains(kind)) {
                    kindSet.add(kind);
                    InjectionRecipe correctRecipe = mekanismRecipe.copy();
                    ((AdvancedMachineInput)correctRecipe.recipeInput).itemStack = inputContainer.getMainEntry(((AdvancedMachineInput)correctRecipe.recipeInput).itemStack.func_190916_E());
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
                }
                mekanismRecipeIterator.remove();
            }
        }
        recipes.putAll(correctRecipes);
    }

    private void FixInfusionRecipes(@Nonnull Map<InfusionInput, MetallurgicInfuserRecipe> recipes) {
        HashMap<MachineInput, MetallurgicInfuserRecipe> correctRecipes = new HashMap<MachineInput, MetallurgicInfuserRecipe>(recipes.size(), 1.0f);
        if (!this.config.inputReplacementMekanism) {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerInputKeyMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Iterator<MetallurgicInfuserRecipe> infusionRecipeIterator = recipes.values().iterator();
            while (infusionRecipeIterator.hasNext()) {
                TIntSet inputKeySet;
                MachineRecipe infusionRecipe = (MachineRecipe)infusionRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer(((InfusionInput)infusionRecipe.recipeInput).inputStack);
                UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)infusionRecipe.recipeOutput).output);
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    ((ItemStackOutput)infusionRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)infusionRecipe.recipeOutput).output.func_190916_E());
                    continue;
                }
                MetallurgicInfuserRecipe correctRecipe = (MetallurgicInfuserRecipe)infusionRecipe.copy();
                ItemStack inputStack = this.config.keepOneEntry ? (((InfusionInput)correctRecipe.recipeInput).inputStack = inputContainer.getMainEntry(((InfusionInput)correctRecipe.recipeInput).inputStack.func_190916_E())) : (((InfusionInput)correctRecipe.recipeInput).inputStack = ((InfusionInput)correctRecipe.recipeInput).inputStack.func_77946_l());
                int inputId = MetaItem.get((ItemStack)inputStack);
                if (!containerInputKeyMap.containsKey(outputContainer)) {
                    containerInputKeyMap.put(outputContainer, new TIntHashSet());
                }
                if (!(inputKeySet = (TIntSet)containerInputKeyMap.get(outputContainer)).contains(inputId)) {
                    inputKeySet.add(inputId);
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)correctRecipe.recipeOutput).output.func_190916_E());
                    correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
                }
                infusionRecipeIterator.remove();
            }
        } else {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerKindMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Iterator<MetallurgicInfuserRecipe> infusionRecipeIterator = recipes.values().iterator();
            while (infusionRecipeIterator.hasNext()) {
                TIntSet kindSet;
                MachineRecipe mekanismRecipe = (MachineRecipe)infusionRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer(((InfusionInput)mekanismRecipe.recipeInput).inputStack);
                UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)mekanismRecipe.recipeOutput).output);
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    ((ItemStackOutput)mekanismRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    continue;
                }
                int kind = inputContainer.kind;
                if (!containerKindMap.containsKey(outputContainer)) {
                    containerKindMap.put(outputContainer, new TIntHashSet());
                }
                if (!(kindSet = (TIntSet)containerKindMap.get(outputContainer)).contains(kind)) {
                    kindSet.add(kind);
                    MetallurgicInfuserRecipe correctRecipe = (MetallurgicInfuserRecipe)mekanismRecipe.copy();
                    ((InfusionInput)correctRecipe.recipeInput).inputStack = inputContainer.getMainEntry(((InfusionInput)correctRecipe.recipeInput).inputStack.func_190916_E());
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                    correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
                }
                infusionRecipeIterator.remove();
            }
        }
        recipes.putAll(correctRecipes);
    }
}

