/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.features.tokra;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.yaml.YAMLConfigurationLoader;
import org.yaml.snakeyaml.DumperOptions;

public final class TokraVillagerWorldRegistry {
    private static final Map<String, Boolean> tokraWorlds = new HashMap<String, Boolean>();
    private static final String WORLDS_NODE = "worlds";

    public static ConfigurationNode createRootNode(Path path) throws IOException {
        YAMLConfigurationLoader loader = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setPath(path)).setFlowStyle(DumperOptions.FlowStyle.BLOCK).build();
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
            ConfigurationNode node = loader.createEmptyNode(ConfigurationOptions.defaults());
            node.getNode(WORLDS_NODE, "world").setValue(true);
            node.getNode(WORLDS_NODE, "world_2").setValue(false);
            loader.save(node);
        }
        return loader.load(ConfigurationOptions.defaults());
    }

    public static void populateTokraVillagerWorlds(ConfigurationNode root) {
        Preconditions.checkNotNull((Object)root);
        tokraWorlds.clear();
        ConfigurationNode worldsRoot = root.getNode(WORLDS_NODE);
        for (Map.Entry<Object, ? extends ConfigurationNode> worldEntry : worldsRoot.getChildrenMap().entrySet()) {
            String world = worldEntry.getKey().toString().toLowerCase();
            boolean value = worldEntry.getValue().getBoolean();
            tokraWorlds.put(world, value);
        }
    }

    public static Optional<Boolean> populateTokraVillagers(String world) {
        Preconditions.checkNotNull((Object)world.toLowerCase());
        return Optional.ofNullable(tokraWorlds.get(world.toLowerCase()));
    }
}

