/*
 * Decompiled with CFR 0.152.
 */
package org.dave.ocsensors.integration.forge;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.dave.ocsensors.integration.AbstractCapabilityIntegration;
import org.dave.ocsensors.integration.Integrate;
import org.dave.ocsensors.integration.PrefixRegistry;
import org.dave.ocsensors.integration.ScanDataList;

@Integrate(name="energy")
public class ForgeEnergyIntegration
extends AbstractCapabilityIntegration {
    @Override
    protected Capability getCompatibleCapability() {
        return CapabilityEnergy.ENERGY;
    }

    @Override
    public void init() {
        PrefixRegistry.addSupportedPrefix(ForgeEnergyIntegration.class, "energy");
    }

    @Override
    public void addScanData(ScanDataList data, TileEntity entity, @Nullable EnumFacing side) {
        IEnergyStorage storage = (IEnergyStorage)entity.getCapability(CapabilityEnergy.ENERGY, side);
        HashMap<String, Comparable<Boolean>> result = new HashMap<String, Comparable<Boolean>>();
        result.put("canReceive", Boolean.valueOf(storage.canReceive()));
        result.put("canExtract", Boolean.valueOf(storage.canExtract()));
        result.put("energyStored", Integer.valueOf(storage.getEnergyStored()));
        result.put("maxEnergyStored", Integer.valueOf(storage.getMaxEnergyStored()));
        data.add("energy", result);
    }
}

