/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core;

import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.mj.MjAPI;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.MaterialOleaginous;
import micdoodle8.mods.galacticraft.core.entities.EntityMeteorChunk;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import micdoodle8.mods.galacticraft.core.items.ItemBucketGC;
import micdoodle8.mods.galacticraft.core.items.ItemTier1Rocket;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.asteroids.items.ItemTier3Rocket;
import micdoodle8.mods.galacticraft.planets.mars.items.ItemTier2Rocket;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.galacticraft.planets.venus.VenusItems;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.IProjectile;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class GCFluids {
    public static Fluid fluidOil;
    public static Fluid fluidFuel;
    public static Fluid fluidOxygenGas;
    public static Fluid fluidHydrogenGas;
    public static Material materialOil;

    public static void registerFluids() {
        fluidOxygenGas = GCFluids.registerFluid("oxygen", 1, 13, 295, true, "oxygen_gas");
        fluidHydrogenGas = GCFluids.registerFluid("hydrogen", 1, 1, 295, true, "hydrogen_gas");
    }

    public static void registerOilandFuel() {
        String fuelID;
        String oilID = ConfigManagerCore.useOldOilFluidID ? "oilgc" : "oil";
        String string = fuelID = ConfigManagerCore.useOldFuelFluidID ? "fuelgc" : "fuel";
        if (!FluidRegistry.isFluidRegistered((String)oilID)) {
            ResourceLocation flowingOil = new ResourceLocation("galacticraftcore:blocks/fluids/oil_flow");
            ResourceLocation stillOil = new ResourceLocation("galacticraftcore:blocks/fluids/oil_still");
            Fluid gcFluidOil = new Fluid(oilID, stillOil, flowingOil).setDensity(800).setViscosity(1500);
            FluidRegistry.registerFluid((Fluid)gcFluidOil);
        } else {
            GCLog.info("Galacticraft oil is not default, issues may occur.");
        }
        fluidOil = FluidRegistry.getFluid((String)oilID);
        if (fluidOil.getBlock() == null) {
            GCBlocks.registerOil();
            fluidOil.setBlock(GCBlocks.crudeOil);
        } else {
            GCBlocks.crudeOil = fluidOil.getBlock();
        }
        if (GCBlocks.crudeOil != null && !FluidRegistry.getBucketFluids().contains(fluidOil)) {
            FluidRegistry.addBucketForFluid((Fluid)fluidOil);
            GCItems.bucketOil = new ItemBucketGC(GCBlocks.crudeOil, fluidOil);
            GCItems.bucketOil.func_77655_b("bucket_oil");
            GCItems.registerItem(GCItems.bucketOil);
            EventHandlerGC.bucketList.put(GCBlocks.crudeOil, GCItems.bucketOil);
        }
        if (!FluidRegistry.isFluidRegistered((String)fuelID)) {
            ResourceLocation flowingFuel = new ResourceLocation("galacticraftcore:blocks/fluids/fuel_flow");
            ResourceLocation stillFuel = new ResourceLocation("galacticraftcore:blocks/fluids/fuel_still");
            Fluid gcFluidFuel = new Fluid(fuelID, stillFuel, flowingFuel).setDensity(400).setViscosity(900);
            FluidRegistry.registerFluid((Fluid)gcFluidFuel);
        } else {
            GCLog.info("Galacticraft fuel is not default, issues may occur.");
        }
        fluidFuel = FluidRegistry.getFluid((String)fuelID);
        if (fluidFuel.getBlock() == null) {
            GCBlocks.registerFuel();
            fluidFuel.setBlock(GCBlocks.fuel);
        } else {
            GCBlocks.fuel = fluidFuel.getBlock();
        }
        if (GCBlocks.fuel != null && !FluidRegistry.getBucketFluids().contains(fluidFuel)) {
            FluidRegistry.addBucketForFluid((Fluid)fluidFuel);
            GCItems.bucketFuel = new ItemBucketGC(GCBlocks.fuel, fluidFuel);
            GCItems.bucketFuel.func_77655_b("bucket_fuel");
            GCItems.registerItem(GCItems.bucketFuel);
            EventHandlerGC.bucketList.put(GCBlocks.fuel, GCItems.bucketFuel);
        }
    }

    private static Fluid registerFluid(String fluidName, int density, int viscosity, int temperature, boolean gaseous, String fluidTexture) {
        Fluid returnFluid = FluidRegistry.getFluid((String)fluidName);
        if (returnFluid == null) {
            ResourceLocation texture = new ResourceLocation("galacticraftcore:blocks/fluids/" + fluidTexture);
            FluidRegistry.registerFluid((Fluid)new Fluid(fluidName, texture, texture).setDensity(density).setViscosity(viscosity).setTemperature(temperature).setGaseous(gaseous));
            returnFluid = FluidRegistry.getFluid((String)fluidName);
        } else {
            returnFluid.setGaseous(gaseous);
        }
        return returnFluid;
    }

    public static void registerLegacyFluids() {
        ResourceLocation flowingOil = new ResourceLocation("galacticraftcore:blocks/fluids/oil_flow");
        ResourceLocation flowingFuel = new ResourceLocation("galacticraftcore:blocks/fluids/fuel_flow");
        ResourceLocation stillOil = new ResourceLocation("galacticraftcore:blocks/fluids/oil_still");
        ResourceLocation stillFuel = new ResourceLocation("galacticraftcore:blocks/fluids/fuel_still");
        if (!FluidRegistry.isFluidRegistered((String)"oil")) {
            FluidRegistry.registerFluid((Fluid)new Fluid("oil", stillOil, flowingOil).setDensity(800).setViscosity(1500));
        }
        if (!FluidRegistry.isFluidRegistered((String)"oilgc")) {
            FluidRegistry.registerFluid((Fluid)new Fluid("oilgc", stillOil, flowingOil).setDensity(800).setViscosity(1500));
        }
        if (!FluidRegistry.isFluidRegistered((String)"fuel")) {
            FluidRegistry.registerFluid((Fluid)new Fluid("fuel", stillFuel, flowingFuel).setDensity(400).setViscosity(900));
        }
        if (!FluidRegistry.isFluidRegistered((String)"fuelgc")) {
            FluidRegistry.registerFluid((Fluid)new Fluid("fuelgc", stillFuel, flowingFuel).setDensity(400).setViscosity(900));
        }
    }

    public static void registerDispenserBehaviours() {
        BehaviorDefaultDispenseItem ibehaviordispenseitem = new BehaviorDefaultDispenseItem(){
            private final BehaviorDefaultDispenseItem dispenseBehavior = new BehaviorDefaultDispenseItem();

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                ItemBucketGC itembucket = (ItemBucketGC)stack.func_77973_b();
                BlockPos blockpos = source.func_180699_d().func_177972_a((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
                if (itembucket.func_180616_a(null, source.func_82618_k(), blockpos)) {
                    return new ItemStack(Items.field_151133_ar);
                }
                return this.dispenseBehavior.func_82482_a(source, stack);
            }
        };
        if (GCItems.bucketFuel != null) {
            BlockDispenser.field_149943_a.func_82595_a((Object)GCItems.bucketFuel, (Object)ibehaviordispenseitem);
        }
        if (GCItems.bucketOil != null) {
            BlockDispenser.field_149943_a.func_82595_a((Object)GCItems.bucketOil, (Object)ibehaviordispenseitem);
        }
        if (GalacticraftCore.isPlanetsLoaded) {
            if (MarsItems.bucketSludge != null) {
                BlockDispenser.field_149943_a.func_82595_a((Object)MarsItems.bucketSludge, (Object)ibehaviordispenseitem);
            }
            if (VenusItems.bucketSulphuricAcid != null) {
                BlockDispenser.field_149943_a.func_82595_a((Object)VenusItems.bucketSulphuricAcid, (Object)ibehaviordispenseitem);
            }
        }
        BlockDispenser.field_149943_a.func_82595_a((Object)GCItems.meteorChunk, (Object)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stack) {
                EntityMeteorChunk meteor = new EntityMeteorChunk(worldIn);
                meteor.func_70107_b(position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                if (stack.func_77952_i() > 0) {
                    meteor.func_70015_d(20);
                    meteor.isHot = true;
                }
                meteor.canBePickedUp = 1;
                return meteor;
            }

            protected float func_82500_b() {
                return 1.0f;
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)GCItems.rocketTier1, (Object)new BehaviorDefaultDispenseItem(){

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                World world = source.func_82618_k();
                BlockPos pos = source.func_180699_d().func_177967_a((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a), 2);
                IBlockState iblockstate = world.func_180495_p(pos);
                boolean rocketPlaced = false;
                if (iblockstate.func_177230_c() == GCBlocks.landingPadFull && GCBlocks.landingPadFull.func_176201_c(iblockstate) == 0) {
                    float centerX = (float)pos.func_177958_n() + 0.5f;
                    float centerY = (float)pos.func_177956_o() + 0.4f;
                    float centerZ = (float)pos.func_177952_p() + 0.5f;
                    rocketPlaced = ItemTier1Rocket.placeRocketOnPad(stack, world, world.func_175625_s(pos), centerX, centerY, centerZ);
                }
                if (rocketPlaced) {
                    stack.func_77979_a(1);
                }
                return stack;
            }
        });
        if (GalacticraftCore.isPlanetsLoaded) {
            BlockDispenser.field_149943_a.func_82595_a((Object)MarsItems.rocketMars, (Object)new BehaviorDefaultDispenseItem(){

                public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                    World world = source.func_82618_k();
                    BlockPos pos = source.func_180699_d().func_177967_a((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a), 2);
                    IBlockState iblockstate = world.func_180495_p(pos);
                    boolean rocketPlaced = false;
                    if (iblockstate.func_177230_c() == GCBlocks.landingPadFull && GCBlocks.landingPadFull.func_176201_c(iblockstate) == 0) {
                        float centerX = (float)pos.func_177958_n() + 0.5f;
                        float centerY = (float)pos.func_177956_o() + 0.4f;
                        float centerZ = (float)pos.func_177952_p() + 0.5f;
                        rocketPlaced = ItemTier2Rocket.placeRocketOnPad((ItemStack)stack, (World)world, (TileEntity)world.func_175625_s(pos), (float)centerX, (float)centerY, (float)centerZ);
                    }
                    if (rocketPlaced) {
                        stack.func_77979_a(1);
                    }
                    return stack;
                }
            });
            BlockDispenser.field_149943_a.func_82595_a((Object)AsteroidsItems.tier3Rocket, (Object)new BehaviorDefaultDispenseItem(){

                public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                    World world = source.func_82618_k();
                    BlockPos pos = source.func_180699_d().func_177967_a((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a), 2);
                    IBlockState iblockstate = world.func_180495_p(pos);
                    boolean rocketPlaced = false;
                    if (iblockstate.func_177230_c() == GCBlocks.landingPadFull && GCBlocks.landingPadFull.func_176201_c(iblockstate) == 0) {
                        float centerX = (float)pos.func_177958_n() + 0.5f;
                        float centerY = (float)pos.func_177956_o() + 0.4f;
                        float centerZ = (float)pos.func_177952_p() + 0.5f;
                        rocketPlaced = ItemTier3Rocket.placeRocketOnPad((ItemStack)stack, (World)world, (TileEntity)world.func_175625_s(pos), (float)centerX, (float)centerY, (float)centerZ);
                    }
                    if (rocketPlaced) {
                        stack.func_77979_a(1);
                    }
                    return stack;
                }
            });
        }
    }

    public static void registerBCFuel() {
        BuildcraftFuelRegistry.fuel.addFuel(fluidFuel, 5L * MjAPI.MJ, 9000);
    }

    static {
        materialOil = new MaterialOleaginous(MapColor.field_151650_B);
    }
}

