/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace;

import asmodeuscore.AsmodeusCore;
import asmodeuscore.api.IBodies;
import asmodeuscore.api.space.IBookPage;
import asmodeuscore.core.astronomy.BodiesRegistry;
import asmodeuscore.core.utils.BookUtils;
import galaxyspace.api.IPage;
import galaxyspace.core.GSBlocks;
import galaxyspace.core.GSFluids;
import galaxyspace.core.GSItems;
import galaxyspace.core.GSPotions;
import galaxyspace.core.client.gui.book.BookRegister;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.configs.GSConfigDimensions;
import galaxyspace.core.configs.GSConfigEnergy;
import galaxyspace.core.configs.GSConfigSchematics;
import galaxyspace.core.events.GSEventHandler;
import galaxyspace.core.handler.GSGuiHandler;
import galaxyspace.core.handler.capabilities.GSCapabilityStatsHandler;
import galaxyspace.core.network.packet.GalaxySpaceChannelHandler;
import galaxyspace.core.prefab.entities.EntityAstroWolf;
import galaxyspace.core.prefab.entities.EntityCustomCargoRocket;
import galaxyspace.core.prefab.entities.EntityEvolvedColdBlaze;
import galaxyspace.core.prefab.entities.EntityIceSpike;
import galaxyspace.core.prefab.entities.EntityLaserBeam;
import galaxyspace.core.prefab.entities.EntityTier4Rocket;
import galaxyspace.core.prefab.entities.EntityTier5Rocket;
import galaxyspace.core.prefab.entities.EntityTier6Rocket;
import galaxyspace.core.proxy.CommonProxy;
import galaxyspace.core.util.GSCreativeTabs;
import galaxyspace.core.util.GSThreadVersionCheck;
import galaxyspace.core.util.researches.ResearchUtil;
import galaxyspace.systems.SolarSystem.moons.enceladus.tile.TileEntityBlockCrystallTE;
import galaxyspace.systems.SolarSystem.moons.io.entities.EntityBossGhast;
import galaxyspace.systems.SolarSystem.moons.io.tile.TileEntityDungeonSpawnerIo;
import galaxyspace.systems.SolarSystem.moons.io.tile.TileEntityTreasureChestIo;
import galaxyspace.systems.SolarSystem.planets.ceres.entities.EntityBossBlaze;
import galaxyspace.systems.SolarSystem.planets.ceres.tile.TileEntityDungeonSpawnerCeres;
import galaxyspace.systems.SolarSystem.planets.ceres.tile.TileEntityTreasureChestCeres;
import galaxyspace.systems.SolarSystem.planets.mars.entities.EntityMarsRover;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityAdvCircuitFabricator;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityAdvLandingPad;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityAdvLandingPadSingle;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityAdvOxygenStorageModule;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityAssembler;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityEnergyPad;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityFuelGenerator;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityGasBurner;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityGravitationModule;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityHydroponicBase;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityHydroponicFarm;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityLiquidExtractor;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityLiquidSeparator;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityModernSolarPanel;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityModernStorageModule;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityModificationTable;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityPanelController;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityPlanetShield;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityRadiationStabiliser;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityResearchTable;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityRocketAssembler;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityUniversalRecycler;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityWindGenerator;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityWindSolarPanel;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.core.util.CreativeTabGC;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="galaxyspace", version="2.0.15", dependencies="required-after:forge@[14.23.1.2555,); required-after:galacticraftcore@[4.0.2.261,]; required-after:galacticraftplanets; required-after:asmodeuscore@[0.0.24,)", acceptedMinecraftVersions="[1.12.2]", name="GalaxySpace", guiFactory="galaxyspace.core.client.gui.GSConfigGuiFactory")
public class GalaxySpace {
    public static final int major_version = 2;
    public static final int minor_version = 0;
    public static final int build_version = 15;
    public static final String NAME = "GalaxySpace";
    public static final String MODID = "galaxyspace";
    public static final String VERSION = "2.0.15";
    public static final String ASSET_PREFIX = "galaxyspace";
    public static final String TEXTURE_PREFIX = "galaxyspace:";
    public static boolean debug;
    public static GalaxySpaceChannelHandler packetPipeline;
    private static Logger log;
    @Mod.Instance(value="galaxyspace")
    public static GalaxySpace instance;
    @SidedProxy(clientSide="galaxyspace.core.proxy.ClientProxy", serverSide="galaxyspace.core.proxy.CommonProxy")
    public static CommonProxy proxy;
    private List<IBookPage> pages = new ArrayList<IBookPage>();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        new GSConfigDimensions(new File(event.getModConfigurationDirectory(), "GalaxySpace/dimensions.conf"));
        new GSConfigSchematics(new File(event.getModConfigurationDirectory(), "GalaxySpace/schematics.conf"));
        new GSConfigCore(new File(event.getModConfigurationDirectory(), "GalaxySpace/core.conf"));
        new GSConfigEnergy(new File(event.getModConfigurationDirectory(), "GalaxySpace/energy.conf"));
        this.initModInfo(event.getModMetadata());
        debug = GSConfigCore.enableDebug;
        log = event.getModLog();
        BodiesRegistry.setMaxTier((int)6);
        GSBlocks.initialize();
        GSFluids.initialize();
        GSItems.initialize();
        GSPotions.initialize();
        proxy.preload(event);
        proxy.register_event(new GSEventHandler());
        for (IBodies list : AsmodeusCore.bodies) {
            list.preInitialization(event);
            if (!list.canRegister()) continue;
            list.preInit(event);
        }
        ResearchUtil.initResearches();
        if (event.getSide() == Side.CLIENT) {
            for (ASMDataTable.ASMData data : event.getAsmData().getAll(IPage.class.getName())) {
                try {
                    IBookPage page = (IBookPage)Class.forName(data.getClassName()).newInstance();
                    this.pages.add(page);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
        }
        GSCapabilityStatsHandler.register();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerRender();
        proxy.load();
        packetPipeline = GalaxySpaceChannelHandler.init();
        this.registerEntities();
        for (IBodies list : AsmodeusCore.bodies) {
            if (!list.canRegister()) continue;
            list.init(event);
        }
        if (event.getSide() == Side.CLIENT) {
            BookRegister.registerCatergories();
            this.pages.forEach(BookUtils::addGuideBookPage);
        }
        GSCreativeTabs.GSBlocksTab = new CreativeTabGC(CreativeTabs.getNextID(), "galaxyspace_blocks", new ItemStack(GSBlocks.ASSEMBLER), null);
        GSCreativeTabs.GSItemsTab = new CreativeTabGC(CreativeTabs.getNextID(), "galaxyspace_items", new ItemStack(GSItems.INGOTS), null);
        GSCreativeTabs.GSArmorTab = new CreativeTabGC(CreativeTabs.getNextID(), "galaxyspace_armor", new ItemStack(GSItems.SPACE_SUIT_BODY), null);
        GSCreativeTabs.GSVehiclesTab = new CreativeTabGC(CreativeTabs.getNextID(), "galaxyspace_rocket", new ItemStack(GSItems.ROCKET_TIER_4), null);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postload();
        for (IBodies list : AsmodeusCore.bodies) {
            if (!list.canRegister()) continue;
            list.postInit(event);
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GSGuiHandler());
        GSThreadVersionCheck.startCheck();
    }

    private void registerEntities() {
        this.registerCreatures();
        this.registerNonMobEntities();
        this.registerTileEntities();
    }

    public void registerCreatures() {
        int back = -16777216;
        int fore = -8388608;
        GCCoreUtil.registerGalacticraftCreature(EntityBossBlaze.class, (String)"evolved_boss_blaze", (int)back, (int)fore);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedColdBlaze.class, (String)"evolved_coldblaze", (int)back, (int)fore);
        GCCoreUtil.registerGalacticraftCreature(EntityBossGhast.class, (String)"evolved_boss_ghast", (int)back, (int)fore);
        GCCoreUtil.registerGalacticraftCreature(EntityAstroWolf.class, (String)"astro_wolf", (int)back, (int)fore);
    }

    private void registerNonMobEntities() {
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier4Rocket.class, (String)"rocket_tier_4", (int)150, (int)1, (boolean)false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier5Rocket.class, (String)"rocket_tier_5", (int)150, (int)1, (boolean)false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier6Rocket.class, (String)"rocket_tier_6", (int)150, (int)1, (boolean)false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityCustomCargoRocket.class, (String)"rocket_fluid_cargo", (int)150, (int)1, (boolean)false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityIceSpike.class, (String)"ice_spike", (int)40, (int)100, (boolean)true);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityMarsRover.class, (String)"mars_rover", (int)150, (int)1, (boolean)false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityLaserBeam.class, (String)"laser_beam", (int)40, (int)100, (boolean)false);
    }

    private void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityAssembler.class, (String)"GS Assembler");
        GameRegistry.registerTileEntity(TileEntityFuelGenerator.class, (String)"GS Fuel Generator");
        GameRegistry.registerTileEntity(TileEntityModernSolarPanel.class, (String)"GS Modern Solar Panel");
        GameRegistry.registerTileEntity(TileEntityWindGenerator.class, (String)"GS Wind Generator");
        GameRegistry.registerTileEntity(TileEntityRocketAssembler.class, (String)"GS Rocket Assembler");
        GameRegistry.registerTileEntity(TileEntityUniversalRecycler.class, (String)"GS Universal Recycler");
        GameRegistry.registerTileEntity(TileEntityLiquidExtractor.class, (String)"GS Liquid Extractor");
        GameRegistry.registerTileEntity(TileEntityLiquidSeparator.class, (String)"GS Liquid Separator");
        GameRegistry.registerTileEntity(TileEntityHydroponicBase.class, (String)"GS Hydroponic Base");
        GameRegistry.registerTileEntity(TileEntityHydroponicFarm.class, (String)"GS Hydroponic Farm");
        GameRegistry.registerTileEntity(TileEntityGravitationModule.class, (String)"GS Gravitation Module");
        GameRegistry.registerTileEntity(TileEntityBlockCrystallTE.class, (String)"GS Crystal");
        GameRegistry.registerTileEntity(TileEntityTreasureChestCeres.class, (String)"GS Treasure Ceres");
        GameRegistry.registerTileEntity(TileEntityDungeonSpawnerCeres.class, (String)"GS Spawner Boss Ceres");
        GameRegistry.registerTileEntity(TileEntityTreasureChestIo.class, (String)"GS Treasure Io");
        GameRegistry.registerTileEntity(TileEntityDungeonSpawnerIo.class, (String)"GS Spawner Boss Io");
        GameRegistry.registerTileEntity(TileEntityRadiationStabiliser.class, (String)"GS Radiation Stabiliser");
        GameRegistry.registerTileEntity(TileEntityPanelController.class, (String)"GS Panel Controller");
        GameRegistry.registerTileEntity(TileEntityPlanetShield.class, (String)"GS Planet Shield");
        GameRegistry.registerTileEntity(TileEntityModernStorageModule.class, (String)"GS Advanced Storage Module");
        GameRegistry.registerTileEntity(TileEntityAdvLandingPad.class, (String)"GS Advanced Landing Pad Full");
        GameRegistry.registerTileEntity(TileEntityAdvLandingPadSingle.class, (String)"GS Advanced Landing Pad");
        GameRegistry.registerTileEntity(TileEntityModificationTable.class, (String)"GS Modification Table");
        GameRegistry.registerTileEntity(TileEntityGasBurner.class, (String)"GS Gas Burner");
        GameRegistry.registerTileEntity(TileEntityAdvOxygenStorageModule.class, (String)"GS Oxygen Storage Module");
        GameRegistry.registerTileEntity(TileEntityWindSolarPanel.class, (String)"GS Solar Wind Panel");
        GameRegistry.registerTileEntity(TileEntityAdvCircuitFabricator.class, (String)"GS Advanced Circuit Fabricator");
        GameRegistry.registerTileEntity(TileEntityEnergyPad.class, (String)"GS Energy Pad");
        GameRegistry.registerTileEntity(TileEntityResearchTable.class, (String)"GS Research Table");
    }

    public static void info(String message) {
        if (log != null) {
            log.log(Level.INFO, "[INFO]: " + message);
        }
    }

    public void debug(Object message) {
        if (debug && log != null) {
            log.log(Level.INFO, "[DEBUG]: " + message.toString());
        }
    }

    private void initModInfo(ModMetadata info) {
        info.autogenerated = false;
        info.modId = "galaxyspace";
        info.name = NAME;
        info.version = VERSION;
        info.description = "Global addon for Galacticraft 4.";
        info.authorList = Arrays.asList("BlesseNtumble");
    }

    static {
        FluidRegistry.enableUniversalBucket();
    }

    @Mod.EventBusSubscriber(modid="galaxyspace")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            proxy.registerVariants();
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            GSBlocks.oreDictRegistration();
            GSItems.oreDictRegistration();
            for (IBodies list : AsmodeusCore.bodies) {
                if (!list.canRegister()) continue;
                list.registerItems(event);
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            for (IBodies list : AsmodeusCore.bodies) {
                if (!list.canRegister()) continue;
                list.registerRecipes();
            }
        }
    }
}

