/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.hooks;

import asmodeuscore.api.dimension.IAdvancedSpace;
import galaxyspace.core.events.SetBlockEvent;
import galaxyspace.core.hooklib.asm.Hook;
import galaxyspace.core.hooklib.asm.ReturnCondition;
import galaxyspace.systems.SolarSystem.planets.overworld.items.ItemBasicGS;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.item.IItemThermal;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.EntityAlienVillager;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerHandler;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.DamageSourceGC;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.world.ChunkLoadingCallback;
import micdoodle8.mods.galacticraft.planets.mars.ConfigManagerMars;
import micdoodle8.mods.galacticraft.planets.mars.network.PacketSimpleMars;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityGasLiquefier;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityLaunchController;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityMethaneSynthesizer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class GSHooksManager {
    private static List<BlockPos> connectedPads = new ArrayList<BlockPos>();
    private static ForgeChunkManager.Ticket chunkLoadTicket;
    private static final EntityAlienVillager.ITradeList[] DEFAULT_TRADE_LIST_MAP;

    @Hook(returnCondition=ReturnCondition.ON_TRUE, booleanReturnConstant=false)
    public static boolean setBlockState(World world, BlockPos pos, IBlockState newState, int flags) {
        return MinecraftForge.EVENT_BUS.post((Event)new SetBlockEvent(world, pos, newState, flags));
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static int getAirProducts(TileEntityMethaneSynthesizer te) {
        WorldProvider WP = te.func_145831_w().field_73011_w;
        if (WP instanceof IGalacticraftWorldProvider) {
            ArrayList atmos = ((IGalacticraftWorldProvider)WP).getCelestialBody().atmosphere.composition;
            if (atmos.size() > 0 && atmos.get(0) == EnumAtmosphericGas.CO2) {
                return 1;
            }
            if (atmos.size() > 1 && atmos.get(1) == EnumAtmosphericGas.CO2) {
                return 1;
            }
            if (atmos.size() > 2 && atmos.get(2) == EnumAtmosphericGas.CO2) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static int getAirProducts(TileEntityGasLiquefier te) {
        WorldProvider WP = te.func_145831_w().field_73011_w;
        if (WP instanceof IGalacticraftWorldProvider) {
            int result = 0;
            ArrayList atmos = ((IGalacticraftWorldProvider)WP).getCelestialBody().atmosphere.composition;
            if (atmos.size() > 0) {
                result = te.getIdFromName(((EnumAtmosphericGas)atmos.get(0)).name().toLowerCase()) + 1;
            }
            if (atmos.size() > 1) {
                result += 16 * (te.getIdFromName(((EnumAtmosphericGas)atmos.get(1)).name().toLowerCase()) + 1);
            }
            if (atmos.size() > 2) {
                result += 256 * (te.getIdFromName(((EnumAtmosphericGas)atmos.get(2)).name().toLowerCase()) + 1);
            }
            return result;
        }
        return 35;
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static void checkThermalStatus(GCPlayerHandler handler, EntityPlayerMP player, GCPlayerStats playerStats) {
        if (player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && !player.field_71075_bZ.field_75098_d && !CompatibilityManager.isAndroid((EntityPlayer)player)) {
            float absThermalLevelMod;
            ItemStack thermalPaddingHelm = playerStats.getExtendedInventory().func_70301_a(6);
            ItemStack thermalPaddingChestplate = playerStats.getExtendedInventory().func_70301_a(7);
            ItemStack thermalPaddingLeggings = playerStats.getExtendedInventory().func_70301_a(8);
            ItemStack thermalPaddingBoots = playerStats.getExtendedInventory().func_70301_a(9);
            float lowestThermalStrength = 0.0f;
            if (!(thermalPaddingHelm.func_190926_b() || thermalPaddingChestplate.func_190926_b() || thermalPaddingLeggings.func_190926_b() || thermalPaddingBoots.func_190926_b())) {
                if (thermalPaddingHelm.func_77973_b() instanceof IItemThermal) {
                    lowestThermalStrength += (float)((IItemThermal)thermalPaddingHelm.func_77973_b()).getThermalStrength();
                }
                if (thermalPaddingChestplate.func_77973_b() instanceof IItemThermal) {
                    lowestThermalStrength += (float)((IItemThermal)thermalPaddingChestplate.func_77973_b()).getThermalStrength();
                }
                if (thermalPaddingLeggings.func_77973_b() instanceof IItemThermal) {
                    lowestThermalStrength += (float)((IItemThermal)thermalPaddingLeggings.func_77973_b()).getThermalStrength();
                }
                if (thermalPaddingBoots.func_77973_b() instanceof IItemThermal) {
                    lowestThermalStrength += (float)((IItemThermal)thermalPaddingBoots.func_77973_b()).getThermalStrength();
                }
                lowestThermalStrength /= 4.0f;
                lowestThermalStrength = Math.abs(lowestThermalStrength);
            }
            IGalacticraftWorldProvider provider = (IGalacticraftWorldProvider)player.field_70170_p.field_73011_w;
            float thermalLevelMod = provider.getThermalLevelModifier();
            if (player.field_70170_p.field_73011_w instanceof IAdvancedSpace) {
                provider = (IAdvancedSpace)player.field_70170_p.field_73011_w;
                thermalLevelMod = ((IAdvancedSpace)provider).getThermalLevelModifier((EntityPlayer)player);
            }
            if ((double)(absThermalLevelMod = Math.abs(thermalLevelMod)) > 0.0) {
                int thermalLevelTickCooldownSingle;
                int thermalLevelCooldownBase = Math.abs(MathHelper.func_76141_d((float)(200.0f / thermalLevelMod)));
                int normaliseCooldown = MathHelper.func_76141_d((float)(150.0f / lowestThermalStrength));
                int thermalLevelTickCooldown = thermalLevelCooldownBase;
                if (thermalLevelTickCooldown < 1) {
                    thermalLevelTickCooldown = 1;
                }
                if (!(thermalPaddingHelm.func_190926_b() || thermalPaddingChestplate.func_190926_b() || thermalPaddingLeggings.func_190926_b() || thermalPaddingBoots.func_190926_b())) {
                    float relativeFactor = Math.max(1.0f, absThermalLevelMod / lowestThermalStrength) / 1.5f;
                    if ((normaliseCooldown = MathHelper.func_76141_d((float)((float)normaliseCooldown / absThermalLevelMod * relativeFactor))) < 1) {
                        normaliseCooldown = 1;
                    }
                    if ((player.field_70173_aa - 1) % normaliseCooldown == 0) {
                        handler.normaliseThermalLevel(player, playerStats, 1);
                    }
                    absThermalLevelMod = Math.abs(thermalLevelMod /= Math.max(1.0f, lowestThermalStrength / 2.0f));
                }
                if (OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player, (boolean)true)) {
                    playerStats.setThermalLevelNormalising(true);
                    handler.normaliseThermalLevel(player, playerStats, 1);
                    return;
                }
                if (!thermalPaddingHelm.func_190926_b()) {
                    thermalLevelTickCooldown += thermalLevelCooldownBase;
                }
                if (!thermalPaddingChestplate.func_190926_b()) {
                    thermalLevelTickCooldown += thermalLevelCooldownBase;
                }
                if (!thermalPaddingLeggings.func_190926_b()) {
                    thermalLevelTickCooldown += thermalLevelCooldownBase;
                }
                if (!thermalPaddingBoots.func_190926_b()) {
                    thermalLevelTickCooldown += thermalLevelCooldownBase;
                }
                if ((thermalLevelTickCooldownSingle = MathHelper.func_76141_d((float)((float)thermalLevelTickCooldown / absThermalLevelMod))) < 1) {
                    thermalLevelTickCooldownSingle = 1;
                }
                if ((player.field_70173_aa - 1) % thermalLevelTickCooldownSingle == 0) {
                    int last = playerStats.getThermalLevel();
                    playerStats.setThermalLevel(Math.min(Math.max(last + (thermalLevelMod < 0.0f ? -1 : 1), -22), 22));
                    if (playerStats.getThermalLevel() != last) {
                        GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_THERMAL_LEVEL, GCCoreUtil.getDimensionID((World)player.field_70170_p), new Object[]{playerStats.getThermalLevel(), playerStats.isThermalLevelNormalising()}), player);
                    }
                }
                playerStats.setThermalLevelNormalising(thermalLevelTickCooldownSingle > normaliseCooldown && !thermalPaddingHelm.func_190926_b() && !thermalPaddingChestplate.func_190926_b() && !thermalPaddingLeggings.func_190926_b() && !thermalPaddingBoots.func_190926_b());
                if (!playerStats.isThermalLevelNormalising()) {
                    if ((player.field_70173_aa - 1) % thermalLevelTickCooldown == 0 && Math.abs(playerStats.getThermalLevel()) >= 22) {
                        player.func_70097_a((DamageSource)DamageSourceGC.thermal, 1.5f);
                    }
                    if (playerStats.getThermalLevel() < -15) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 5, 2, true, true));
                    }
                    if (playerStats.getThermalLevel() > 15) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 5, 2, true, true));
                    }
                }
            } else {
                playerStats.setThermalLevelNormalising(true);
                handler.normaliseThermalLevel(player, playerStats, 2);
            }
        } else {
            playerStats.setThermalLevelNormalising(true);
            handler.normaliseThermalLevel(player, playerStats, 3);
        }
    }

    @Hook(injectOnLine=88)
    public static void update(TileEntityLaunchController te) {
        if (!te.func_145831_w().field_72995_K) {
            te.controlEnabled = te.launchSchedulingEnabled && te.hasEnoughEnergyToRun && !te.getDisabled(0);
            boolean frequencyCheckNeeded = (Boolean)ReflectionHelper.getPrivateValue(TileEntityLaunchController.class, (Object)te, (String[])new String[]{"frequencyCheckNeeded"});
            if (frequencyCheckNeeded) {
                te.checkDestFrequencyValid();
                frequencyCheckNeeded = false;
            }
            ReflectionHelper.setPrivateValue(TileEntityLaunchController.class, (Object)te, (Object)frequencyCheckNeeded, (String[])new String[]{"frequencyCheckNeeded"});
            if (te.requiresClientUpdate) {
                te.requiresClientUpdate = false;
            }
            if (te.ticks % 40 == 0) {
                te.setFrequency(te.frequency);
                te.setDestinationFrequency(te.destFrequency);
            }
            if (te.ticks % 20 == 0 && chunkLoadTicket != null) {
                for (int i = 0; i < connectedPads.size(); ++i) {
                    BlockPos coords = connectedPads.get(i);
                    Block block = te.func_145831_w().func_180495_p(coords).func_177230_c();
                    TileEntity tile = te.func_145831_w().func_175625_s(coords);
                    if (tile instanceof IFuelDock) continue;
                    connectedPads.remove(i);
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)chunkLoadTicket, (ChunkPos)new ChunkPos(coords.func_177958_n() >> 4, coords.func_177952_p() >> 4));
                }
            }
        } else if (te.frequency == -1 && te.destFrequency == -1) {
            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimpleMars(PacketSimpleMars.EnumSimplePacketMars.S_UPDATE_ADVANCED_GUI, GCCoreUtil.getDimensionID((World)te.func_145831_w()), new Object[]{5, te.func_174877_v(), 0}));
        }
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static void onTicketLoaded(TileEntityLaunchController te, ForgeChunkManager.Ticket ticket, boolean placed) {
        if (!te.func_145831_w().field_72995_K && ConfigManagerMars.launchControllerChunkLoad) {
            if (ticket == null) {
                return;
            }
            if (chunkLoadTicket == null) {
                chunkLoadTicket = ticket;
            }
            NBTTagCompound nbt = chunkLoadTicket.getModData();
            nbt.func_74768_a("ChunkLoaderTileX", te.func_174877_v().func_177958_n());
            nbt.func_74768_a("ChunkLoaderTileY", te.func_174877_v().func_177956_o());
            nbt.func_74768_a("ChunkLoaderTileZ", te.func_174877_v().func_177952_p());
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    TileEntity tile = te.func_145831_w().func_175625_s(te.func_174877_v().func_177982_a(x, 0, z));
                    Block blockID = te.func_145831_w().func_180495_p(te.func_174877_v().func_177982_a(x, 0, z)).func_177230_c();
                    if (!(tile instanceof IFuelDock) || te.func_174877_v().func_177958_n() + x >> 4 == te.func_174877_v().func_177958_n() >> 4 && te.func_174877_v().func_177952_p() + z >> 4 == te.func_174877_v().func_177952_p() >> 4) continue;
                    connectedPads.add(new BlockPos(te.func_174877_v().func_177958_n() + x, te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p() + z));
                    if (placed) {
                        ChunkLoadingCallback.forceChunk((ForgeChunkManager.Ticket)chunkLoadTicket, (World)te.func_145831_w(), (int)(te.func_174877_v().func_177958_n() + x), (int)te.func_174877_v().func_177956_o(), (int)(te.func_174877_v().func_177952_p() + z), (String)te.getOwnerName());
                        continue;
                    }
                    ChunkLoadingCallback.addToList((World)te.func_145831_w(), (int)te.func_174877_v().func_177958_n(), (int)te.func_174877_v().func_177956_o(), (int)te.func_174877_v().func_177952_p(), (String)te.getOwnerName());
                }
            }
            ChunkLoadingCallback.forceChunk((ForgeChunkManager.Ticket)chunkLoadTicket, (World)te.func_145831_w(), (int)te.func_174877_v().func_177958_n(), (int)te.func_174877_v().func_177956_o(), (int)te.func_174877_v().func_177952_p(), (String)te.getOwnerName());
        }
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static boolean canAttachToLandingPad(TileEntityLaunchController te, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof IFuelDock;
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static void updateRocketOnDockSettings(TileEntityLaunchController te) {
        IFuelDock pad;
        IDockable rocket;
        if (te.attachedDock instanceof IFuelDock && (rocket = (pad = (IFuelDock)te.attachedDock).getDockedEntity()) instanceof EntityAutoRocket) {
            ((EntityAutoRocket)rocket).updateControllerSettings(pad);
        }
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static boolean setTarget(EntityAutoRocket rocket, boolean doSet, int destFreq) {
        Class controllerClass = (Class)ReflectionHelper.getPrivateValue(EntityAutoRocket.class, (Object)rocket, (String[])new String[]{"controllerClass"});
        WorldServer[] servers = GCCoreUtil.getWorldServerList((World)rocket.field_70170_p);
        if (!GalacticraftCore.isPlanetsLoaded || controllerClass == null) {
            return false;
        }
        for (int i = 0; i < servers.length; ++i) {
            WorldServer world = servers[i];
            try {
                for (TileEntity tile : new ArrayList(world.field_147482_g)) {
                    int controllerFrequency;
                    if (!controllerClass.isInstance(tile) || !controllerClass.isInstance(tile = world.func_175625_s(tile.func_174877_v())) || destFreq != (controllerFrequency = controllerClass.getField("frequency").getInt(tile))) continue;
                    boolean targetSet = false;
                    block4: for (int x = -3; x <= 4; ++x) {
                        for (int z = -3; z <= 4; ++z) {
                            BlockPos pos = new BlockPos((Vec3i)tile.func_174877_v().func_177982_a(x, 0, z));
                            Block block = world.func_180495_p(pos).func_177230_c();
                            TileEntity tileen = world.func_175625_s(pos);
                            if (!(tileen instanceof IFuelDock)) continue;
                            System.out.println(block);
                            if (doSet) {
                                rocket.targetVec = pos;
                            }
                            targetSet = true;
                            break block4;
                        }
                    }
                    if (doSet) {
                        rocket.targetDimension = tile.func_145831_w().field_73011_w.getDimension();
                    }
                    if (!targetSet) {
                        if (doSet) {
                            rocket.targetVec = null;
                        }
                        return false;
                    }
                    return true;
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static boolean setFrequency(EntityAutoRocket rocket) {
        TileEntity launchController;
        Class controllerClass = (Class)ReflectionHelper.getPrivateValue(EntityAutoRocket.class, (Object)rocket, (String[])new String[]{"controllerClass"});
        BlockVec3 activeLaunchController = (BlockVec3)ReflectionHelper.getPrivateValue(EntityAutoRocket.class, (Object)rocket, (String[])new String[]{"activeLaunchController"});
        if (!GalacticraftCore.isPlanetsLoaded || controllerClass == null) {
            return false;
        }
        if (activeLaunchController != null && controllerClass.isInstance(launchController = activeLaunchController.getTileEntity((IBlockAccess)rocket.field_70170_p))) {
            try {
                int controllerFrequency;
                boolean foundPad;
                Boolean b = (Boolean)controllerClass.getMethod("validFrequency", new Class[0]).invoke((Object)launchController, new Object[0]);
                if (b != null && b.booleanValue() && (foundPad = GSHooksManager.setTarget(rocket, false, controllerFrequency = controllerClass.getField("destFrequency").getInt(launchController)))) {
                    rocket.destinationFrequency = controllerFrequency;
                    GCLog.debug((String)("Rocket under launch control: going to target frequency " + controllerFrequency));
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        rocket.destinationFrequency = -1;
        return false;
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static void populateBuyingList(EntityAlienVillager e) {
        MerchantRecipeList buyingList = (MerchantRecipeList)ReflectionHelper.getPrivateValue(EntityAlienVillager.class, (Object)e, (String[])new String[]{"buyingList"});
        if (buyingList == null) {
            buyingList = new MerchantRecipeList();
        }
        for (EntityAlienVillager.ITradeList tradeList : DEFAULT_TRADE_LIST_MAP) {
            tradeList.modifyMerchantRecipeList(buyingList, e.func_130014_f_().field_73012_v);
        }
        ReflectionHelper.setPrivateValue(EntityAlienVillager.class, (Object)e, (Object)buyingList, (String[])new String[]{"buyingList"});
    }

    static {
        DEFAULT_TRADE_LIST_MAP = new EntityAlienVillager.ITradeList[]{new EntityAlienVillager.ItemAndEmeraldToItem(new ItemStack(GCItems.schematic, 1, 1), new EntityAlienVillager.PriceInfo(40, 55), ItemBasicGS.BasicItems.SCHEMATIC_BOX.getItemStack()), new EntityAlienVillager.ListItemForEmeralds(new ItemStack(GCItems.oxMask, 1, 0), new EntityAlienVillager.PriceInfo(1, 2)), new EntityAlienVillager.ListItemForEmeralds(new ItemStack(GCItems.oxTankLight, 1, 235), new EntityAlienVillager.PriceInfo(3, 4)), new EntityAlienVillager.ListItemForEmeralds(new ItemStack(GCItems.oxygenGear, 1, 0), new EntityAlienVillager.PriceInfo(3, 4)), new EntityAlienVillager.ListItemForEmeralds(new ItemStack(GCItems.fuelCanister, 1, 317), new EntityAlienVillager.PriceInfo(3, 4)), new EntityAlienVillager.ListItemForEmeralds(new ItemStack(GCItems.parachute, 1, 0), new EntityAlienVillager.PriceInfo(1, 2)), new EntityAlienVillager.ListItemForEmeralds(new ItemStack(GCItems.battery, 1, 58), new EntityAlienVillager.PriceInfo(2, 4)), new EntityAlienVillager.ItemAndEmeraldToItem(new ItemStack(GCItems.oilCanister, 1, 1001), new EntityAlienVillager.PriceInfo(1, 1), new ItemStack(GCItems.foodItem, 1, 1)), new EntityAlienVillager.ListItemForEmeralds(new ItemStack(GCItems.basicItem, 1, 13), new EntityAlienVillager.PriceInfo(3, 4)), new EntityAlienVillager.ItemAndEmeraldToItem(new ItemStack(GCItems.schematic, 1, 0), new EntityAlienVillager.PriceInfo(3, 5), new ItemStack(GCItems.schematic, 1, 1)), new EntityAlienVillager.ItemAndEmeraldToItem(new ItemStack(GCItems.schematic, 1, 1), new EntityAlienVillager.PriceInfo(3, 5), new ItemStack(GCItems.schematic, 1, 0)), new EntityAlienVillager.ItemAndEmeraldToItem(new ItemStack(GCItems.basicItem, 2, 3), new EntityAlienVillager.PriceInfo(1, 1), new ItemStack(GCItems.basicItem, 1, 6)), new EntityAlienVillager.ItemAndEmeraldToItem(new ItemStack(GCItems.basicItem, 2, 4), new EntityAlienVillager.PriceInfo(1, 1), new ItemStack(GCItems.basicItem, 1, 7)), new EntityAlienVillager.EmeraldForItems(new ItemStack(Blocks.field_150345_g, 1, 3), new EntityAlienVillager.PriceInfo(11, 39))};
    }
}

