/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.client.gui.component;

import io.github.phantamanta44.libnine.util.render.GuiUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public abstract class GuiComponent {
    protected final int x;
    protected final int y;
    protected final int width;
    protected final int height;
    protected GuiScreen gui;

    public GuiComponent(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    void setGui(GuiScreen gui) {
        this.gui = gui;
    }

    protected void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    protected void drawString(String string, int x, int y, int colour, boolean shadow) {
        Minecraft.func_71410_x().field_71466_p.func_175065_a(string, (float)x, (float)y, colour, shadow);
    }

    protected void drawString(String string, int x, int y, int colour) {
        this.drawString(string, x, y, colour, false);
    }

    protected void drawTooltip(String string, int x, int y) {
        this.gui.func_146279_a(string, x, y);
        RenderHelper.func_74520_c();
    }

    protected void drawTooltip(List<String> lines, int x, int y) {
        this.gui.func_146283_a(lines, x, y);
        RenderHelper.func_74520_c();
    }

    protected boolean isMouseOver(int mX, int mY) {
        return GuiUtils.isMouseOver(this.x, this.y, this.width, this.height, mX, mY);
    }

    public abstract void render(float var1, int var2, int var3, boolean var4);

    public void renderTooltip(float partialTicks, int mX, int mY) {
    }

    public boolean onClick(int mX, int mY, int button, boolean mouseOver) {
        return false;
    }

    public boolean onDrag(int mX, int mY, int button, long dragTime, boolean mouseOver) {
        return false;
    }

    public boolean onKeyPress(int keyCode, char typed) {
        return false;
    }

    protected static void playClickSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }
}

