/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.collection;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.NonNullList;

public class NonNullLists {
    private static final NonNullList<?> EMPTY_NN_LIST = NonNullLists.wrapNonnull(Collections.emptyList());

    public static <T> NonNullList<T> wrapNonnull(List<T> delegate) {
        return new DelegatingNonNullList<T>(delegate);
    }

    public static <T> NonNullList<T> emptyNonnullList() {
        return EMPTY_NN_LIST;
    }

    public static <T> NonNullList<T> nonnullListOf(T element) {
        return NonNullLists.wrapNonnull(Collections.singletonList(element));
    }

    public static <T> NonNullList<T> nonnullListOf(T first, T ... elements) {
        return NonNullLists.wrapNonnull(Lists.asList(first, (Object[])elements));
    }

    private static class DelegatingNonNullList<T>
    extends NonNullList<T> {
        DelegatingNonNullList(List<T> delegate) {
            super(delegate, null);
        }
    }
}

