/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.helper;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidHandlerUtils {
    public static IFluidHandler insertOnly(IFluidHandler fluidHandler) {
        return new InsertOnlyFluidHandler(fluidHandler);
    }

    public static IFluidHandler extractOnly(IFluidHandler fluidHandler) {
        return new ExtractOnlyFluidHandler(fluidHandler);
    }

    public static IFluidTank insertOnly(IFluidTank tank) {
        return new InsertOnlyFluidTank(tank);
    }

    public static IFluidTank extractOnly(IFluidTank tank) {
        return new ExtractOnlyFluidTank(tank);
    }

    private static class ExtractOnlyFluidTank
    implements IFluidTank {
        private final IFluidTank delegate;

        ExtractOnlyFluidTank(IFluidTank delegate) {
            this.delegate = delegate;
        }

        @Nullable
        public FluidStack getFluid() {
            return this.delegate.getFluid();
        }

        public int getFluidAmount() {
            return this.delegate.getFluidAmount();
        }

        public int getCapacity() {
            return this.delegate.getCapacity();
        }

        public FluidTankInfo getInfo() {
            return this.delegate.getInfo();
        }

        public int fill(FluidStack resource, boolean doFill) {
            return 0;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return this.delegate.drain(maxDrain, doDrain);
        }
    }

    private static class InsertOnlyFluidTank
    implements IFluidTank {
        private final IFluidTank delegate;

        InsertOnlyFluidTank(IFluidTank delegate) {
            this.delegate = delegate;
        }

        @Nullable
        public FluidStack getFluid() {
            return this.delegate.getFluid();
        }

        public int getFluidAmount() {
            return this.delegate.getFluidAmount();
        }

        public int getCapacity() {
            return this.delegate.getCapacity();
        }

        public FluidTankInfo getInfo() {
            return this.delegate.getInfo();
        }

        public int fill(FluidStack resource, boolean doFill) {
            return this.delegate.fill(resource, doFill);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }

    private static class ExtractOnlyFluidHandler
    implements IFluidHandler {
        private final IFluidHandler delegate;

        ExtractOnlyFluidHandler(IFluidHandler delegate) {
            this.delegate = delegate;
        }

        public IFluidTankProperties[] getTankProperties() {
            return (IFluidTankProperties[])Arrays.stream(this.delegate.getTankProperties()).map(Properties::new).toArray(IFluidTankProperties[]::new);
        }

        public int fill(FluidStack resource, boolean doFill) {
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return this.delegate.drain(resource, doDrain);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return this.delegate.drain(maxDrain, doDrain);
        }

        private static class Properties
        implements IFluidTankProperties {
            private final IFluidTankProperties props;

            Properties(IFluidTankProperties props) {
                this.props = props;
            }

            @Nullable
            public FluidStack getContents() {
                return this.props.getContents();
            }

            public int getCapacity() {
                return this.props.getCapacity();
            }

            public boolean canFill() {
                return false;
            }

            public boolean canDrain() {
                return this.props.canDrain();
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return false;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return this.props.canDrainFluidType(fluidStack);
            }
        }
    }

    private static class InsertOnlyFluidHandler
    implements IFluidHandler {
        private final IFluidHandler delegate;

        InsertOnlyFluidHandler(IFluidHandler delegate) {
            this.delegate = delegate;
        }

        public IFluidTankProperties[] getTankProperties() {
            return (IFluidTankProperties[])Arrays.stream(this.delegate.getTankProperties()).map(Properties::new).toArray(IFluidTankProperties[]::new);
        }

        public int fill(FluidStack resource, boolean doFill) {
            return this.delegate.fill(resource, doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }

        private static class Properties
        implements IFluidTankProperties {
            private final IFluidTankProperties props;

            Properties(IFluidTankProperties props) {
                this.props = props;
            }

            @Nullable
            public FluidStack getContents() {
                return this.props.getContents();
            }

            public int getCapacity() {
                return this.props.getCapacity();
            }

            public boolean canFill() {
                return this.props.canFill();
            }

            public boolean canDrain() {
                return false;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return this.props.canFillFluidType(fluidStack);
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return false;
            }
        }
    }
}

