/*
 * Decompiled with CFR 0.152.
 */
package nihiltres.engineersdoors.common.block;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nihiltres.engineersdoors.EngineersDoors;
import nihiltres.engineersdoors.common.EDConfig;
import nihiltres.engineersdoors.common.block.properties.EnumDoorMaterial;
import nihiltres.engineersdoors.common.block.properties.IBlockSetup;
import nihiltres.engineersdoors.common.block.properties.ICustomStateMapped;
import nihiltres.engineersdoors.common.item.ItemEDDoor;

public class BlockModDoor
extends BlockDoor
implements IBlockSetup,
ICustomStateMapped {
    public boolean opensManually = true;
    public ItemEDDoor item;
    public EnumDoorMaterial doorMaterial;
    private static boolean quarkDoubleDoors = false;
    private static final ResourceLocation STONE_DOOR_OPEN_RL = new ResourceLocation("engineersdoors", "stone_door_open");
    private static final ResourceLocation STONE_DOOR_CLOSE_RL = new ResourceLocation("engineersdoors", "stone_door_close");
    public static final SoundEvent STONE_DOOR_OPEN = (SoundEvent)new SoundEvent(STONE_DOOR_OPEN_RL).setRegistryName(STONE_DOOR_OPEN_RL);
    public static final SoundEvent STONE_DOOR_CLOSE = (SoundEvent)new SoundEvent(STONE_DOOR_CLOSE_RL).setRegistryName(STONE_DOOR_CLOSE_RL);

    private BlockModDoor(Material materialIn, @Nonnull String nameIn) {
        super(materialIn == null ? Material.field_151575_d : materialIn);
        if (!EnumDoorMaterial.isSupported(materialIn)) {
            EngineersDoors.debug("Door with unsupported material initialized; it'll default to wood sounds");
        }
        this.doorMaterial = EnumDoorMaterial.fromMaterial(materialIn);
        this.opensManually = this.doorMaterial.isDefaultManual();
        this.func_149672_a(IBlockSetup.EnumMaterialDefaults.getSoundType(materialIn));
        this.setDefaultBlockProperties(materialIn, nameIn);
    }

    public BlockModDoor(Material materialIn, String nameIn, Collection<String> oreNamesIn) {
        this(materialIn, nameIn);
        this.item = new ItemEDDoor((Block)this, nameIn, oreNamesIn);
    }

    public BlockModDoor(Material materialIn, String nameIn, @Nonnull Collection<String> oreNamesIn, boolean manual) {
        this(materialIn, nameIn, oreNamesIn);
        this.opensManually = manual;
    }

    public BlockModDoor(Material materialIn, String nameIn, String oreNameIn) {
        this(materialIn, nameIn, Arrays.asList(oreNameIn));
    }

    public BlockModDoor(Material materialIn, String nameIn, @Nonnull String oreNameIn, boolean manual) {
        this(materialIn, nameIn, Arrays.asList(oreNameIn), manual);
    }

    public BlockModDoor(String nameIn, @Nonnull BlockModDoor otherDoor) {
        this(otherDoor.field_149764_J, nameIn, otherDoor.item.getOreNames(), otherDoor.opensManually);
        this.setBlockProperties(otherDoor.field_149782_v, otherDoor.field_149781_w, otherDoor.getHarvestTool(otherDoor.func_176223_P()), otherDoor.getHarvestLevel(otherDoor.func_176223_P()));
    }

    public BlockModDoor copy(String nameIn) {
        return new BlockModDoor(nameIn, this);
    }

    @Override
    public Item getItemBlock() {
        return this.item;
    }

    public boolean testedToggleDoor(World world, BlockPos posIn, boolean isOpening, @Nullable EntityPlayer playerIn) {
        IBlockState stateAtPos;
        if (posIn == null) {
            return false;
        }
        IBlockState state = world.func_180495_p(posIn);
        BlockPos pos = state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? posIn : posIn.func_177977_b();
        IBlockState iBlockState = stateAtPos = posIn.equals((Object)pos) ? state : world.func_180495_p(pos);
        if (!(stateAtPos.func_177230_c() instanceof BlockDoor) || (Boolean)stateAtPos.func_177229_b((IProperty)field_176519_b) == isOpening) {
            return false;
        }
        IBlockState newState = world.func_180495_p(pos).func_177231_a((IProperty)field_176519_b);
        world.func_180501_a(pos, newState, 10);
        world.func_175704_b(pos, pos);
        this.doorMaterial.playSound(world, playerIn, pos, isOpening);
        return true;
    }

    public void func_176512_a(World world, BlockPos posIn, boolean isOpening) {
        this.testedToggleDoor(world, posIn, isOpening, null);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!this.opensManually && !EDConfig.manualSteelDoors) {
            return false;
        }
        IBlockState actualState = state.func_185899_b((IBlockAccess)worldIn, pos);
        boolean isOpen = (Boolean)actualState.func_177229_b((IProperty)field_176519_b);
        boolean shouldToggleOtherDoor = false;
        boolean result = false;
        BlockPos mirrorPos = null;
        if (quarkDoubleDoors && EDConfig.manualSteelDoors && !playerIn.func_70093_af() && this.field_149764_J == Material.field_151573_f) {
            EnumFacing direction = (EnumFacing)actualState.func_177229_b((IProperty)field_176520_a);
            BlockDoor.EnumHingePosition hinge = (BlockDoor.EnumHingePosition)actualState.func_177229_b((IProperty)field_176521_M);
            mirrorPos = pos.func_177972_a(hinge == BlockDoor.EnumHingePosition.RIGHT ? direction.func_176735_f() : direction.func_176746_e());
            IBlockState other = worldIn.func_180495_p(mirrorPos).func_185899_b((IBlockAccess)worldIn, mirrorPos);
            shouldToggleOtherDoor = other.func_177230_c() instanceof BlockDoor && other.func_177229_b((IProperty)field_176520_a) == direction && (Boolean)other.func_177229_b((IProperty)field_176519_b) == isOpen && other.func_177229_b((IProperty)field_176521_M) != hinge;
        }
        result = this.testedToggleDoor(worldIn, pos, !isOpen, playerIn);
        if (shouldToggleOtherDoor && result) {
            this.testedToggleDoor(worldIn, mirrorPos, !isOpen, playerIn);
        }
        return result;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            BlockPos downPos = pos.func_177977_b();
            IBlockState downState = world.func_180495_p(downPos);
            if (downState.func_177230_c() != this) {
                world.func_175698_g(pos);
            } else if (blockIn != this) {
                downState.func_189546_a(world, downPos, blockIn, fromPos);
            }
        } else {
            boolean destroyed = false;
            BlockPos upPos = pos.func_177984_a();
            IBlockState upState = world.func_180495_p(upPos);
            if (upState.func_177230_c() != this) {
                world.func_175698_g(pos);
                destroyed = true;
            }
            if (!world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP)) {
                world.func_175698_g(pos);
                destroyed = true;
                if (upState.func_177230_c() == this) {
                    world.func_175698_g(upPos);
                }
            }
            if (destroyed) {
                if (!world.field_72995_K) {
                    this.func_176226_b(world, pos, state, 0);
                }
            } else {
                boolean isPowered;
                boolean bl = isPowered = world.func_175640_z(pos) || world.func_175640_z(upPos);
                if (blockIn != this && (isPowered || blockIn.func_176223_P().func_185897_m()) && isPowered != (Boolean)upState.func_177229_b((IProperty)field_176522_N)) {
                    world.func_180501_a(upPos, upState.func_177226_a((IProperty)field_176522_N, (Comparable)Boolean.valueOf(isPowered)), 2);
                    if (isPowered != (Boolean)state.func_177229_b((IProperty)field_176519_b)) {
                        world.func_180501_a(pos, state.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(isPowered)), 2);
                        world.func_175704_b(pos, pos);
                        this.doorMaterial.playSound(world, null, upPos, isPowered);
                    }
                }
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? Items.field_190931_a : this.item;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Item)this.item);
    }

    public static void checkForQuarkDoubleDoors() {
        if (Loader.isModLoaded((String)"quark")) {
            try {
                Method qIsFeatureEnabled = Class.forName("vazkii.quark.base.module.ModuleLoader").getMethod("isFeatureEnabled", Class.class);
                Class<?> qDoubleDoorsClass = Class.forName("vazkii.quark.tweaks.feature.DoubleDoors");
                boolean oldQDD = quarkDoubleDoors;
                quarkDoubleDoors = (Boolean)qIsFeatureEnabled.invoke(null, qDoubleDoorsClass);
                if (quarkDoubleDoors && !oldQDD) {
                    EngineersDoors.log("Quark double-door compatibility enabled");
                }
                if (oldQDD && !quarkDoubleDoors) {
                    EngineersDoors.log("Quark double-door compatibility disabled");
                }
            }
            catch (ClassNotFoundException | ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException throwable) {
                // empty catch block
            }
        }
    }

    public BlockModDoor setTranslucent() {
        return this.setTranslucent(true);
    }

    public BlockModDoor setTranslucent(boolean val) {
        this.field_149785_s = val;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.field_149785_s ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.CUTOUT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IStateMapper getStateMapper() {
        return new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a();
    }
}

