/*
 * Decompiled with CFR 0.152.
 */
package nihiltres.engineersdoors.common.block;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.metal.BlockMetalLadder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import nihiltres.engineersdoors.EngineersDoors;
import nihiltres.engineersdoors.common.EDConfig;
import nihiltres.engineersdoors.common.block.properties.EnumTrapdoorMaterial;
import nihiltres.engineersdoors.common.block.properties.IBlockSetup;
import nihiltres.engineersdoors.common.item.IOre;

public class BlockModTrapdoor
extends BlockTrapDoor
implements IOre,
IBlockSetup {
    public Item itemBlock;
    public EnumTrapdoorMaterial trapdoorMaterial;
    public boolean opensManually;
    public static Set<Class<?>> ladderClasses = new HashSet();
    private static final ResourceLocation STONE_TRAPDOOR_OPEN_RL = new ResourceLocation("engineersdoors", "stone_trapdoor_open");
    private static final ResourceLocation STONE_TRAPDOOR_CLOSE_RL = new ResourceLocation("engineersdoors", "stone_trapdoor_close");
    public static final SoundEvent STONE_TRAPDOOR_OPEN = (SoundEvent)new SoundEvent(STONE_TRAPDOOR_OPEN_RL).setRegistryName(STONE_TRAPDOOR_OPEN_RL);
    public static final SoundEvent STONE_TRAPDOOR_CLOSE = (SoundEvent)new SoundEvent(STONE_TRAPDOOR_CLOSE_RL).setRegistryName(STONE_TRAPDOOR_CLOSE_RL);

    private BlockModTrapdoor(Material materialIn, @Nonnull String nameIn) {
        super(materialIn == null ? Material.field_151575_d : materialIn);
        this.trapdoorMaterial = EnumTrapdoorMaterial.fromMaterial(materialIn);
        this.opensManually = this.trapdoorMaterial.isDefaultManual();
        this.setDefaultBlockProperties(materialIn, nameIn);
        this.func_149672_a(IBlockSetup.EnumMaterialDefaults.getSoundType(materialIn)).func_149647_a(EngineersDoors.creativeTab);
    }

    public BlockModTrapdoor(Material materialIn, String nameIn, @Nonnull Collection<String> oreNamesIn, boolean manual) {
        this(materialIn, nameIn, oreNamesIn);
        this.opensManually = manual;
    }

    public BlockModTrapdoor(Material materialIn, String nameIn, Collection<String> oreNamesIn) {
        this(materialIn, nameIn);
        this.addOreNames(oreNamesIn);
        this.itemBlock = IBlockSetup.createItemBlock((Block)this);
    }

    public BlockModTrapdoor(Material materialIn, String nameIn, @Nonnull String oreNameIn, boolean manual) {
        this(materialIn, nameIn, Arrays.asList(oreNameIn), manual);
    }

    public BlockModTrapdoor(Material materialIn, String nameIn, String oreNameIn) {
        this(materialIn, nameIn, Arrays.asList(oreNameIn));
    }

    @Override
    public Item getItemBlock() {
        return this.itemBlock;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!this.opensManually && !EDConfig.manualSteelDoors) {
            return false;
        }
        state = state.func_177231_a((IProperty)field_176283_b);
        worldIn.func_180501_a(pos, state, 2);
        this.func_185731_a(playerIn, worldIn, pos, (Boolean)state.func_177229_b((IProperty)field_176283_b));
        return true;
    }

    public void func_185731_a(@Nullable EntityPlayer player, World world, BlockPos pos, boolean isOpening) {
        this.trapdoorMaterial.playSound(world, player, pos, isOpening);
    }

    public static boolean addLadderClass(@Nonnull Class<?> clazz) {
        return ladderClasses.add(clazz);
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        if (!((Boolean)state.func_177229_b((IProperty)field_176283_b)).booleanValue()) {
            return false;
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_176284_a);
        IBlockState downState = world.func_180495_p(pos.func_177977_b());
        Class<?> downClass = downState.func_177230_c().getClass();
        if (BlockLadder.class.isAssignableFrom(downClass)) {
            return downState.func_177229_b((IProperty)BlockLadder.field_176382_a) == facing;
        }
        if (downClass == BlockMetalLadder.class) {
            return downState.func_185899_b(world, pos.func_177977_b()).func_177229_b((IProperty)IEProperties.FACING_HORIZONTAL) == facing;
        }
        if (Loader.isModLoaded((String)"quark")) {
            try {
                Class<?> qLadderClass = Class.forName("vazkii.quark.decoration.block.BlockIronLadder");
                IProperty qLadderFacing = (IProperty)qLadderClass.getField("FACING").get(null);
                if (downClass == qLadderClass) {
                    return downState.func_177229_b(qLadderFacing) == facing;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException exception) {
                // empty catch block
            }
        }
        return ladderClasses.contains(downClass);
    }

    public static void checkForModLadders() {
    }

    private static void addModLadder(String modID, String modLadderClassName) {
        if (Loader.isModLoaded((String)modID)) {
            try {
                Class<?> modLadderClass = Class.forName(modLadderClassName);
                if (BlockModTrapdoor.addLadderClass(modLadderClass)) {
                    EngineersDoors.log(String.format("Ladder compatibility enabled for %s", modLadderClassName));
                }
            }
            catch (ClassNotFoundException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }
}

