/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.gctweaks.gc.features.spawnitems;

import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.entities.player.GCCapabilities;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.inventory.InventoryExtended;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.venus.VenusItems;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.romvoid95.gctweaks.base.Feature;
import net.romvoid95.gctweaks.gc.features.spawnitems.command.CommandOxygenReset;

public class SpawnWithOxygenEquip
extends Feature {
    private boolean spawnWithOxygenEquip;
    private boolean includeParachute;
    private boolean includeFreqModule;
    private boolean includeShieldController;
    private boolean includeThermals;
    private static String tanksValue;
    private static String thermalArmor;
    private static String[] validValues;
    private static String[] validThermals;

    @Override
    public String category() {
        return "spawnItems";
    }

    @Override
    public String comment() {
        return "Allows Players to Spawn With Oxygen Items Equipped";
    }

    @Override
    public void syncConfig(String category) {
        this.spawnWithOxygenEquip = this.set(category, "enableFeature", true);
        tanksValue = this.setFormated(category, "tankProp", "light", validValues);
        thermalArmor = this.setFormated(category, "thermalProp", "thermal", validThermals);
        this.includeThermals = this.set(category, "enableThermals", "Always FALSE if \"enableFeature\" = FALSE", false);
        this.includeParachute = this.set(category, "enableParachute", "Always FALSE if \"enableFeature\" = FALSE", false);
        this.includeFreqModule = this.set(category, "enableFreqModule", "Always FALSE if \"enableFeature\" = FALSE", false);
        this.includeShieldController = this.set(category, "enableShieldItem", "Always FALSE if \"enableFeature\" = FALSE", false);
        if (!this.spawnWithOxygenEquip) {
            this.includeThermals = false;
            this.includeParachute = false;
            this.includeFreqModule = false;
            this.includeShieldController = false;
        }
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        NBTTagCompound entityData = player.getEntityData();
        NBTTagCompound persistedData = entityData.func_74775_l("PlayerPersisted");
        entityData.func_74782_a("PlayerPersisted", (NBTBase)persistedData);
        String key = "gctweaks:ReceivedOxygen";
        if (!persistedData.func_74767_n("gctweaks:ReceivedOxygen") && this.spawnWithOxygenEquip) {
            GCPlayerStats gcstats = (GCPlayerStats)event.player.getCapability(GCCapabilities.GC_STATS_CAPABILITY, null);
            InventoryExtended inv = new InventoryExtended();
            inv.func_70299_a(0, SpawnWithOxygenEquip.getStack(GCItems.oxMask));
            inv.func_70299_a(1, SpawnWithOxygenEquip.getStack(GCItems.oxygenGear));
            inv.func_70299_a(2, SpawnWithOxygenEquip.setTanks());
            inv.func_70299_a(3, SpawnWithOxygenEquip.setTanks());
            if (this.includeParachute) {
                inv.func_70299_a(4, SpawnWithOxygenEquip.getStack(GCItems.parachute));
            }
            if (this.includeShieldController) {
                inv.func_70299_a(10, SpawnWithOxygenEquip.getStack(VenusItems.basicItem, 0));
            }
            if (this.includeFreqModule) {
                inv.func_70299_a(5, SpawnWithOxygenEquip.getStack(GCItems.basicItem, 19));
            }
            if (this.includeThermals) {
                inv.func_70299_a(6, SpawnWithOxygenEquip.setThermals(0));
                inv.func_70299_a(7, SpawnWithOxygenEquip.setThermals(1));
                inv.func_70299_a(8, SpawnWithOxygenEquip.setThermals(2));
                inv.func_70299_a(9, SpawnWithOxygenEquip.setThermals(3));
            }
            gcstats.setExtendedInventory(inv);
            persistedData.func_74757_a("gctweaks:ReceivedOxygen", true);
        }
    }

    private static ItemStack setTanks() {
        ItemStack tank = null;
        switch (tanksValue) {
            case "heavy": {
                tank = SpawnWithOxygenEquip.getStack(GCItems.oxTankHeavy);
                break;
            }
            case "medium": {
                tank = SpawnWithOxygenEquip.getStack(GCItems.oxTankMedium);
                break;
            }
            case "light": {
                tank = SpawnWithOxygenEquip.getStack(GCItems.oxTankLight);
            }
        }
        return tank;
    }

    private static ItemStack setThermals(int meta) {
        ItemStack thermal = null;
        switch (thermalArmor) {
            case "isothermal": {
                thermal = SpawnWithOxygenEquip.getStack(VenusItems.thermalPaddingTier2, meta);
                break;
            }
            case "thermal": {
                thermal = SpawnWithOxygenEquip.getStack(AsteroidsItems.thermalPadding, meta);
                break;
            }
        }
        return thermal;
    }

    public static ItemStack getStack(Item item, int meta) {
        return new ItemStack(item, 1, meta);
    }

    public static ItemStack getStack(Item item) {
        return new ItemStack(item, 1);
    }

    @Override
    public void ServerStartingEvent(FMLServerStartingEvent event) {
        if (this.spawnWithOxygenEquip) {
            event.registerServerCommand((ICommand)new CommandOxygenReset());
        }
    }

    static {
        validValues = new String[]{"light", "medium", "heavy"};
        validThermals = new String[]{"thermal", "isothermal"};
    }
}

