/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import java.util.Arrays;
import mekanism.api.Coord4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasTank;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiGauge;
import mekanism.common.Mekanism;
import mekanism.common.base.ITankManager;
import mekanism.common.item.ItemGaugeDropper;
import mekanism.common.network.PacketDropperUse;
import mekanism.common.util.LangUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiGasGauge
extends GuiGauge<Gas> {
    private final IGasInfoHandler infoHandler;

    public GuiGasGauge(IGasInfoHandler handler, GuiGauge.Type type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        super(type, gui, def, x, y);
        this.infoHandler = handler;
    }

    public static GuiGasGauge getDummy(GuiGauge.Type type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        GuiGasGauge gauge = new GuiGasGauge(null, type, gui, def, x, y);
        gauge.dummy = true;
        return gauge;
    }

    @Override
    protected boolean inBounds(int xAxis, int yAxis) {
        return xAxis >= this.xLocation + 1 && xAxis <= this.xLocation + this.width - 1 && yAxis >= this.yLocation + 1 && yAxis <= this.yLocation + this.height - 1;
    }

    @Override
    public TransmissionType getTransmission() {
        return TransmissionType.GAS;
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
        if (this.inBounds(xAxis, yAxis)) {
            int index;
            Object tile;
            ItemStack stack = GuiGasGauge.mc.field_71439_g.field_71071_by.func_70445_o();
            if (this.guiObj instanceof GuiMekanismTile && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemGaugeDropper && (tile = ((GuiMekanismTile)this.guiObj).getTileEntity()) instanceof ITankManager && ((ITankManager)tile).getTanks() != null && (index = Arrays.asList(((ITankManager)tile).getTanks()).indexOf(this.infoHandler.getTank())) != -1) {
                if (button == 0 && Keyboard.isKeyDown((int)42)) {
                    button = 2;
                }
                Mekanism.packetHandler.sendToServer(new PacketDropperUse.DropperUseMessage(Coord4D.get(tile), button, index));
            }
        }
    }

    @Override
    public int getScaledLevel() {
        if (this.dummy) {
            return this.height - 2;
        }
        if (this.infoHandler.getTank().getGas() == null || this.infoHandler.getTank().getMaxGas() == 0) {
            return 0;
        }
        return this.infoHandler.getTank().getStored() * (this.height - 2) / this.infoHandler.getTank().getMaxGas();
    }

    @Override
    public TextureAtlasSprite getIcon() {
        if (this.dummy) {
            return ((Gas)this.dummyType).getSprite();
        }
        return this.infoHandler.getTank() != null && this.infoHandler.getTank().getGas() != null && this.infoHandler.getTank().getGas().getGas() != null ? this.infoHandler.getTank().getGas().getGas().getSprite() : null;
    }

    @Override
    public String getTooltipText() {
        if (this.dummy) {
            return ((Gas)this.dummyType).getLocalizedName();
        }
        return this.infoHandler.getTank().getGas() != null ? this.infoHandler.getTank().getGas().getGas().getLocalizedName() + ": " + this.infoHandler.getTank().getStored() : LangUtils.localize("gui.empty");
    }

    @Override
    public int getRenderColor() {
        if (this.dummy) {
            return ((Gas)this.dummyType).getTint();
        }
        return this.infoHandler.getTank().getGas() != null ? this.infoHandler.getTank().getGas().getGas().getTint() : super.getRenderColor();
    }

    public static interface IGasInfoHandler {
        public GasTank getTank();
    }
}

