/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.item;

import java.util.List;
import lumien.randomthings.config.Features;
import lumien.randomthings.item.ItemBase;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemPortKey
extends ItemBase {
    public ItemPortKey() {
        super("portKey");
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound targetCompound = stack.func_179543_a("target");
        if (targetCompound != null) {
            if (!Features.HIDE_CORDS) {
                int dimension = targetCompound.func_74762_e("dimension");
                int posX = targetCompound.func_74762_e("posX");
                int posY = targetCompound.func_74762_e("posY");
                int posZ = targetCompound.func_74762_e("posZ");
                tooltip.add(I18n.func_135052_a((String)"item.portkey.x", (Object[])new Object[]{posX}));
                tooltip.add(I18n.func_135052_a((String)"item.portkey.y", (Object[])new Object[]{posY}));
                tooltip.add(I18n.func_135052_a((String)"item.portkey.z", (Object[])new Object[]{posZ}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"item.portkey.set", (Object[])new Object[0]));
            }
        } else {
            tooltip.add(I18n.func_135052_a((String)"item.portkey.notset", (Object[])new Object[0]));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!world.field_72995_K) {
            ItemStack me = player.func_184586_b(hand);
            NBTTagCompound target = me.func_190925_c("target");
            target.func_74768_a("dimension", world.field_73011_w.getDimension());
            target.func_74768_a("posX", pos.func_177958_n());
            target.func_74768_a("posY", pos.func_177956_o());
            target.func_74768_a("posZ", pos.func_177952_p());
        }
        return EnumActionResult.SUCCESS;
    }

    public String getHighlightTip(ItemStack item, String displayName) {
        NBTTagCompound target = item.func_179543_a("target");
        if (target != null && !Features.HIDE_CORDS) {
            int dimension = target.func_74762_e("dimension");
            int posX = target.func_74762_e("posX");
            int posY = target.func_74762_e("posY");
            int posZ = target.func_74762_e("posZ");
            displayName = displayName + String.format(" (%d , %d , %d)", posX, posY, posZ);
        }
        return displayName;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        stack.func_190919_e("trueage");
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        NBTTagCompound ageCompound = entityItem.func_92059_d().func_190925_c("trueage");
        if (ageCompound.func_74762_e("value") == 0) {
            entityItem.func_174873_u();
        }
        ageCompound.func_74768_a("value", ageCompound.func_74762_e("value") + 1);
        return false;
    }

    public boolean func_77636_d(ItemStack stack) {
        NBTTagCompound age = stack.func_179543_a("trueage");
        if (age != null) {
            return age.func_74762_e("value") < 100 || stack.func_179543_a("target") == null;
        }
        return true;
    }
}

