/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.integration.crafttweaker;

import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.AssemblyRecipes;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class ActionAssemblerRecipes {

    static class Remove
    implements IAction {
        private final IItemStack item;

        public Remove(IItemStack item) {
            this.item = item;
        }

        public void apply() {
            AssemblyRecipes.removeRecipe(CraftTweakerMC.getItemStack((IItemStack)this.item));
        }

        public String describe() {
            return "Removed Assembly recipe for " + this.item;
        }
    }

    static class Add
    implements IAction {
        private final IItemStack output;
        private final IItemStack[] inputs;

        public Add(IItemStack output, IItemStack ... inputs) {
            this.output = output;
            this.inputs = inputs;
        }

        public void apply() {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (ItemStack stack : CraftTweakerMC.getItemStacks((IItemStack[])this.inputs)) {
                list.add(stack);
            }
            AssemblyRecipes.addShapelessRecipe(CraftTweakerMC.getItemStack((IItemStack)this.output), list.toArray());
        }

        public String describe() {
            return "Added Assembly recipe for " + this.output;
        }
    }
}

